/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.handlers.TransferHandler;
import org.gcube.datatransfer.agent.impl.utils.Constants;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;

public class LocalFileTransferAsyncHandler
extends TransferHandler {
    GCUBELog logger = new GCUBELog(this.getClass());

    public LocalFileTransferAsyncHandler(FileObject inputFile, int timeout, String outPath, String transferId, TransferType type, DestData data) {
        this.inputFile = inputFile;
        this.timeout = timeout;
        this.outPath = outPath;
        this.transferId = transferId;
        this.transferType = type;
        this.destData = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long startTime = 0L;
        try {
            URLConnection connection = this.inputFile.getURL().openConnection();
            connection.setConnectTimeout(this.timeout);
            InputStream streamIn = connection.getInputStream();
            String outputFile = this.inputFile.getName().getBaseName();
            String relativeOutputFile = this.outPath + File.separator + outputFile;
            FileObject absoluteOutputFile = ServiceContext.getContext().getLocalFSManager().resolveFile(relativeOutputFile);
            FileObject absolutePath = ServiceContext.getContext().getLocalFSManager().resolveFile(this.outPath);
            absolutePath.createFolder();
            if (absoluteOutputFile.exists() && !this.destData.getOutUri().isOverwrite()) {
                this.logger.error((Object)("the file represented by the URL " + this.inputFile.getURL().toString() + " cannot be copied cause a file with the same name already exists"));
                throw new Exception("the file represented by the URL " + this.inputFile.getURL().toString() + " cannot be copied cause a local file with the same name already exists");
            }
            this.transferObj = TransferUtils.createTransferObjectJDO(this.transferId, this.transferType);
            this.transferObj.setDestURI(absoluteOutputFile.getName().getPath());
            this.transferObj.setSourceURI(this.inputFile.getURL().toString());
            FileOutputStream streamOut = null;
            try {
                streamOut = new FileOutputStream(absoluteOutputFile.getName().getPath());
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
                throw e1;
            }
            this.logger.debug((Object)("Copying file from URL " + this.inputFile.getURL() + " to : " + absoluteOutputFile.getName().getPath()));
            startTime = System.currentTimeMillis();
            IOUtils.copy((InputStream)streamIn, (OutputStream)streamOut);
            streamIn.close();
            ((OutputStream)streamOut).close();
            if (this.destData.getOutUri().isUnzip()) {
                TransferUtils.unzipArchive(absolutePath.getName().getPath(), absoluteOutputFile.getName().getPath());
                absoluteOutputFile.delete();
            }
            this.transferObj.setSize(absoluteOutputFile.getContent().getSize());
            this.transferObj.setStatus(Constants.TransferStatus.DONE.name());
            this.transferObj.setOutcome("File succesfully copied to " + absoluteOutputFile);
            this.logger.debug((Object)("File succesfully copied to " + absoluteOutputFile));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.transferObj.setStatus(Constants.TransferStatus.FAILED.name());
            this.transferObj.setOutcome(e.getMessage());
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.transferObj.setTransferTime(endTime - startTime);
        }
    }
}

