package org.gcube.datatransfer.agent.impl.context;

import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.utils.events.GCUBEProducer;
import org.gcube.datatransfer.agent.impl.db.DataTransferDBManager;
import org.gcube.datatransfer.agent.impl.event.Events;
import org.gcube.datatransfer.agent.impl.event.Events.TransferTopics;
import org.gcube.datatransfer.agent.impl.event.TransferEventConsumer;
import org.gcube.datatransfer.agent.impl.utils.Constants;
import org.gcube.datatransfer.agent.impl.vfs.VFileSystemManager;

/**
 * 
 * 
 * @author Andrea Manzi (CERN)
 * 
 */
public class ServiceContext extends GCUBEServiceContext {

	public static final String JNDI_NAME = "gcube/datatransfer/agent";
	
	protected static final ServiceContext cache = new ServiceContext();
	
	private  boolean useMessaging= false;
	
	private  String dbConfigurationFileName;
	
	private  String vfsRoot;
	
	private VFileSystemManager localFSManager;
	

	private DataTransferDBManager dbManager = null;

	
	private ServiceContext() {}
	
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public String[] getSupportedTransfers() throws Exception{
		String[] transfers = null;

		try {
			transfers = ((String)getProperty("supportedTransfers",true)).split(",");	 
		}catch (RuntimeException e) {
			logger.debug("No Transfers available");
			throw new Exception("No Transfers available");
		}
		return transfers;
	}
	/**
	 * 
	 * @return ServiceContext
	 */
	public static ServiceContext getContext() {
		return cache;
	}

	/**
	 * @return the JNDI name
	 */
	@Override
	public String getJNDIName() {
		return JNDI_NAME;
	}
	
	@Override 
	protected void onInitialisation() throws Exception {
		//read from jndi
		dbConfigurationFileName = ((String)getProperty("dbConfigurationFile",true));
		
		vfsRoot = ((String)getProperty("vfsRoot",true));
		
		localFSManager = new VFileSystemManager(vfsRoot);
		
		this.setUseMessaging(((Boolean)getProperty(Constants.USEMESSAGING_JNDI_NAME)).booleanValue());
		this.dbManager = new DataTransferDBManager();
		
	}
	
	public String getVfsRoot() {
		return vfsRoot;
	}

	

	public DataTransferDBManager getDbManager() {
		return dbManager;
	}

	public void setDbManager(DataTransferDBManager dbManager) {
		this.dbManager = dbManager;
	}

	@Override 
	protected void onReady() throws Exception {
		super.onReady();
		
	
		logger.trace("creating agent resources in all RI scopes");
		
	
		
		List<PortRange> ports=new ArrayList<PortRange>(); 
		ports.add(new PortRange(4000, 4050));           
		try {
					TCPConnectionManager.Init(
					  new TCPConnectionManagerConfig(InetAddress.getLocalHost().getHostName(),
					    ports,                               
					    true                                   
					));
				} catch (UnknownHostException e) {
					e.printStackTrace();
		}
	    TCPConnectionManager.RegisterEntry(new TCPConnectionHandler());      //Register the handler for the gRS2 incoming request
	    TCPConnectionManager.RegisterEntry(new TCPStoreConnectionHandler()); //Register the handler for the gRS2 store incoming request
		
		
		logger.trace("creating transfer subscription");
		
		for (TransferTopics topic :TransferTopics.values()) {
			transferEventproducer.subscribe(new TransferEventConsumer(),topic);
		}
		
		
	}
	
	public boolean getUseMessaging() {
		return useMessaging;
	}

	public void setUseMessaging(boolean useMessaging) {
		this.useMessaging = useMessaging;
	}
	
	public String getDbConfigurationFileName() {
		return dbConfigurationFileName;
	}

	public void setDbConfigurationFileName(String dbConfigurationFileName) {
		this.dbConfigurationFileName = dbConfigurationFileName;
	}

	public VFileSystemManager getLocalFSManager() {
		return localFSManager;
	}


	public static GCUBEProducer<Events.TransferTopics,Object> transferEventproducer = new GCUBEProducer<Events.TransferTopics,Object>();  
	
}