package org.gcube.datatransfer.agent.impl.worker.async;

import gr.uoa.di.madgik.grs.writer.GRS2WriterException;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.handlers.LocalFileTransferAsyncHandler;
import org.gcube.datatransfer.agent.impl.jdo.TransferObject;
import org.gcube.datatransfer.agent.impl.utils.Constants.TransferStatus;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.impl.worker.ASyncWorker;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;

/**
 * 
 * @author andrea
 *
 */
public class LocalFileTransferASyncWorker extends ASyncWorker{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	

	public LocalFileTransferASyncWorker(String tranferID,SourceData source, DestData dest) throws GRS2WriterException, FileSystemException {
		this.transferId = tranferID;
		this.sourceParameters = source;
		this.destParameters = dest;

		
	}

	// TO DO complete DB interactions
	@Override
	public Object call() throws Exception {

		
		String [] urlInputs= sourceParameters.getInputURIs();
		String outPath = destParameters.getOutUri().getOutUris()[0];
		
		Set<TransferObject> transferObjects = new HashSet<TransferObject>();
		ServiceContext.getContext().getDbManager().storeTransfer(TransferUtils.createTransferJDO(transferId));
		
		ThreadGroup threadList = new ThreadGroup(transferId);
		
		for (String urlString : urlInputs) {
			FileObject file = VFS.getManager().resolveFile(urlString);
			LocalFileTransferAsyncHandler transferHandler =
					new LocalFileTransferAsyncHandler(file,timeout,outPath,transferId, 
							TransferType.LocalFileBasedTransfer,destParameters);
			list.add(transferHandler);
			Thread t = new Thread(threadList,transferHandler);
			t.start();
			}
		try {
			Thread tga[] = new Thread[threadList.activeCount()]; 	
			threadList.enumerate(tga);
			
			for (Thread t : tga){
				logger.debug("waiting for thread" + t.getId()); 
				t.join();
			}
			
		}
		catch (Exception e){
			e.printStackTrace();
			throw e;
			
		}
			
		logger.debug("Getting transferOBJ");
		//getting transferObject
		for (LocalFileTransferAsyncHandler t :(ArrayList<LocalFileTransferAsyncHandler>)list)
			transferObjects.add(t.getTransferObj());
			
		//persisting stuff
		try {
			logger.debug("Persisting objects");
			ServiceContext.getContext().getDbManager().storeTransferObject(transferObjects);
			ServiceContext.getContext().getDbManager().updateTransferObjectStatus(transferId,TransferStatus.DONE.name());
		}
		catch (Exception e){
			ServiceContext.getContext().getDbManager().updateTransferObjectStatus(transferId,TransferStatus.FAILED.name());
			e.printStackTrace();
			throw e;
			
		}
		return true;
	}


}
