/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.grs;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FileField;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.common.grs.FileOutcomeRecord;
import org.gcube.datatransfer.common.utils.Utils;

public class GRSFileReader
extends Thread {
    GCUBELog logger = new GCUBELog(GRSFileReader.class);
    private ForwardReader<GenericRecord> reader = null;
    private RecordWriter<GenericRecord> writer = null;
    private File outFolder;
    private boolean overwrite;

    public GRSFileReader(URI locator, File outFolder, boolean overwrite) throws GRS2ReaderException, GRS2WriterException {
        this.reader = new ForwardReader(locator);
        this.writer = new RecordWriter((IWriterProxy)new TCPWriterProxy(), FileOutcomeRecord.fileOutcomeRecordDef, this.reader.getCapacity(), 2, 0.5f);
        this.outFolder = outFolder;
        this.overwrite = overwrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            for (GenericRecord rec : this.reader) {
                File file = null;
                String fileName = "";
                Exception e = null;
                if (rec == null) continue;
                long startTime = 0L;
                long endTime = 0L;
                startTime = System.currentTimeMillis();
                FileField filefield = (FileField)rec.getField("FileField");
                file = filefield.getPayload();
                StringField fileNameField = (StringField)rec.getField("FileNameField");
                fileName = fileNameField.getPayload();
                this.logger.debug((Object)("outFolder: " + this.outFolder));
                this.logger.debug((Object)("FileName: " + fileName));
                if (!this.outFolder.exists()) {
                    this.outFolder.mkdirs();
                }
                if (this.writer.getStatus() != IBuffer.Status.Open) {
                    return;
                }
                endTime = System.currentTimeMillis();
                Long transferTime = endTime - startTime;
                GenericRecord recWriter = new GenericRecord();
                try {
                    if (new File(this.outFolder.getAbsolutePath() + File.separator + fileName).exists() && !this.overwrite) {
                        e = new Exception("A file with name " + fileName + " exists in the destination folder and the overwrite option is set to false");
                    } else {
                        Utils.copyfileToFolder((File)file, (File)this.outFolder, (String)fileName);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    e = ioe;
                }
                recWriter.setFields(new Field[]{new StringField(fileName), e != null ? new StringField(FileOutcomeRecord.Outcome.N_A.name()) : new StringField(fileName), e != null ? new StringField(FileOutcomeRecord.Outcome.ERROR.name()) : new StringField(FileOutcomeRecord.Outcome.DONE.name()), new StringField(transferTime.toString()), e != null ? new StringField(e.toString()) : new StringField(FileOutcomeRecord.Outcome.N_A.name())});
                if (this.writer.put((Record)recWriter, 60L, TimeUnit.SECONDS)) continue;
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                this.reader.close();
                this.writer.close();
            }
            catch (GRS2ReaderException e1) {
                e1.printStackTrace();
            }
            catch (GRS2WriterException e) {
                e.printStackTrace();
            }
        }
    }

    public String getOutcomeLocator() throws GRS2WriterException {
        return this.writer.getLocator().toString();
    }
}

