/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.grs;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.common.grs.FileOutcomeRecord;

public class GRSOutComeWriter {
    GCUBELog logger = new GCUBELog(this.getClass());
    public RecordWriter<GenericRecord> writer = null;

    public GRSOutComeWriter(int capacity) throws GRS2WriterException {
        this.writer = new RecordWriter((IWriterProxy)new TCPWriterProxy(), FileOutcomeRecord.fileOutcomeRecordDef, capacity, 2, 0.5f);
    }

    public void putField(String sourceUrl, String outURL, Long transferTime, Exception ... e) throws GRS2WriterException {
        this.logger.debug((Object)("Writing Outcome for url: " + sourceUrl));
        if (this.writer.getStatus() != IBuffer.Status.Open) {
            return;
        }
        GenericRecord recWriter = new GenericRecord();
        recWriter.setFields(new Field[]{new StringField(sourceUrl.toString()), e.length != 0 ? new StringField(FileOutcomeRecord.Outcome.N_A.name()) : new StringField(outURL), e.length != 0 ? new StringField(FileOutcomeRecord.Outcome.ERROR.name()) : new StringField(FileOutcomeRecord.Outcome.DONE.name()), new StringField(transferTime.toString()), e.length != 0 ? new StringField(e[0].getMessage()) : new StringField(FileOutcomeRecord.Outcome.N_A.name())});
        if (!this.writer.put((Record)recWriter, 60L, TimeUnit.SECONDS)) {
            return;
        }
        this.logger.debug((Object)("Succesfully written Outcome for url: " + sourceUrl));
    }

    public RecordWriter<GenericRecord> getWriter() {
        return this.writer;
    }

    public void setWriter(RecordWriter<GenericRecord> writer) {
        this.writer = writer;
    }

    public void close() throws GRS2WriterException {
        this.writer.close();
    }
}

