/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.datatransfer.agent.impl.handlers.TransferHandler;
import org.gcube.datatransfer.agent.impl.jdo.TransferObject;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;
import org.gcube.datatransfer.common.outcome.TransferStatus;

public class StorageManagerAsyncHandler
extends TransferHandler {
    IClient client = null;

    public StorageManagerAsyncHandler(String[] inputFiles, String outPath, String transferId, TransferType type, IClient client, DestData data, int startIndex, int endIndex) {
        this.inputFiles = inputFiles;
        this.timeout = data.getOutUri().getOptions().getTransferTimeout();
        this.outPath = outPath;
        this.transferId = transferId;
        this.transferType = type;
        this.destData = data;
        this.client = client;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (int i = this.startIndex; i <= this.endIndex; ++i) {
            long startTime = 0L;
            File tmpFile = null;
            TransferObject transferObj = null;
            try {
                transferObj = TransferUtils.createTransferObjectJDO(this.transferId, this.transferType);
                transferObj.setSourceURI(this.inputFiles[i]);
                FileObject inputFile = TransferUtils.prepareFileObject(this.inputFiles[i]);
                URLConnection connection = inputFile.getURL().openConnection();
                connection.setConnectTimeout((int)this.timeout);
                InputStream streamIn = connection.getInputStream();
                try {
                    tmpFile = File.createTempFile("data-transfer", ".tmp");
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    throw e1;
                }
                FileOutputStream streamOut = null;
                try {
                    streamOut = new FileOutputStream(tmpFile);
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                String outputFile = inputFile.getName().getBaseName();
                String absoluteOutputFile = this.outPath + File.separator + outputFile;
                startTime = System.currentTimeMillis();
                IOUtils.copy((InputStream)streamIn, (OutputStream)streamOut);
                streamIn.close();
                streamOut.close();
                this.client.put(true).LFile(tmpFile.getAbsolutePath()).RFile(absoluteOutputFile);
                String outURL = this.client.getUrl().RFile(absoluteOutputFile);
                transferObj.setDestURI(outURL);
                transferObj.setSize(tmpFile.getTotalSpace());
                transferObj.setStatus(TransferStatus.DONE.name());
                transferObj.setOutcome("File succesfully copied to " + outURL);
                this.logger.debug((Object)("File succesfully copied to " + outURL));
                continue;
            }
            catch (Exception e) {
                transferObj.setStatus(TransferStatus.FAILED.name());
                transferObj.setOutcome(e.toString());
                e.printStackTrace();
                this.errorHappened = true;
                continue;
            }
            finally {
                long endTime = System.currentTimeMillis();
                transferObj.setTransferTime(endTime - startTime);
                tmpFile.delete();
                this.transferObjs.add(transferObj);
            }
        }
    }
}

