/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.worker.async;

import java.util.HashSet;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.handlers.LocalFileTransferAsyncHandler;
import org.gcube.datatransfer.agent.impl.handlers.TransferHandler;
import org.gcube.datatransfer.agent.impl.jdo.TransferObject;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.impl.worker.ASyncWorker;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;
import org.gcube.datatransfer.common.outcome.TransferStatus;

public class LocalFileTransferASyncWorker
extends ASyncWorker {
    private static final long serialVersionUID = 1L;

    public LocalFileTransferASyncWorker(String tranferID, SourceData source, DestData dest) {
        this.transferId = tranferID;
        this.sourceParameters = source;
        this.destParameters = dest;
    }

    public Object call() throws Exception {
        String[] urlInputs = this.sourceParameters.getInputURIs();
        String outPath = this.destParameters.getOutUri().getOutUris()[0];
        HashSet<TransferObject> transferObjects = new HashSet<TransferObject>();
        long totalsize = 0L;
        try {
            totalsize = TransferUtils.getTotalSize(urlInputs);
        }
        catch (Exception e) {
            this.logger.equals("Error getting object size");
            this.errorHappened = true;
        }
        ServiceContext.getContext().getDbManager().updateTransferJDO(this.transferId, urlInputs, totalsize);
        ThreadGroup threadList = new ThreadGroup(this.transferId);
        int nPartitions = urlInputs.length / 100;
        int mod = urlInputs.length % 100;
        int startIndex = 0;
        int endIndex = 0;
        System.out.println("Numnber of partitions : " + nPartitions);
        for (int j = 0; j < nPartitions; ++j) {
            startIndex = j * 100;
            endIndex = startIndex + 100 - 1;
            LocalFileTransferAsyncHandler transferHandler = new LocalFileTransferAsyncHandler(urlInputs, outPath, this.transferId, TransferType.LocalFileBasedTransfer, this.destParameters, startIndex, endIndex);
            this.list.add(transferHandler);
            Thread t = new Thread(threadList, transferHandler);
            t.start();
        }
        if (mod != 0) {
            LocalFileTransferAsyncHandler transferHandler = new LocalFileTransferAsyncHandler(urlInputs, outPath, this.transferId, TransferType.LocalFileBasedTransfer, this.destParameters, endIndex, endIndex + mod - 1);
            this.list.add(transferHandler);
            Runnable t = new Thread(threadList, transferHandler);
            ((Thread)t).start();
        }
        try {
            Thread[] tga = new Thread[threadList.activeCount()];
            threadList.enumerate(tga);
            for (Thread t : tga) {
                this.logger.debug((Object)("waiting for thread" + t.getId()));
                t.join();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        this.logger.debug((Object)"Getting transferOBJList");
        for (Runnable t : this.list) {
            transferObjects.addAll(((TransferHandler)t).getTransferObjList());
            if (this.errorHappened) continue;
            this.errorHappened = ((TransferHandler)t).isErrorHappened();
        }
        try {
            this.logger.debug((Object)"Persisting objects");
            ServiceContext.getContext().getDbManager().storeTransferObject(transferObjects);
            if (this.errorHappened) {
                ServiceContext.getContext().getDbManager().updateTransferObjectStatus(this.transferId, TransferStatus.DONE_WITH_ERRORS.name());
            } else {
                ServiceContext.getContext().getDbManager().updateTransferObjectStatus(this.transferId, TransferStatus.DONE.name());
            }
        }
        catch (Exception e) {
            ServiceContext.getContext().getDbManager().updateTransferObjectStatus(this.transferId, TransferStatus.FAILED.name());
            e.printStackTrace();
            throw e;
        }
        return true;
    }
}

