/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.worker.async;

import java.util.HashSet;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.handlers.StorageManagerAsyncHandler;
import org.gcube.datatransfer.agent.impl.handlers.TransferHandler;
import org.gcube.datatransfer.agent.impl.jdo.TransferObject;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.impl.worker.ASyncWorker;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StorageManagerDetails;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;
import org.gcube.datatransfer.common.outcome.TransferStatus;

public class StorageManagerASyncWorker
extends ASyncWorker {
    private static final long serialVersionUID = 1L;
    private IClient client;

    public StorageManagerASyncWorker(String id, SourceData source, DestData dest) throws Exception {
        this.sourceParameters = source;
        this.destParameters = dest;
        this.transferId = id;
        StorageManagerDetails details = dest.getOutUri().getOptions().getStorageManagerDetails();
        if (details == null) {
            throw new Exception("Missing storage Manager configuration details");
        }
        this.client = new StorageClient(details.getServiceClass(), details.getServiceName(), details.getOwner(), AccessType.valueOf((String)details.getAccessType().getValue()), GCUBEScope.getScope((String)source.getScope())).getClient();
    }

    public Object call() throws Exception {
        String[] urlInputs = this.sourceParameters.getInputURIs();
        String outPath = this.destParameters.getOutUri().getOutUris()[0];
        HashSet<TransferObject> transferObjects = new HashSet<TransferObject>();
        long totalsize = TransferUtils.getTotalSize(urlInputs);
        ServiceContext.getContext().getDbManager().updateTransferJDO(this.transferId, urlInputs, totalsize);
        try {
            ThreadGroup threadList = new ThreadGroup(this.transferId);
            int nPartitions = urlInputs.length / 100;
            int mod = urlInputs.length % 100;
            int startIndex = 0;
            int endIndex = 0;
            for (int j = 0; j < nPartitions; ++j) {
                startIndex = j * 100;
                endIndex = startIndex + 100 - 1;
                StorageManagerAsyncHandler transferHandler = new StorageManagerAsyncHandler(urlInputs, outPath, this.transferId, TransferType.FileBasedTransfer, this.client, this.destParameters, startIndex, endIndex);
                this.list.add(transferHandler);
                Thread t = new Thread(threadList, transferHandler);
                t.start();
            }
            if (mod != 0) {
                StorageManagerAsyncHandler transferHandler = new StorageManagerAsyncHandler(urlInputs, outPath, this.transferId, TransferType.FileBasedTransfer, this.client, this.destParameters, endIndex, endIndex + mod - 1);
                this.list.add(transferHandler);
                Runnable t = new Thread(threadList, transferHandler);
                ((Thread)t).start();
            }
            try {
                Thread[] tga = new Thread[threadList.activeCount()];
                threadList.enumerate(tga);
                for (Thread t : tga) {
                    this.logger.debug((Object)("waiting for thread" + t.getId()));
                    t.join();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            this.logger.debug((Object)"Getting transferOBJ");
            for (Runnable t : this.list) {
                transferObjects.addAll(((TransferHandler)t).getTransferObjList());
                if (this.errorHappened) continue;
                this.errorHappened = ((TransferHandler)t).isErrorHappened();
            }
            this.logger.debug((Object)"Persisting objects");
            ServiceContext.getContext().getDbManager().storeTransferObject(transferObjects);
            if (this.errorHappened) {
                ServiceContext.getContext().getDbManager().updateTransferObjectStatus(this.transferId, TransferStatus.DONE_WITH_ERRORS.name());
            } else {
                ServiceContext.getContext().getDbManager().updateTransferObjectStatus(this.transferId, TransferStatus.DONE.name());
            }
        }
        catch (Exception e) {
            ServiceContext.getContext().getDbManager().updateTransferObjectStatus(this.transferId, TransferStatus.FAILED.name());
            e.printStackTrace();
            return e;
        }
        return true;
    }
}

