/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.common.messaging.messages;

import java.net.URI;
import java.util.ArrayList;
import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.datatransfer.common.agent.Types;
import org.gcube.datatransfer.common.messaging.messages.MessageLabels;
import org.gcube.datatransfer.common.messaging.utils.Utils;

public class TransferRequestMessage
extends GCUBEMessage {
    private String sourceEndpoint;
    private String destEndpoint;
    private String transferId;
    private ArrayList<URI> inputUris;
    private ArrayList<URI> outputUris;
    private String destination;
    private Types.TransferOptions transferOptions;
    public static final String dataTransferLabel = MessageLabels.DataTransferRequest.toString();

    public void createTopicName(GCUBEScope scope) {
        String destination = "";
        if (this.destEndpoint != null) {
            destination = "." + this.destEndpoint;
        }
        if (scope.isInfrastructure()) {
            this.topic = Utils.replaceUnderscore(scope.getName()) + "." + dataTransferLabel + destination + "." + Utils.replaceUnderscore(this.sourceEndpoint);
        } else if (scope.getType().compareTo((Enum)GCUBEScope.Type.VO) == 0) {
            String voName = scope.getName();
            this.topic = Utils.replaceUnderscore(scope.getInfrastructure().getName()) + "." + Utils.replaceUnderscore(voName) + "." + dataTransferLabel + destination + "." + Utils.replaceUnderscore(this.sourceEndpoint);
        }
    }

    public String getSourceEndpoint() {
        return this.sourceEndpoint;
    }

    public String getDestEndpoint() {
        return this.destEndpoint;
    }

    public String getTransferId() {
        return this.transferId;
    }

    public ArrayList<URI> getInputUris() {
        return this.inputUris;
    }

    public ArrayList<URI> getOutputUris() {
        return this.outputUris;
    }

    public String getDestination() {
        return this.destination;
    }

    public Types.TransferOptions getTransferOptions() {
        return this.transferOptions;
    }

    public void setSourceEndpoint(String sourceEndpoint) {
        this.sourceEndpoint = sourceEndpoint;
    }

    public void setDestEndpoint(String destEndpoint) {
        this.destEndpoint = destEndpoint;
    }

    public void setTransferId(String transferId) {
        this.transferId = transferId;
    }

    public void setInputUris(ArrayList<URI> inputUris) {
        this.inputUris = inputUris;
    }

    public void setOutputUris(ArrayList<URI> outputUris) {
        this.outputUris = outputUris;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setTransferOptions(Types.TransferOptions transferOptions) {
        this.transferOptions = transferOptions;
    }
}

