/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.library.model;

import java.net.HttpURLConnection;
import java.net.URL;
import org.gcube.data.transfer.library.faults.InvalidSourceException;
import org.gcube.data.transfer.library.model.Source;

public class URLSource
extends Source<URL> {
    private URL theURL = null;

    public URLSource(URL theURL) throws InvalidSourceException {
        if (theURL == null) {
            throw new InvalidSourceException("URL Source cannot be null");
        }
        this.theURL = theURL;
    }

    @Override
    public boolean validate() throws InvalidSourceException {
        try {
            HttpURLConnection conn = (HttpURLConnection)this.theURL.openConnection();
            conn.setConnectTimeout(3000);
            conn.setRequestMethod("HEAD");
            int responseCode = conn.getResponseCode();
            return 200 <= responseCode && responseCode <= 399;
        }
        catch (Exception e) {
            throw new InvalidSourceException("Unable to contact URL " + this.theURL, e);
        }
    }

    @Override
    public void prepare() {
    }

    @Override
    public void clean() {
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("URLSource [theURL=");
        builder.append(this.theURL);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public URL getTheSource() {
        return this.theURL;
    }
}

