/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.service.transfers.engine.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import org.gcube.data.transfer.model.Destination;
import org.gcube.data.transfer.model.DestinationClashPolicy;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.model.TransferRequest;
import org.gcube.data.transfer.model.TransferTicket;
import org.gcube.data.transfer.model.options.TransferOptions;
import org.gcube.data.transfer.model.settings.HttpDownloadSettings;
import org.gcube.data.transfer.service.transfers.engine.PersistenceProvider;
import org.gcube.data.transfer.service.transfers.engine.PluginManager;
import org.gcube.data.transfer.service.transfers.engine.TicketManager;
import org.gcube.data.transfer.service.transfers.engine.faults.DestinationAccessException;
import org.gcube.data.transfer.service.transfers.engine.faults.ManagedException;
import org.gcube.data.transfer.service.transfers.engine.faults.NotSupportedMethodException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RequestHandler
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RequestHandler.class);
    private TransferTicket ticket;
    private PersistenceProvider persistenceProvider;
    private PluginManager pluginManager;
    private TicketManager ticketManager;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$data$transfer$model$options$TransferOptions$TransferMethod;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$data$transfer$model$DestinationClashPolicy;

    public RequestHandler(TransferRequest servingRequest, TicketManager ticketManager, PersistenceProvider persistenceProvider, PluginManager pluginManager) {
        this.ticket = new TransferTicket(servingRequest);
        log.debug("Created Handler, request is : " + servingRequest);
        this.ticketManager = ticketManager;
        this.persistenceProvider = persistenceProvider;
        this.pluginManager = pluginManager;
        ticketManager.insertUpdate(this.ticket);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block23: {
            try {
                RequestHandler.log.trace("Request handling started. Ticket is " + this.ticket);
                switch (RequestHandler.$SWITCH_TABLE$org$gcube$data$transfer$model$options$TransferOptions$TransferMethod()[this.ticket.getSettings().getOptions().getMethod().ordinal()]) {
                    case 2: {
                        throw new NotSupportedMethodException("Unable to manage request [ID " + this.ticket.getId() + "]. Method not supported : " + this.ticket.getSettings().getOptions().getMethod());
                    }
                    case 1: {
                        output = null;
                        in = null;
                        var3_6 = null;
                        complete = false;
                        try {
                            this.updateTicket("Opening connection", 0.0, TransferTicket.Status.TRANSFERRING, 0L);
                            options = (HttpDownloadSettings)this.ticket.getSettings();
                            RequestHandler.log.debug("HttpDownload, opening channel");
                            try {
                                output = this.prepareDestination(this.ticket.getDestinationSettings());
                                var3_7 = new BufferedOutputStream(new FileOutputStream(output));
                            }
                            catch (IOException e) {
                                RequestHandler.log.warn("Unable to create destination file.", (Throwable)e);
                                throw new ManagedException("Cannot save file in host");
                            }
                            RequestHandler.log.debug("Opening read buffer " + options.getSource().toString());
                            this.ticket.setDestinationFileName(output.getAbsolutePath());
                            try {
                                in = new BufferedInputStream(options.getSource().openStream());
                            }
                            catch (Exception e) {
                                RequestHandler.log.debug("Unable to open connection ", (Throwable)e);
                                throw new ManagedException("Cannot open connection to source");
                            }
                            receivedTotal = 0L;
                            try {
                                internalBuf = new byte[1024];
                                received = 0;
                                while ((received = in.read(internalBuf)) != -1) {
                                    var3_7.write(internalBuf, 0, received);
                                    this.updateTicket("Transferring", 0.0, TransferTicket.Status.TRANSFERRING, receivedTotal += (long)received);
                                }
                            }
                            catch (IOException e) {
                                RequestHandler.log.debug("Unable to read from source", (Throwable)e);
                                throw new ManagedException("Unable to read from source.");
                            }
                            RequestHandler.log.debug("Completed transfer phase for ticket ID {}. Transferred {} bytes. ", (Object)this.ticket.getId(), (Object)receivedTotal);
                            complete = true;
                        }
                        catch (Throwable var10_19) {
                            RequestHandler.log.debug("Finalizing transfer, ticket ID {} ", (Object)this.ticket.getId());
                            if (var3_6 != null) {
                                RequestHandler.log.debug("Closing output stream..");
                                var3_6.flush();
                                var3_6.close();
                            }
                            if (in != null) {
                                RequestHandler.log.debug("Closing input stream..");
                                in.close();
                            }
                            if (complete != false) throw var10_19;
                            if (output == null) throw var10_19;
                            RequestHandler.log.debug("Removing incomplete transfer..");
                            Files.deleteIfExists(null);
                            throw var10_19;
                        }
                        RequestHandler.log.debug("Finalizing transfer, ticket ID {} ", (Object)this.ticket.getId());
                        if (var3_7 != null) {
                            RequestHandler.log.debug("Closing output stream..");
                            var3_7.flush();
                            var3_7.close();
                        }
                        if (in != null) {
                            RequestHandler.log.debug("Closing input stream..");
                            in.close();
                        }
                        if (complete || output == null) break;
                        RequestHandler.log.debug("Removing incomplete transfer..");
                        Files.deleteIfExists(null);
                        break;
                    }
                }
                if (this.ticket.getPluginInvocations() == null) ** GOTO lbl83
                var2_5 = this.ticket.getPluginInvocations().iterator();
lbl75:
                // 2 sources

                while (true) {
                    block24: {
                        if (!var2_5.hasNext()) break block24;
                        invocation = (PluginInvocation)var2_5.next();
                        RequestHandler.log.debug("Execution {}", (Object)invocation);
                        if (!invocation.getParameters().containsValue("*******USE_DESTINATION_FILE_PATH*********")) break block23;
                        RequestHandler.log.debug("Checking for param value : *******USE_DESTINATION_FILE_PATH*********");
                        var4_11 = invocation.getParameters().entrySet().iterator();
                        if (true) ** GOTO lbl101
                    }
                    this.updateTicket("Completed transfer", 1.0, TransferTicket.Status.SUCCESS);
                    return;
                }
            }
            catch (NotSupportedMethodException e) {
                this.setError(e.getMessage());
                return;
            }
            catch (ManagedException e) {
                this.setError(e.getMessage());
                return;
            }
            catch (Throwable t) {
                this.setError("Unexpected error while downloading : " + t.getMessage());
                RequestHandler.log.error("Unexpected error occurred", t);
            }
            return;
            do {
                if (!((String)(var3_9 = var4_11.next()).getValue()).equals("*******USE_DESTINATION_FILE_PATH*********")) continue;
                RequestHandler.log.debug("Setting {} = {} ", var3_9.getKey(), (Object)this.ticket.getDestinationFileName());
                var3_9.setValue(this.ticket.getDestinationFileName());
lbl101:
                // 3 sources

            } while (var4_11.hasNext());
        }
        this.updateTicket("Executing invocation " + invocation.getPluginId(), 1.0, TransferTicket.Status.PLUGIN_EXECUTION);
        this.pluginManager.execute(invocation);
        ** while (true)
    }

    private void setError(String message) {
        this.updateTicket(message, this.ticket.getPercent(), TransferTicket.Status.ERROR);
    }

    private void updateTicket(String message, double percent, TransferTicket.Status status) {
        this.updateTicket(message, percent, status, this.ticket.getTransferredBytes());
    }

    private void updateTicket(String message, double percent, TransferTicket.Status status, long readBytes) {
        this.ticket.setStatus(status);
        this.ticket.setMessage(message);
        this.ticket.setPercent(percent);
        this.ticket.setTransferredBytes(readBytes);
        try {
            long elapsedTime = System.currentTimeMillis() - this.ticket.getSubmissionTime().getValue().getTimeInMillis();
            long average = readBytes / (elapsedTime == 0L ? 1L : elapsedTime) * 1000L;
            this.ticket.setAverageTransferSpeed(average);
        }
        catch (Exception e) {
            log.warn("Unable to evaluate average ", (Throwable)e);
        }
        this.ticketManager.insertUpdate(this.ticket);
    }

    private File prepareDestination(Destination dest) throws DestinationAccessException {
        File destination;
        File persistenceFolder = this.persistenceProvider.getPersistenceFolderById(dest.getPersistenceId());
        if (!persistenceFolder.canWrite()) {
            throw new DestinationAccessException("Cannot write to selecte persistenceFolder [ID :" + dest.getPersistenceId() + "]");
        }
        log.debug("Got Persistence folder ID {}, PATH {}", (Object)persistenceFolder.getAbsolutePath(), (Object)dest.getPersistenceId());
        String subFolderName = dest.getSubFolder();
        File subFolder = persistenceFolder;
        if (subFolderName != null) {
            log.debug("Looking for subFolder : " + subFolder);
            if (subFolderName.startsWith(File.pathSeparator)) {
                throw new DestinationAccessException("SubFolder cannot be absolute.");
            }
            subFolder = new File(persistenceFolder, subFolderName);
            if (subFolder.exists()) {
                if (!subFolder.canRead()) {
                    throw new DestinationAccessException("Cannot write to " + subFolder.getAbsolutePath());
                }
                RequestHandler.manageClash((DestinationClashPolicy)dest.getOnExistingSubFolder(), (File)subFolder);
            } else if (dest.getCreateSubfolders().booleanValue()) {
                subFolder.mkdirs();
            } else {
                throw new DestinationAccessException("SubFolder not found. Use createSubFolders=true to create it.");
            }
        }
        if ((destination = new File(subFolder, dest.getDestinationFileName())).exists()) {
            return RequestHandler.manageClash((DestinationClashPolicy)dest.getOnExistingFileName(), (File)destination);
        }
        try {
            destination.createNewFile();
            return destination;
        }
        catch (IOException e) {
            throw new DestinationAccessException("Unable to create file ", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public static final File manageClash(DestinationClashPolicy policy, File clashing) throws DestinationAccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$data$transfer$model$options$TransferOptions$TransferMethod() {
        if ($SWITCH_TABLE$org$gcube$data$transfer$model$options$TransferOptions$TransferMethod != null) {
            return $SWITCH_TABLE$org$gcube$data$transfer$model$options$TransferOptions$TransferMethod;
        }
        int[] nArray = new int[TransferOptions.TransferMethod.values().length];
        try {
            nArray[TransferOptions.TransferMethod.DirectTransfer.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TransferOptions.TransferMethod.HTTPDownload.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$gcube$data$transfer$model$options$TransferOptions$TransferMethod = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$data$transfer$model$DestinationClashPolicy() {
        if ($SWITCH_TABLE$org$gcube$data$transfer$model$DestinationClashPolicy != null) {
            return $SWITCH_TABLE$org$gcube$data$transfer$model$DestinationClashPolicy;
        }
        int[] nArray = new int[DestinationClashPolicy.values().length];
        try {
            nArray[DestinationClashPolicy.ADD_SUFFIX.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DestinationClashPolicy.APPEND.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DestinationClashPolicy.FAIL.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DestinationClashPolicy.REWRITE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$gcube$data$transfer$model$DestinationClashPolicy = nArray;
        return nArray;
    }
}

