/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.service.transfers.engine.impl;

import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractStorageUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord;
import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.data.transfer.service.transfers.engine.AccountingManager;
import org.gcube.data.transfer.service.transfers.engine.impl.TokenUtils;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.records.Record;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingManagerImpl
implements AccountingManager {
    private static final Logger log = LoggerFactory.getLogger(AccountingManagerImpl.class);
    private static final Object $LOCK = new Object[0];
    private static AccountingManagerImpl instance = null;
    private ConcurrentHashMap<String, StorageUsageRecord> records = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final AccountingManagerImpl get() {
        Object object = $LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new AccountingManagerImpl();
            }
            return instance;
        }
    }

    public String createNewRecord() {
        try {
            StorageUsageRecord newer = this.initRecord();
            log.debug("Created record : {} ", (Object)newer);
            this.records.put(newer.getId(), newer);
            return newer.getId();
        }
        catch (Throwable t) {
            log.warn("Unable to register new record ", t);
            return "fake";
        }
    }

    private StorageUsageRecord getById(String recordId) {
        try {
            return (StorageUsageRecord)this.records.get(recordId);
        }
        catch (Throwable t) {
            log.warn("Unable to locate Accountind record with id {} ", (Object)recordId, (Object)t);
            return null;
        }
    }

    public void account(String toAccountRecordId) {
        StorageUsageRecord record = null;
        try {
            record = this.getById(toAccountRecordId);
            AccountingPersistence persistence = AccountingPersistenceFactory.getPersistence();
            persistence.account((Record)record);
        }
        catch (Throwable e) {
            log.warn("Unable to account record {}.", (Object)record, (Object)e);
        }
        try {
            this.records.remove(toAccountRecordId);
        }
        catch (Throwable t) {
            log.warn("Unable to remove record by id {} ", (Object)toAccountRecordId, (Object)t);
        }
    }

    public void setSuccessful(String id, boolean succesfull) {
        try {
            this.getById(id).setOperationResult(succesfull ? UsageRecord.OperationResult.SUCCESS : UsageRecord.OperationResult.FAILED);
        }
        catch (Throwable e) {
            log.warn("Unable to update record {}.", (Object)this.getById(id), (Object)e);
        }
    }

    public void setRead(String id) {
        try {
            this.getById(id).setOperationType(AbstractStorageUsageRecord.OperationType.READ);
        }
        catch (Throwable e) {
            log.warn("Unable to update record {}.", (Object)this.getById(id), (Object)e);
        }
    }

    public void setCreate(String id) {
        try {
            this.getById(id).setOperationType(AbstractStorageUsageRecord.OperationType.CREATE);
        }
        catch (Throwable e) {
            log.warn("Unable to update record {}.", (Object)this.getById(id), (Object)e);
        }
    }

    public void setDelete(String id) {
        try {
            this.getById(id).setOperationType(AbstractStorageUsageRecord.OperationType.DELETE);
        }
        catch (Throwable e) {
            log.warn("Unable to update record {}.", (Object)this.getById(id), (Object)e);
        }
    }

    public void setUpdate(String id) {
        try {
            this.getById(id).setOperationType(AbstractStorageUsageRecord.OperationType.UPDATE);
        }
        catch (Throwable e) {
            log.warn("Unable to update record {}.", (Object)this.getById(id), (Object)e);
        }
    }

    public void setResourceURI(String id, String uri) {
        try {
            this.getById(id).setResourceURI(new URI(uri));
        }
        catch (Throwable e) {
            log.warn("Unable to update record {}.", (Object)this.getById(id), (Object)e);
        }
    }

    public void setVolumne(String id, long volume) {
        try {
            this.getById(id).setDataVolume(volume);
        }
        catch (InvalidValueException e) {
            log.warn("Unable to update record {}.", (Object)this.getById(id), (Object)e);
        }
    }

    public void setMimeType(String id, String mimeType) {
        try {
            this.getById(id).setQualifier(mimeType);
        }
        catch (InvalidValueException e) {
            log.warn("Unable to update record {}.", (Object)this.getById(id), (Object)e);
        }
    }

    private StorageUsageRecord initRecord() {
        StorageUsageRecord record = new StorageUsageRecord();
        try {
            String currentUser = TokenUtils.getCurrentUser();
            record.setConsumerId(currentUser);
            record.setResourceOwner(currentUser);
            record.setResourceScope(record.getScope());
            ApplicationContext context = ContextProvider.get();
            ContainerConfiguration configuration = context.container().configuration();
            String hostName = configuration.hostname();
            record.setProviderURI(new URI(hostName));
            record.setDataType(AbstractStorageUsageRecord.DataType.OTHER);
        }
        catch (Throwable t) {
            log.warn("Unable to create account record, returning empty one : {} ", (Object)record, (Object)t);
        }
        return record;
    }
}

