/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jdo.PersistenceManagerFactory;
import org.gcube.common.core.utils.logging.GCUBELog;

public abstract class DBManager {
    GCUBELog logger = new GCUBELog(DBManager.class);
    protected PersistenceManagerFactory persistenceFactory;
    protected static File backupFolder = null;
    protected static Properties prop = null;
    protected String dbFileBaseFolder;
    protected String dbFileName;
    protected String dbName;
    protected static int backupIntervalMS;

    public synchronized void close() throws Exception {
        this.persistenceFactory.getPersistenceManager().getDataStoreConnection().close();
    }

    public synchronized boolean startBackUp() {
        String dbName = null;
        String dbUserName = null;
        String dbPassword = null;
        String path = null;
        int numberOfBackups = 0;
        try {
            dbName = this.getDBName();
            dbUserName = this.getUsername();
            dbPassword = this.getPass();
            path = backupFolder.getAbsolutePath();
            numberOfBackups = Integer.valueOf(this.getNumberOfBackups());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug((Object)"startBackUp - Exception right before back up procedure...");
            return false;
        }
        if (dbName == null || dbUserName == null || dbPassword == null || path == null || numberOfBackups == 0) {
            this.logger.debug((Object)"startBackUp - One of these parameters are null/0 : \ndbName/dbUserNamedb/Password/path/numberOfBackups\ncheck db.properties file ... ");
            return false;
        }
        return this.backupDB(dbName, dbUserName, dbPassword, path, numberOfBackups);
    }

    private synchronized boolean backupDB(String dbName, String dbUserName, String dbPassword, String path, int numberOfBackups) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        String backupFilePath = this.getBackupFilePath(path, dbName, numberOfBackups);
        String executeCmd = "mysql -u " + dbUserName + " -p " + dbPassword + " " + dbName + " > " + backupFilePath;
        String[] executeCmdArray = new String[]{"/bin/sh", "-c", executeCmd};
        try {
            Process runtimeProcess = Runtime.getRuntime().exec(executeCmdArray);
            runtimeProcess.waitFor();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.debug((Object)"Could not create the backup");
            return false;
        }
        this.logger.debug((Object)"Backup created successfully");
        return true;
    }

    private synchronized String getBackupFilePath(String path, String dbName, int maxBackup) {
        int num;
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdirs();
            return path + dbName + ".sql";
        }
        for (num = 0; num < maxBackup; ++num) {
            String backupFile = null;
            backupFile = num == 0 ? dbName + ".sql" : dbName + "_" + num + ".sql";
            String backupFilePath = path + backupFile;
            File tmpFile = new File(backupFilePath);
            if (tmpFile.exists()) continue;
            return backupFilePath;
        }
        Date present = new Date();
        long oldModifiedFile = present.getTime();
        String olderBackupFilePath = "";
        for (num = 0; num < maxBackup; ++num) {
            String backupFile = null;
            backupFile = num == 0 ? dbName + ".sql" : dbName + "_" + num + ".sql";
            String backupFilePath = path + backupFile;
            File tmpFile = new File(backupFilePath);
            long lastMofidied = tmpFile.lastModified();
            if (num == 0) {
                oldModifiedFile = lastMofidied;
                olderBackupFilePath = backupFilePath;
                continue;
            }
            if (lastMofidied >= oldModifiedFile) continue;
            oldModifiedFile = lastMofidied;
            olderBackupFilePath = backupFilePath;
        }
        Date oldBackupDate = new Date(oldModifiedFile);
        return olderBackupFilePath;
    }

    protected void zipFolder(File[] files) throws Exception {
        byte[] buf = new byte[1024];
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmssZ");
        String outFilename = backupFolder + File.separator + dateFormat.format(new Date().getTime()) + ".zip";
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFilename));
        for (int i = 0; i < files.length; ++i) {
            int len;
            FileInputStream in = new FileInputStream(files[i]);
            out.putNextEntry(new ZipEntry(files[i].getAbsolutePath()));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            in.close();
        }
        out.close();
        this.logger.debug((Object)("DB Backup created @ " + outFilename));
    }

    private synchronized String getDBName() {
        if (prop == null) {
            this.logger.debug((Object)"prop is null");
            return null;
        }
        String value = null;
        value = prop.getProperty("datanucleus.ConnectionURL");
        if (value == null) {
            return null;
        }
        String[] parts = value.split("/");
        return parts[parts.length - 1];
    }

    private synchronized String getUsername() {
        if (prop == null) {
            this.logger.debug((Object)"prop is null");
            return null;
        }
        String value = null;
        value = prop.getProperty("javax.jdo.option.ConnectionUserName");
        return value;
    }

    private synchronized String getPass() {
        if (prop == null) {
            this.logger.debug((Object)"prop is null");
            return null;
        }
        String value = null;
        value = prop.getProperty("javax.jdo.option.ConnectionPassword");
        return value;
    }

    private synchronized String getNumberOfBackups() {
        if (prop == null) {
            this.logger.debug((Object)"prop is null");
            return null;
        }
        String value = null;
        value = prop.getProperty("datanucleus.numberOfBackUps");
        return value;
    }

    public synchronized String getScheduledBackupInHours() {
        if (prop == null) {
            this.logger.debug((Object)"prop is null");
            return null;
        }
        String value = null;
        value = prop.getProperty("datanucleus.scheduledBackupInHours");
        return value;
    }

    public static interface BaseConsumer {
        public void consume(ResultSet var1) throws Exception;
    }
}

