/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.is;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jdo.Extent;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.DataSource;
import org.gcube.datatransfer.scheduler.db.model.DataStorage;

public class ISManager<T> {
    private static final UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
    public T t;
    public DataTransferDBManager dbManager;
    public String scope;

    public ISManager(DataTransferDBManager dbManager, String scope) {
        this.dbManager = dbManager;
        this.scope = scope;
        this.t = new Object();
    }

    public void updateObjsInDB() {
        int newContentInDB = 0;
        int oldContentInDB = 0;
        String typeOfISManager = null;
        List<String> resultsFromIS = this.getObjsFromIS();
        String delimiter = "--";
        for (String tmpResult : resultsFromIS) {
            String idOfObjInDB;
            String[] tmpSplitResult = tmpResult.split(delimiter);
            String ServiceName = tmpSplitResult[0];
            String resultIdOfIS = tmpSplitResult[1];
            String host = tmpSplitResult[2];
            String port = tmpSplitResult[3];
            if (this.checkIfObjExistsInDB_ById(resultIdOfIS) != null) {
                idOfObjInDB = this.checkIfObjExistsInDB_ById(resultIdOfIS);
                String statusOfObj = null;
                if (this.t.getClass().isInstance(Agent.class)) {
                    statusOfObj = ((Agent)this.dbManager.getPersistenceManager().getObjectById(Agent.class, (Object)idOfObjInDB)).getStatus();
                    typeOfISManager = "for Agents";
                } else if (this.t.getClass().isInstance(DataSource.class)) {
                    statusOfObj = ((DataSource)this.dbManager.getPersistenceManager().getObjectById(DataSource.class, (Object)idOfObjInDB)).getStatus();
                    typeOfISManager = "for DataSources";
                } else if (this.t.getClass().isInstance(DataStorage.class)) {
                    statusOfObj = ((DataStorage)this.dbManager.getPersistenceManager().getObjectById(DataStorage.class, (Object)idOfObjInDB)).getStatus();
                    typeOfISManager = "for DataStorages";
                } else {
                    System.out.println("ISManager - updateObjsInDB - Error - there is no class with this name");
                }
                if (statusOfObj.compareTo("DOWN") != 0) continue;
                ++newContentInDB;
                try {
                    if (this.t.getClass().isInstance(Agent.class)) {
                        this.dbManager.updateAgentStatus(idOfObjInDB, "UP");
                        continue;
                    }
                    if (this.t.getClass().isInstance(DataSource.class)) {
                        this.dbManager.updateSourceStatus(idOfObjInDB, "UP");
                        continue;
                    }
                    if (this.t.getClass().isInstance(DataStorage.class)) {
                        this.dbManager.updateStorageStatus(idOfObjInDB, "UP");
                        continue;
                    }
                    System.out.println("ISManager - updateObjsInDB - Error - there is no class with this name");
                }
                catch (Exception e) {
                    System.out.println("ISManager - updateObjsInDB - Exception in updating the status");
                    e.printStackTrace();
                }
                continue;
            }
            ++newContentInDB;
            idOfObjInDB = this.setObjToDB(resultIdOfIS, host, port);
            if (idOfObjInDB != null) continue;
            System.out.println("ISManager - updateObjsInDB - Error in storing the new obj in DB");
        }
        try {
            Extent resultExtent = null;
            if (this.t.getClass().isInstance(Agent.class)) {
                resultExtent = this.dbManager.getPersistenceManager().getExtent(Agent.class, true);
            } else if (this.t.getClass().isInstance(DataSource.class)) {
                resultExtent = this.dbManager.getPersistenceManager().getExtent(DataSource.class, true);
            } else if (this.t.getClass().isInstance(DataStorage.class)) {
                resultExtent = this.dbManager.getPersistenceManager().getExtent(DataStorage.class, true);
            } else {
                System.out.println("ISManager - updateObjsInDB - Error - there is no class with this name");
            }
            Iterator iter = resultExtent.iterator();
            String idOfObj = null;
            String idOfObjOfIS = null;
            while (iter.hasNext()) {
                String resultStatus;
                Object obj = iter.next();
                if (this.t.getClass().isInstance(Agent.class)) {
                    resultStatus = ((Agent)obj).getStatus();
                    if (resultStatus.compareTo("DOWN") == 0) continue;
                    idOfObj = ((Agent)obj).getAgentId();
                    idOfObjOfIS = ((Agent)obj).getAgentIdOfIS();
                } else if (this.t.getClass().isInstance(DataSource.class)) {
                    resultStatus = ((DataSource)obj).getStatus();
                    if (resultStatus.compareTo("DOWN") == 0) continue;
                    idOfObj = ((DataSource)obj).getDataSourceId();
                    idOfObjOfIS = ((DataSource)obj).getDataSourceIdOfIS();
                } else if (this.t.getClass().isInstance(DataStorage.class)) {
                    resultStatus = ((DataStorage)obj).getStatus();
                    if (resultStatus.compareTo("DOWN") == 0) continue;
                    idOfObj = ((DataStorage)obj).getDataStorageId();
                    idOfObjOfIS = ((DataStorage)obj).getDataStorageIdOfIS();
                } else {
                    System.out.println("ISManager - updateObjsInDB - Error - there is no class with this name");
                }
                if (this.checkIfObjExistsInIS_ById(idOfObjOfIS)) continue;
                ++oldContentInDB;
                try {
                    if (this.t.getClass().isInstance(Agent.class)) {
                        this.dbManager.updateAgentStatus(idOfObj, "DOWN");
                        continue;
                    }
                    if (this.t.getClass().isInstance(DataSource.class)) {
                        this.dbManager.updateSourceStatus(idOfObj, "DOWN");
                        continue;
                    }
                    if (this.t.getClass().isInstance(DataStorage.class)) {
                        this.dbManager.updateStorageStatus(idOfObj, "DOWN");
                        continue;
                    }
                    System.out.println("ISManager - updateObjsInDB - Error - there is no class:" + this.t.getClass().getName());
                }
                catch (Exception e) {
                    System.out.println("ISManager - updateObjsInDB - Exception in updating the status");
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("ISManager.updateObjsInDB (" + typeOfISManager + ") - new UP-Nodes For Storing in DB=" + newContentInDB + " - new DOWN-Nodes For Changing Their Status=" + oldContentInDB);
    }

    public List<String> getObjsFromIS() {
        ArrayList<String> agentsFromIS = new ArrayList<String>();
        if (this.t.getClass().isInstance(Agent.class)) {
            try {
                ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
                GCUBERIQuery RIquery = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
                RIquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", "agent-service")});
                for (GCUBERunningInstance instance : client.execute((ISQuery)RIquery, GCUBEScope.getScope((String)this.scope))) {
                    String tmpAgent = new String();
                    tmpAgent = instance.getServiceName() + "--" + instance.getID() + "--" + instance.getAccessPoint().getEndpoint("gcube/datatransfer/agent/DataTransferAgent").getAddress().getHost() + "--" + instance.getAccessPoint().getEndpoint("gcube/datatransfer/agent/DataTransferAgent").getAddress().getPort() + "--";
                    agentsFromIS.add(tmpAgent);
                }
            }
            catch (RuntimeException e) {
                System.out.println("ISManager.getAgentsFromIS - RuntimeException....");
                e.printStackTrace();
            }
            catch (Exception e) {
                System.out.println("ISManager.getAgentsFromIS - exception....");
                e.printStackTrace();
            }
            return agentsFromIS;
        }
        if (this.t.getClass().isInstance(DataSource.class)) {
            return null;
        }
        if (this.t.getClass().isInstance(DataStorage.class)) {
            return null;
        }
        return null;
    }

    public boolean checkIfObjExistsInIS_ById(String id) {
        if (this.t.getClass().isInstance(Agent.class)) {
            try {
                ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
                GCUBERIQuery RIquery = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
                RIquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", "agent-service")});
                for (GCUBERunningInstance instance : client.execute((ISQuery)RIquery, GCUBEScope.getScope((String)this.scope))) {
                    String instanceId = instance.getID();
                    if (instanceId.compareTo(id) != 0) continue;
                    return true;
                }
            }
            catch (Exception e) {
                System.out.println("ISManager.checkIfObjExistsInIS_ById - exception");
                e.printStackTrace();
            }
            return false;
        }
        if (this.t.getClass().isInstance(DataSource.class)) {
            return false;
        }
        if (this.t.getClass().isInstance(DataStorage.class)) {
            return false;
        }
        return false;
    }

    public String checkIfObjExistsInDB_ById(String id) {
        if (this.t.getClass().isInstance(Agent.class)) {
            try {
                Extent agentExtent = this.dbManager.getPersistenceManager().getExtent(Agent.class, true);
                for (Object obj : agentExtent) {
                    String tmpId = ((Agent)obj).getAgentIdOfIS();
                    if (tmpId.compareTo(id) != 0) continue;
                    return ((Agent)obj).getAgentId();
                }
            }
            catch (Exception e) {
                System.out.println("ISManager.checkIfObjExistsInDB_ById - exception");
                e.printStackTrace();
            }
            return null;
        }
        if (this.t.getClass().isInstance(DataSource.class)) {
            return null;
        }
        if (this.t.getClass().isInstance(DataStorage.class)) {
            return null;
        }
        return null;
    }

    public String setObjToDB(String objIdOfIS, String host, String port) {
        if (this.t.getClass().isInstance(Agent.class)) {
            Agent agentDB = new Agent();
            String agentId = uuidgen.nextUUID();
            agentDB.setAgentId(agentId);
            agentDB.setAgentIdOfIS(objIdOfIS);
            agentDB.setHost(host);
            agentDB.setPort(Integer.valueOf(port).intValue());
            agentDB.setStatus("UP");
            try {
                this.dbManager.storeAgent(agentDB);
            }
            catch (Exception e) {
                System.out.println("ISManager.setObjToDB - Exception in storing the Agent");
                e.printStackTrace();
                return null;
            }
            return agentId;
        }
        if (this.t.getClass().isInstance(DataSource.class)) {
            DataSource sourceDB = new DataSource();
            return null;
        }
        if (this.t.getClass().isInstance(DataStorage.class)) {
            DataStorage storageDB = new DataStorage();
            return null;
        }
        return null;
    }

    public String checkIfObjExistsInIS_ByHostname(String host) {
        if (this.t.getClass().isInstance(Agent.class)) {
            try {
                ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
                GCUBERIQuery RIquery = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
                RIquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", "agent-service")});
                for (GCUBERunningInstance instance : client.execute((ISQuery)RIquery, GCUBEScope.getScope((String)this.scope))) {
                    if (instance.getAccessPoint().getEndpoint("gcube/datatransfer/agent/DataTransferAgent").getAddress().getHost().compareTo(host) != 0) continue;
                    return instance.getID();
                }
            }
            catch (Exception e) {
                System.out.println("ISManager.checkIfObjExistsInIS_ByHostname - exception");
                e.printStackTrace();
            }
            return null;
        }
        if (this.t.getClass().isInstance(DataSource.class)) {
            DataSource sourceDB = new DataSource();
            return null;
        }
        if (this.t.getClass().isInstance(DataStorage.class)) {
            DataStorage storageDB = new DataStorage();
            return null;
        }
        return null;
    }
}

