package org.gcube.datatransfer.scheduler.library;

import java.io.File;
import java.util.List;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.FactoryPortType;

public class BinderLibrary {
	private final AsyncProxyDelegate<FactoryPortType> delegate;



	public BinderLibrary(ProxyDelegate<FactoryPortType> config) {
		this.delegate=new AsyncProxyDelegate<FactoryPortType>(config);
	}


	public EndpointReferenceType bind(String nameOfClient){
		ScopeProvider.instance.set(ScopeProvider.instance.get());

		final String message=nameOfClient;
		Call<FactoryPortType,EndpointReferenceType> call = new Call<FactoryPortType,EndpointReferenceType>() {
			@Override 
			public EndpointReferenceType call(FactoryPortType endpoint) throws Exception {
				return endpoint.create(message);
			}
		};

		EndpointReferenceType result=null;
		try {
			result= delegate.make(call);
		}catch(Exception e) {
			System.out.println("BinderLibrary - Exception when calling endpoint.checkIn(message)");
			e.printStackTrace();
		}

		return result;
	}
}
