package org.gcube.datatransfer.scheduler.impl.porttype;

import org.gcube.common.core.state.GCUBEWSResource;
import org.globus.wsrf.ResourceProperty;

public class Resource extends GCUBEWSResource {

	

	private static final String NAME_RP_NAME = "Name";
	private static final String NAME_RP_VISITS = "Visits";
	private static final String NAME_RP_SCHEDULER_MESSAGE = "SchedulerMessage";
	/** Client visits.*/ 
	int visits;
	/** Client unique name. */
	String name;
	/** StoreInfoSchedulerMessage. */
	String scheduledmessage;


	
     /**{@inheritDoc}*/
    public void initialise(Object... args) throws Exception {
		if (args == null || args.length!=1) throw new IllegalArgumentException();
		this.setName((String) args[0]);
	}

     /** Returns the number of client visits.
     * @return the visits.*/
    public synchronized int getVisits() {return visits;}
    
    /** Returns the client name.
     * @return the name.*/
    public synchronized String getName() {
    	return (String) this.getResourcePropertySet().get(NAME_RP_NAME).get(0);
 
    }
    
    /** Sets the client name.
     * @params the name.*/
    public synchronized void setName(String name) {
    	this.name=name;
    	ResourceProperty property = this.getResourcePropertySet().get(NAME_RP_NAME);
    	property.clear();
    	property.add(name);
    }

    /**Sets the number of client visits.
     * the visits.*/
    protected synchronized void addVisit() {this.visits++;}
    
    public synchronized void setVisit(int num) {
    	ResourceProperty property = this.getResourcePropertySet().get(NAME_RP_VISITS);
    	property.clear();
    	property.add(num);
    }
    
    protected synchronized void setSchedulerMessage(String msg) {
    	ResourceProperty property = this.getResourcePropertySet().get(NAME_RP_SCHEDULER_MESSAGE);
    	property.clear();
    	property.add(msg);

    }
    protected synchronized String getSchedulerMessage() {
    	return (String) this.getResourcePropertySet().get(NAME_RP_SCHEDULER_MESSAGE).get(0);
    }
    
    
    @Override
	protected String[] getPropertyNames() {
		return new String[]{NAME_RP_NAME, NAME_RP_VISITS,NAME_RP_SCHEDULER_MESSAGE };
	}

    
}
