package org.gcube.datatransfer.scheduler.impl.porttype;

import java.util.Calendar;
import java.util.List;
import javax.jdo.Query;

import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.ManuallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TypeOfSchedule;
import org.gcube.datatransfer.scheduler.impl.porttype.TransferHandler;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.FrequencyType;





public class CheckDBForTransfers extends Thread {
	
	DataTransferDBManager dbManager=null;
	Resource resource=null;
	long checkForTransfersIntervalMS=4000;

	
	public CheckDBForTransfers(GCUBEWSResource ws) {
		this.dbManager=ServiceContext.getContext().getDbManager();	
		this.resource=(Resource) ws;
	}
	
	public void run() {
		int runs=0;
		System.out.println("\nCheckForTransfers - "+this.resource.getName()+" -- Thread has started");
		do {
			runs++;
			try {
				Thread.sleep(checkForTransfersIntervalMS);
			} catch (InterruptedException e) {
				System.out.println("CheckForTransfers -- InterruptedException-Unable to sleep - circle of thread="+runs);
				e.printStackTrace();
			}

			  //*** check for transfers ***
			
			//Retrieve all the activated transfers by query			
			Query query=null;
			List<Transfer> list=null;
			query = ServiceContext.getContext().getDbManager().getPersistenceManager().newQuery(Transfer.class);
			try{
			query.setFilter("status == \"STANDBY\" && submitter == \""+this.resource.getName()+"\"");
			}catch(Exception e){
				System.out.println("CheckForTransfers -- Exception in retrieving all the activated transfers by query");
				e.printStackTrace();
			}			
			list = (List<Transfer>) query.execute();
			Calendar calendarTmp;
			
			for(Transfer obj : list){
				
				// ****check for typeOfSchedule ****//
				TypeOfSchedule typeOfSchedule = null;
				String idTypeOfSchedule = null;
				try{
				idTypeOfSchedule=obj.getTypeOfScheduleId();
				typeOfSchedule = this.dbManager.getPersistenceManager().getObjectById(TypeOfSchedule.class,idTypeOfSchedule );
				}catch(Exception e){
					System.out.println("CheckForTransfers -- Exception in retrieving the typeOfSchedule");
					e.printStackTrace();
				}		
				String periodicallyScheduledId = typeOfSchedule.getPeriodicallyScheduledId();
				String idManuallyScheduled = typeOfSchedule.getManuallyScheduledId();			

				// ## if Direct Transfer - no schedule
				if(typeOfSchedule.isDirectedScheduled()==true){
					System.out.println("\nCheckForTransfers - "+obj.getSubmitter()+" -- A transfer (Direct Transfer) is happening today  - transferId:"+((Transfer)obj).getTransferId()+" -- submitter:"+((Transfer)obj).getSubmitter()+" -- status="+((Transfer)obj).getStatus());
					
					try {	
					this.dbManager.updateTransferStatus(obj.getTransferId(), "ONGOING");
					}catch (Exception e) {
					System.out.println("\nCheckForTransfers -- Exception in updating the transfer status - "+((Transfer)obj).getSubmitter() +" - id="+((Transfer)obj).getTransferId());
					e.printStackTrace();
					}
					 
					// **** Transfer Handler ****
					TransferHandler transferHandler = new TransferHandler(obj.getTransferId(),this.resource,false);
					transferHandler.start();
					
					
				}// ## if Manual Transfer - a specific instance
				else if (idManuallyScheduled!=null){
					ManuallyScheduled manuallyScheduled  = this.dbManager.getPersistenceManager().getObjectById(ManuallyScheduled.class, idManuallyScheduled);
					
					calendarTmp = manuallyScheduled.getCalendar();

			 		if( (calendarTmp.get(Calendar.YEAR) == Calendar.getInstance().get(Calendar.YEAR))
					  &&(calendarTmp.get(Calendar.MONTH) == Calendar.getInstance().get(Calendar.MONTH))
					  &&(calendarTmp.get(Calendar.DAY_OF_MONTH) == Calendar.getInstance().get(Calendar.DAY_OF_MONTH))
				//	  &&(calendarTmp.get(Calendar.HOUR) == Calendar.getInstance().get(Calendar.HOUR))
				//	  &&(calendarTmp.get(Calendar.MINUTE) == Calendar.getInstance().get(Calendar.MINUTE))
					  ){
						System.out.println("\nCheckForTransfers - "+obj.getSubmitter()+" -- A transfer (Manually Scheduled) is happening today  - transferId:"+((Transfer)obj).getTransferId()+" -- submitter:"+((Transfer)obj).getSubmitter()+" -- status="+((Transfer)obj).getStatus());
						
							try {	
							this.dbManager.updateTransferStatus(obj.getTransferId(), "ONGOING");
							}catch (Exception e) {
							System.out.println("\nCheckForTransfers -- Exception in updating the transfer status - "+((Transfer)obj).getSubmitter() +" - id="+((Transfer)obj).getTransferId());
							e.printStackTrace();
							}
						 
						// **** Transfer Handler ****
						TransferHandler transferHandler = new TransferHandler(obj.getTransferId(),this.resource,false);
						transferHandler.start();
					}

				}// ## if Periodically Transfer - every minute/hour/day/.. etc
				else if(periodicallyScheduledId!=null){
					PeriodicallyScheduled periodicallyScheduled= this.dbManager.getPersistenceManager().getObjectById(PeriodicallyScheduled.class,periodicallyScheduledId );		
										
					Calendar startInstance=periodicallyScheduled.getStartInstance();
					
					if( (startInstance.get(Calendar.YEAR) == Calendar.getInstance().get(Calendar.YEAR))
							  &&(startInstance.get(Calendar.MONTH) == Calendar.getInstance().get(Calendar.MONTH))
							  &&(startInstance.get(Calendar.DAY_OF_MONTH) == Calendar.getInstance().get(Calendar.DAY_OF_MONTH))
							  &&(startInstance.get(Calendar.HOUR) == Calendar.getInstance().get(Calendar.HOUR))
							  &&(startInstance.get(Calendar.MINUTE) == Calendar.getInstance().get(Calendar.MINUTE))
					){
						System.out.println("\nCheckForTransfers - "+obj.getSubmitter()+" -- A transfer (Periodically Scheduled) is happening today  - transferId:"+((Transfer)obj).getTransferId()+" -- submitter:"+((Transfer)obj).getSubmitter()+" -- status="+((Transfer)obj).getStatus());
							
						try {	
						this.dbManager.updateTransferStatus(obj.getTransferId(), "ONGOING");
						}catch (Exception e) {
						System.out.println("\nCheckForTransfers -- Exception in updating the transfer status - "+((Transfer)obj).getSubmitter() +" - id="+((Transfer)obj).getTransferId());
						e.printStackTrace();
						}
								 
						// **** Transfer Handler ****
						TransferHandler transferHandler = new TransferHandler(obj.getTransferId(),this.resource,true);
						transferHandler.start();

					}
				}

			}	
			
		} while (! Thread.interrupted());

		
		}
	}



