package org.gcube.datatransfer.scheduler.impl.porttype;

import static org.gcube.datatransfer.agent.library.proxies.Proxies.transferAgent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.jdo.Extent;
import javax.jdo.Query;

import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.types.VOID;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datatransfer.agent.library.AgentLibrary;
import org.gcube.datatransfer.agent.library.outcome.FileTransferOutcome;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.DataSource;
import org.gcube.datatransfer.scheduler.db.model.DataStorage;
import org.gcube.datatransfer.scheduler.db.model.ManuallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TransferObject;
import org.gcube.datatransfer.scheduler.db.model.TypeOfSchedule;
import org.gcube.datatransfer.scheduler.is.ISManager;
import org.gcube.datatransfer.scheduler.library.InfoCancelSchedulerMessage;
import org.gcube.datatransfer.scheduler.library.InfoSchedulerMessage;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.CancelTransferMessage;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.StorageType;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.TransferType;
import org.globus.wsrf.ResourceException;

import com.thoughtworks.xstream.XStream;


public class Stateful extends GCUBEPortType {
	/** The UUIDGen */
	private static final UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();

	public DataTransferDBManager dbManager;
	public ISManager isManager;
	
    @Override
	protected ServiceContext getServiceContext() {return ServiceContext.getContext();}
  
    /*
     * visit
     * input: Nothing
     * return: String with info about the specific resource and the service
     */
	public String visit(VOID void_type) throws GCUBEFault {

		ServiceContext sctx = ServiceContext.getContext();
		Resource resource = null;
		try {
			resource = this.getResource();
		} catch (ResourceException e1) {
		    System.out.println("Stateful - visit - Exception in retrieving the resource");
			e1.printStackTrace();
			return null;
		}
		
		try {
	    StringBuilder output = new StringBuilder();
		GHNContext nctx = GHNContext.getContext();
		GCUBEStatefulPortTypeContext pctx = StatefulContext.getContext();
	    
		
	    resource.addVisit();	    
	    output.append("Stateful - Hello " + resource.getName()).append("\nyou have invoked porttype ").
	    	append(pctx.getName() + " \nof service " + sctx.getName()+", which you found at:\n").
	    	append(pctx.getEPR() + "in the gCube infrastructure " + nctx.getGHN().getInfrastructure()). 
	    	append( " and you are in the Scope " + sctx.getScope()).
		append(" \nThis is your invocation N." + resource.getVisits() + "\n");
	    resource.store();
		return output.toString();	    
		}catch (GCUBEException e) {throw e.toFault();
		}catch (Exception e) {throw sctx.getDefaultException(e).toFault();
		}
    }

	/*
	 * storeInfoScheduler
	 * input: String InfoSchedulerMessage (StartTransferMessage & TypeOfScheduler)
	 * return: String with the transfer id
	 */
	public String storeInfoScheduler(String msg) throws GCUBEFault {

		ServiceContext sctx = ServiceContext.getContext();
		this.dbManager=ServiceContext.getContext().getDbManager();
		this.isManager=new ISManager(this.dbManager);
		
		try {
		//1. **** Storing the InfoSchedulerMessage as it is in the Resource ..****
	    Resource resource = this.getResource();
	    resource.setSchedulerMessage(msg);   	  
	    resource.store();
		}catch (Exception e) {
	    throw sctx.getDefaultException(e).toFault();
		}
	
	    //2. **** Storing in the DB .. ****
	    InfoSchedulerMessage infoObj= new InfoSchedulerMessage();
		String transferId = uuidgen.nextUUID();
		//Create the transfer in DB
		Transfer t = new Transfer();
		t.setTransferId(transferId);
		Set<TransferObject> transferObjects=new HashSet<TransferObject>();
		
		String tmpMsg=msg;
		tmpMsg.replaceAll("&lt;", "<");
		tmpMsg=tmpMsg.replaceAll("&gt;", ">");
		
	    XStream xstream = new XStream();
	    infoObj=(InfoSchedulerMessage)xstream.fromXML(tmpMsg);

		try {
			//set submitter
			t.setSubmitter(this.getResource().getName());
		} catch (ResourceException e1) {
			System.out.println("Stateful Service(storeInfoScheduler) - Exception in setting the submitter in Transfer:\n");
			e1.printStackTrace();
		}
		//set status
		t.setStatus("STANDBY");
		
		

		TypeOfSchedule typeOfSchedule = new TypeOfSchedule();		
		typeOfSchedule.setTypeOfScheduleId(transferId.concat("-typeOfSchedule"));
		
		// ## if Direct Transfer
		if(infoObj.getTypeOfSchedule().isDirectedScheduled()==true){
			typeOfSchedule.setDirectedScheduled(true);
		
		}// ## if Manual Transfer - a specific instance
		else if(infoObj.getTypeOfSchedule().getManuallyScheduled()!=null){
			ManuallyScheduled manuallyScheduled= new ManuallyScheduled();
			manuallyScheduled.setManuallyScheduledId(transferId.concat("-manuallyScheduled"));
			manuallyScheduled.setCalendar(infoObj.getTypeOfSchedule().getManuallyScheduled().getCalendar());
			try	{ 
				typeOfSchedule.setManuallyScheduledId(manuallyScheduled.getManuallyScheduledId());
				ServiceContext.getContext().getDbManager().storeManuallyScheduled(manuallyScheduled);
			}
			catch(Exception e){
			System.out.println("Stateful Service(storeInfoScheduler) - Exception in storing the ManuallyScheduled:\n");
				e.printStackTrace();
			}			
						
		}// ## if Periodically Transfer - every minute/hour/day/.. etc
		else if(infoObj.getTypeOfSchedule().getPeriodicallyScheduled()!=null){
			PeriodicallyScheduled periodicallyScheduled = new PeriodicallyScheduled();
			periodicallyScheduled.setPeriodicallyScheduledId(transferId.concat("-periodicallyScheduled"));
			periodicallyScheduled.setFrequency(infoObj.getTypeOfSchedule().getPeriodicallyScheduled().getFrequency());
			periodicallyScheduled.setStartInstance(infoObj.getTypeOfSchedule().getPeriodicallyScheduled().getStartInstance());

			try	{ 
				typeOfSchedule.setPeriodicallyScheduledId(periodicallyScheduled.getPeriodicallyScheduledId());
				ServiceContext.getContext().getDbManager().storePeriodicallyScheduled(periodicallyScheduled);
			}
			catch(Exception e){
			System.out.println("Stateful Service(storeInfoScheduler) - Exception in storing the PeriodicallyScheduled:\n");
				e.printStackTrace();
			}	
		}

		try	{
			//set typeOfSchedule
			t.setTypeOfScheduleId(typeOfSchedule.getTypeOfScheduleId());
			ServiceContext.getContext().getDbManager().storeTypeOfSchedule(typeOfSchedule);
		}
		catch(Exception e){
		System.out.println("Stateful Service(storeInfoScheduler) - Exception in storing the TypeOfSchedule:\n");
				e.printStackTrace();
		}
		
		DataSource datasource=new DataSource();
		datasource.setDataSourceId(transferId.concat("-datasource"));
		
		TransferType transferType = infoObj.getStartTransferMessage().getSource().getType();
		datasource.setType(transferType.getValue());
		
		try	{ // *** store the DataSource in DB ***
			//set dataSource
			t.setSourceId(datasource.getDataSourceId());
			ServiceContext.getContext().getDbManager().storeSource(datasource);
		}
		catch(Exception e){
		System.out.println("Stateful Service(storeSource) - Exception in storing the DataSource:\n");
				e.printStackTrace();
		}

		//normally it will check for the agent in IS.. not manually
		Agent agent=new Agent();
		agent.setAgentId(transferId.concat("-agent"));
		agent.setHost("pcitgt1012.cern.ch");
		agent.setPort(8080);
		try	{ // *** store the agent in DB ***
		ServiceContext.getContext().getDbManager().storeAgent(agent);
		}
		catch(Exception e){
			System.out.println("Stateful Service(storeInfoScheduler) " +
				"- Exception in storing the Agent:\n");
			e.printStackTrace();
		}
		/*
		//check for the agent in IS
		String checkResult=null;
		checkResult=this.isManager.checkIfAgentExistsInIS_ByHostname("pcitgt1012.cern.ch");
		while(checkResult==null){
		System.out.println("Stateful Service(storeInfoScheduler) " +
			"- Error!! - there is no agent with hostname= 'pcitgt1012.cern.ch'\n");
		//sleeping ..........
		try {			
			Thread.sleep(4000);
		} catch (InterruptedException e) {
			System.out.println("Stateful Service ..- InterruptedException-Unable to sleep");
			e.printStackTrace();
		}
		}
		 */
		
		//set agent
		t.setAgentId(transferId.concat("-agent"));
		
		
		// **** If LocalFileBasedTransfer **** 
		if(transferType==TransferType.LocalFileBasedTransfer){
			String[] inputURIs = infoObj.getStartTransferMessage().getSource().getInputURIs();
			String destinationFolder = infoObj.getStartTransferMessage().getDest().getOutUri().getOutUris()[0].toString();	
			boolean overwrite = infoObj.getStartTransferMessage().getDest().getOutUri().isOverwrite();
		
			// for every inputUrl we create a transferObject which represents a file
			// we collect all of them in a set of objects and after storing the transfer
			//we also store the transferObjectSet ... 
			TransferObject obj=null;
			for(String inputUrl : inputURIs){
				obj=new TransferObject();
				obj.setURI(inputUrl);
				obj.setTransferid(transferId);
				transferObjects.add(obj);
			}
			
			DataStorage datastorage=new DataStorage();
			datastorage.setDataStorageId(transferId.concat("-datastorage"));
			datastorage.setOutputUrl(destinationFolder);
			datastorage.setOverwrite(overwrite);
			try	{ // *** store the DataStorage in DB ***
				t.setStorageId(datastorage.getDataStorageId());
				ServiceContext.getContext().getDbManager().storeStorage(datastorage);
				}
			catch(Exception e){
				System.out.println("Stateful Service(storeStorage) " +
						"- Exception in storing the DataStorage:\n");
				e.printStackTrace();
			}
			
		}// **** If FileBasedTransfer **** 
		else if (transferType==TransferType.FileBasedTransfer){
			//two types here... 
			//first urls[] to the agent
			//and second urls[] to the DataStorage 
			
			String[] inputURIs = infoObj.getStartTransferMessage().getSource().getInputURIs();
			StorageType storageType= infoObj.getStartTransferMessage().getDest().getOutUri().getStorageType();
			String destinationFolder = infoObj.getStartTransferMessage().getDest().getOutUri().getOutUris()[0].toString();	
			boolean overwrite = infoObj.getStartTransferMessage().getDest().getOutUri().isOverwrite();
			
			// for every inputUrl we create a transferObject which represents a file
			// we collect all of them in a set of objects and after storing the transfer
			//we also store the transferObjectSet ... 
			TransferObject obj=null;
			for(String inputUrl : inputURIs){
				obj=new TransferObject();
				obj.setURI(inputUrl);
				obj.setTransferid(transferId);
				transferObjects.add(obj);
			}
			
			// storageType = LocalGHN  ---  urls[] to local node (agent)
			if(storageType.getValue()==StorageType.LocalGHN.getValue()){
				DataStorage datastorage=new DataStorage();
				datastorage.setDataStorageId(transferId.concat("-datastorage"));
				datastorage.setOutputUrl(destinationFolder);
				datastorage.setOverwrite(overwrite);
				datastorage.setType(StorageType.LocalGHN.getValue());
				
				try	{ // *** store the DataStorage in DB ***
					//set dataStorage
					t.setStorageId(datastorage.getDataStorageId());
					ServiceContext.getContext().getDbManager().storeStorage(datastorage);
					}
				catch(Exception e){
					System.out.println("Stateful Service(storeStorage) " +
							"- Exception in storing the DataStorage:\n");
					e.printStackTrace();
				}
				
			}// storageType = StorageManager  ---  urls[] to the DataStorage (remote node)
			else if(storageType.getValue()==StorageType.StorageManager.getValue()){

				DataStorage datastorage=new DataStorage();
				datastorage.setDataStorageId(transferId.concat("-datastorage"));
				datastorage.setOutputUrl(destinationFolder);
				datastorage.setOverwrite(overwrite);
				datastorage.setType(StorageType.StorageManager.getValue());	
				
				 //normally it will check for the dataStorage in IS.. not manually
				//supposed that the datastorage is the node that the agent service's running
				//datastorage.setHost("pcitgt1012.cern.ch");
				//datastorage.setPort(8080);

				try	{ // *** store the DataStorage in DB ***
					//set dataStorage
					t.setStorageId(datastorage.getDataStorageId());
					ServiceContext.getContext().getDbManager().storeStorage(datastorage);
					}
				catch(Exception e){
					System.out.println("Stateful Service(storeStorage) " +
							"- Exception in storing the DataStorage:\n");
					e.printStackTrace();
				}				
			}		

		}// **** If TreeBasedTransfer **** 
		else if (transferType==TransferType.TreeBasedTransfer){
			//##### Empty for now #####
		}		


		try	{ // *** store the transfer in DB ***
		ServiceContext.getContext().getDbManager().storeTransfer(t);
		}
		catch(Exception e){
		System.out.println("Stateful Service(storeInfoScheduler) " +
				"- Exception in storing the Transfer:\n");
		e.printStackTrace();
		}
		
	    try	{// *** store the transfer objects in DB ***
		ServiceContext.getContext().getDbManager().storeTransferObject(transferObjects);
		}
		catch(Exception e){
			System.out.println("Stateful Service(storeInfoScheduler) " +
				"- Exception in storing the Set of Transfer Objects:\n");
			e.printStackTrace();
		}
		//------------------------------------------------------------------------
	   	
		try{//Printing - Retrieve all the transfers by method
		Extent<?> transferExtent = ServiceContext.getContext().getDbManager().getPersistenceManager().getExtent(Transfer.class, true);
		Iterator<?> iter = transferExtent.iterator();
		System.out.println("\nStateful Service(storeInfoScheduler) - Retrieve all the Transfers by method:\n");

		while (iter.hasNext()){
		Object obj=iter.next();
		System.out.println("TransferId="+((Transfer)obj).getTransferId()+" -- Status="+((Transfer)obj).getStatus()+" -- Submitter="+((Transfer)obj).getSubmitter());
		}
		}catch(Exception e){
		e.printStackTrace();
		}
		System.out.println("");
		
		try{//Printing - Retrieve all the transfer objects by method
		Extent<?> transferobjExtent = ServiceContext.getContext().getDbManager().getPersistenceManager().getExtent(TransferObject.class, true);
		Iterator<?> iter = transferobjExtent.iterator();
		System.out.println("\nStateful Service(storeInfoScheduler) - Retrieve all the TransferObjects (files) by method:\n");

		while (iter.hasNext()){
		Object obj=iter.next();
		System.out.println("TransferObjId="+((TransferObject)obj).getObjectId()+" -- transferid="+((TransferObject)obj).getTransferid());
		}
		}catch(Exception e){
		e.printStackTrace();
		}
		
		System.out.println("");
		//we return the transferId of the Transfer in SchedulerDB
		return transferId;
	}

	/*
	 * cancelScheduledTransfer
	 * input: String CancelTransferMessage (transferId (the one in the schedulerDB) & isForceCancel)
	 * return: String with result of cancellation ("DONE" if everything's ok)
	 * if exception or error occurred, the returned string starts with "Error: "
	 */
	public String cancelScheduledTransfer(String msg) throws GCUBEFault {

		this.dbManager=ServiceContext.getContext().getDbManager();
		this.isManager=new ISManager(this.dbManager);
		String error = new String("Error: ");

		String tmpMsg=msg;
		tmpMsg.replaceAll("&lt;", "<");
		tmpMsg=tmpMsg.replaceAll("&gt;", ">");
		
	    XStream xstream = new XStream();
	    InfoCancelSchedulerMessage cancelObj= new InfoCancelSchedulerMessage();
	    cancelObj=(InfoCancelSchedulerMessage)xstream.fromXML(tmpMsg);
	    
	    String transferId = cancelObj.getCancelTransferMessage().getTransferID();
	    Boolean isForceCancel = cancelObj.getCancelTransferMessage().isForceStop();
      
	    Transfer transfer = this.dbManager.getPersistenceManager().getObjectById(Transfer.class,transferId);
	    String typeOfScheduleId = transfer.getTypeOfScheduleId();
	    TypeOfSchedule typeOfSchedule = this.dbManager.getPersistenceManager().getObjectById(TypeOfSchedule.class, typeOfScheduleId);
    	
	    //retrieving the agentId
    	String agentId = transfer.getAgentId();
    	if(agentId==null){
    		System.out.println("Stateful Service(cancelScheduledTransfer) - Error - agentId=null");
 			error=error.concat("AgentId=null");
			return error;
    	}
    	String hostAgent=this.dbManager.getPersistenceManager().getObjectById(Agent.class,agentId).getHost();
    	int portAgent = this.dbManager.getPersistenceManager().getObjectById(Agent.class,agentId).getPort();
    	
    	try{
    		AgentLibrary agentLibrary = null;
    		ScopeProvider.instance.set("/gcube/devsec"); 
    		agentLibrary =  transferAgent().at(hostAgent, portAgent).build();
    		
    		//check for the status before we make the cancel
    	    String status = this.dbManager.getPersistenceManager().getObjectById(Transfer.class,transferId).getStatus();
    	    System.out.println("Stateful Service(cancelScheduledTransfer) - status before Calling the cancelTransfer in Agent!! = "+status);
    	    if(status=="COMPLETED" || status=="FAILED"){
    	    	//if it's a periodically schedule we have to change its status to "CANCELED" 
    	    	if(typeOfSchedule.getPeriodicallyScheduledId()!=null){
        		    try {
        				this.dbManager.updateTransferStatus(transferId, "CANCELED");
        			} catch (Exception e) {
        			   	System.out.println("\nStateful Service(cancelScheduledTransfer) - " +
        				"Exception in updating the status to Canceled\n");
        		 		error=error.concat(e.getMessage());
        		 		e.printStackTrace();
        		 		return error;	 			
        			}
        		    return "DONE";
    	    	}//in other case there is no point to change it because this transfer is already done... 
    	    	else return error.concat("Transfer already done");
    	    }
    	    else if (status=="CANCELED"){
    	    	return "DONE";
    	    }
    	    else if(status=="STANDBY"){
    		    //we change the status of transfer to CANCELED
    		    try {
    				this.dbManager.updateTransferStatus(transferId, "CANCELED");
    			} catch (Exception e) {
    			   	System.out.println("\nStateful Service(cancelScheduledTransfer) - " +
    				"Exception in updating the status to Canceled\n");
    		 		error=error.concat(e.getMessage());
    		 		e.printStackTrace();
    		 		return error;	 			
    			}
    		    return "DONE";
    	    }
    	    //else status "ONGOING"
    	    
        	//retrieving the transferId that the Agent has as identifier of this specific transfer
    	    String transferIdOfAgent = this.dbManager.getPersistenceManager().getObjectById(Transfer.class,transferId).getTransferIdOfAgent();
        	if(transferIdOfAgent==null){
        		System.out.println("Stateful Service(cancelScheduledTransfer) - Error - transferIdOfAgent=null");
     			error=error.concat("TransferIdOfAgent=null");
    			return error;
        	}

    		agentLibrary.cancelTransfer(transferIdOfAgent, isForceCancel);
 		}
 		catch (Exception e) {
 			error=error.concat(e.getMessage());
		   	System.out.println("\nStateful Service(cancelScheduledTransfer) - " +
			"Exception in calling the cancelTransfer\n");
 			e.printStackTrace();
	 		return error;
	 	}

	    //we change the status of transfer to CANCELED
	    try {
			this.dbManager.updateTransferStatus(transferId, "CANCELED");
		} catch (Exception e) {
		   	System.out.println("\nStateful Service(cancelScheduledTransfer) - " +
			"Exception in updating the status to Canceled\n");
	 		error=error.concat(e.getMessage());
	 		e.printStackTrace();
	 		return error;	 			
		}
	   	System.out.println("\nStateful Service(cancelScheduledTransfer) - status="+this.dbManager.getPersistenceManager().getObjectById(Transfer.class,transferId).getStatus());

	    return "DONE";
	    
}
	
	/*
	 * monitorScheduledTransfer
	 * input: String with the transferId (the one in the schedulerDB)
	 * return: String with result of monitoring (status in SchedulerDB)
	 */
	public String monitorScheduledTransfer(String msg) throws GCUBEFault {

		this.dbManager=ServiceContext.getContext().getDbManager();
		this.isManager=new ISManager(this.dbManager);
	    
	    String transferId = msg;
	    String status = this.dbManager.getPersistenceManager().getObjectById(Transfer.class,transferId).getStatus();
	    return status;
	}
	
	
	/*
	 * getScheduledTransferOutcomes
	 * input: String with the transferId (the one in the schedulerDB)
	 * return: String with result of outcomes
	 * if exception or error occurred, the returned string starts with "Error:"
	 */
	public String getScheduledTransferOutcomes(String msg) throws GCUBEFault {

		this.dbManager=ServiceContext.getContext().getDbManager();
		this.isManager=new ISManager(this.dbManager);
		String error=new String("Error:");
	    StringBuilder outcomesResult = new StringBuilder();

		String transferId = msg;
	    
    	//retrieving the transferId that the Agent has as identifier of this specific transfer
	    String transferIdOfAgent = this.dbManager.getPersistenceManager().getObjectById(Transfer.class,transferId).getTransferIdOfAgent();
    	if(transferIdOfAgent==null){
 			return "The Transfer has not started yet or It is a sync op.";
    	}
    	
    	//retrieving the agentId
    	String agentId = this.dbManager.getPersistenceManager().getObjectById(Transfer.class,transferId).getAgentId();
    	if(agentId==null){
    		System.out.println("Stateful Service(monitorScheduledTransfer) - Error - agentId=null");
 			error=error.concat("Stateful Service(monitorScheduledTransfer) - agentId=null");
 			return error;
    	}
    	String hostAgent=this.dbManager.getPersistenceManager().getObjectById(Agent.class,agentId).getHost();
    	int portAgent = this.dbManager.getPersistenceManager().getObjectById(Agent.class,agentId).getPort();
    	
    	AgentLibrary agentLibrary = null;	
    	try{
    		ScopeProvider.instance.set("/gcube/devsec"); 
    		agentLibrary =  transferAgent().at(hostAgent, portAgent).build();
    	}
 		catch (Exception e) {
    		System.out.println("Stateful Service(monitorScheduledTransfer) - Exception when building agentLibrary");
 			error=error.concat(e.getMessage());
	    	e.printStackTrace();
	    	return error;
 		}
    	
    	//to do - we can get the ids of objects in scheduler that failed or succeeded. 
    	//String[] objectTrasferredIDs = this.dbManager.getPersistenceManager().getObjectById(Transfer.class, transferId).getObjectTrasferredIDs();
    	//String[] objectFailedIDs= this.dbManager.getPersistenceManager().getObjectById(Transfer.class, transferId).getObjectFailedIDs();

    	
 		try{
 			//*** getTransferOutcomes *** //
			
			ArrayList<FileTransferOutcome> outcomes = agentLibrary.getTransferOutcomes(transferIdOfAgent, FileTransferOutcome.class);			
			int numOfObj=0;
			for (FileTransferOutcome outcome : outcomes){
				outcomesResult.append("Outcome-"+numOfObj+"\n");
				outcomesResult.append("Exception: "+outcome.getException()+"\n");
				outcomesResult.append("FileName: "+ outcome.getFilename()+"\n");
				outcomesResult.append("Success?: "+ outcome.isSuccess()+"\n");
				outcomesResult.append("Failure?: "+ outcome.isFailure()+"\n");
				numOfObj++;
			}
 		}
 		catch (Exception e) {
    		System.out.println("Stateful Service(monitorScheduledTransfer) - Exception when calling the getTransferOutcomes and read the outcomes");
 			error=error.concat(e.getMessage());
	    	e.printStackTrace();
	    	return error;
 		}

	    return outcomesResult.toString();
    }
	
	/*KLHDGJKD*/
    /**
     * 
     * @return the stateful resource
     * @throws ResourceException if no resource was found in the current context
     */
    private Resource getResource() throws ResourceException {
		return (Resource) StatefulContext.getContext().getWSHome().find();
    }
    
    
    
}
