package org.gcube.datatransfer.scheduler.impl.porttype;

import static org.gcube.datatransfer.scheduler.impl.porttype.Utils.*;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
//import org.gcube.datatransfer.scheduler.impl.db.DataTransferDBManager;
//import org.gcube.datatransfer.scheduler.impl.utils.Constants;



public class ServiceContext extends GCUBEServiceContext {

	/** Single context instance, created eagerly */
	private static ServiceContext cache = new ServiceContext();
	
	private DataTransferDBManager dbManager = null;
	@Override 
	protected void onInitialisation() throws Exception {

		this.dbManager = new DataTransferDBManager();
		// **** CheckIS Thread ****
		//CheckIS checkIS = new CheckIS();
		//checkIS.start();
	}
	
	/** Returns cached instance */
	public static ServiceContext getContext() {return cache;}
	
	/** Prevents accidental creation of more instances */
	private ServiceContext(){};
		
	/** {@inheritDoc} */
	protected String getJNDIName() {return NAME;}
	
	public DataTransferDBManager getDbManager() {
		return dbManager;
	}

	public void setDbManager(DataTransferDBManager dbManager) {
		this.dbManager = dbManager;
	}
	
	
}
