/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.newhandler;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jdo.Extent;
import javax.jdo.Query;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datatransfer.common.agent.Types;
import org.gcube.datatransfer.common.messaging.MSGClient;
import org.gcube.datatransfer.common.messaging.messages.TransferRequestMessage;
import org.gcube.datatransfer.common.options.TransferOptions;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.DataStorage;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TransferObject;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.impl.newhandler.SchedulerUtils;
import org.gcube.datatransfer.scheduler.impl.state.SchedulerResource;
import org.gcube.datatransfer.scheduler.is.ISManager;

public class ProduceTransfer
extends Thread {
    private Transfer transfer;
    private String submitter;
    private String transferId;
    private DataTransferDBManager dbManager;
    private SchedulerResource resource;
    private String transferType;
    private List<String> errorsInTransfer = new ArrayList<String>();
    private Agent agent;
    private String hostAgent;
    private int portAgent;
    private GCUBELog logger = new GCUBELog((Object)this);
    private MSGClient msgClient;
    private ServiceContext context;
    private GCUBEScope scope;
    private ISManager isManagerForAgents;

    public ProduceTransfer(String transferId, GCUBEWSResource ws, boolean isPeriodically) {
        this.dbManager = ServiceContext.getContext().getDbManager();
        this.transferId = transferId;
        this.resource = (SchedulerResource)ws;
        this.transfer = (Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId);
        this.agent = null;
        this.submitter = this.transfer.getSubmitter();
        this.transferType = this.transfer.getTransferType();
        this.msgClient = ServiceContext.getContext().getMsgClient();
        this.context = ServiceContext.getContext();
        this.scope = GCUBEScope.getScope((String)this.transfer.getScope());
        this.isManagerForAgents = ServiceContext.getContext().getIsManagerForAgents();
    }

    @Override
    public void run() {
        ScopeProvider.instance.set(this.scope.toString());
        this.logger.debug((Object)("\nTransferHandler(Version With Messaging) - " + this.resource.getName() + " -- Thread has started"));
        String agentId = this.transfer.getAgentId();
        if (agentId == null) {
            this.logger.error((Object)"TransferHandler - Error - agentId=null");
            this.errorsInTransfer.add("TransferHandler - Error - agentId=null");
            SchedulerUtils.updateStatusAndErrors(this.transferId, this.agent, "FAILED", this.errorsInTransfer);
            return;
        }
        Extent resultExtent = this.dbManager.getPersistenceManager().getExtent(Agent.class, true);
        Iterator iter = resultExtent.iterator();
        boolean flagExists = false;
        while (iter.hasNext()) {
            Agent obj = (Agent)iter.next();
            if (obj.getAgentId().compareTo(agentId) != 0) continue;
            this.agent = obj;
            this.hostAgent = obj.getHost();
            this.portAgent = obj.getPort();
            flagExists = true;
            break;
        }
        if (!flagExists) {
            String checkResultFromDB = null;
            String hostnameOfAgent = this.transfer.getAgentHostname();
            checkResultFromDB = this.isManagerForAgents.checkIfObjExistsInDB_ByHostname(hostnameOfAgent);
            if (checkResultFromDB != null) {
                try {
                    this.dbManager.updateAgentInTransfer(this.transferId, checkResultFromDB);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.agent = null;
                Extent resultExtent2 = this.dbManager.getPersistenceManager().getExtent(Agent.class, true);
                Iterator iter2 = resultExtent2.iterator();
                flagExists = false;
                while (iter2.hasNext()) {
                    Agent obj = (Agent)iter2.next();
                    if (obj.getAgentId().compareTo(agentId) != 0) continue;
                    this.agent = obj;
                    this.hostAgent = obj.getHost();
                    this.portAgent = obj.getPort();
                    flagExists = true;
                    break;
                }
                if (!flagExists) {
                    String errorMsg = "TransferHandler -  Error - agent with hostname=" + hostnameOfAgent + " does not exist in DB anymore";
                    this.logger.error((Object)errorMsg);
                    this.errorsInTransfer.add(errorMsg);
                    SchedulerUtils.updateStatusAndErrors(this.transferId, this.agent, "FAILED", this.errorsInTransfer);
                    return;
                }
            } else {
                String errorMsg = "TransferHandler -  Error - agent with hostname=" + hostnameOfAgent + " does not exist in DB anymore";
                this.logger.error((Object)errorMsg);
                this.errorsInTransfer.add(errorMsg);
                SchedulerUtils.updateStatusAndErrors(this.transferId, this.agent, "FAILED", this.errorsInTransfer);
                return;
            }
        }
        if (this.hostAgent == null) {
            this.logger.error((Object)"TransferHandler - Error - hostAgent=null");
            this.errorsInTransfer.add("TransferHandler - Error - hostAgent=null");
            SchedulerUtils.updateStatusAndErrors(this.transferId, this.agent, "FAILED", this.errorsInTransfer);
            return;
        }
        SchedulerUtils.updateAgentStatistics("ONGOING", this.agent);
        if (this.transferType.compareTo("LocalFileBasedTransfer") == 0) {
            this.logger.error((Object)"TransferHandler - Error - LocalFileBasedTransfer is not used anymore");
            this.errorsInTransfer.add("TransferHandler - LocalFileBasedTransfer is not used anymore");
            SchedulerUtils.updateStatusAndErrors(this.transferId, this.agent, "FAILED", this.errorsInTransfer);
            return;
        }
        if (this.transferType.compareTo("FileBasedTransfer") == 0) {
            this.fileBasedProcess();
        } else if (this.transferType.compareTo("TreeBasedTransfer") == 0) {
            this.treeBasedProcess();
        }
    }

    public void fileBasedProcess() {
        String address;
        Object transferIdOfAgent = null;
        ArrayList<TransferObject> objectsToBeTransferred = new ArrayList<TransferObject>();
        Query query = null;
        List list = null;
        this.transfer = (Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId);
        boolean flagReadyObjs = this.transfer.isReadyObjects();
        int numSleeps = 0;
        while (!flagReadyObjs) {
            this.logger.debug((Object)("TransferHandler -- DB has not finished storing the objs.. sec=" + numSleeps * 6));
            this.sleepSixSec();
            this.transfer = (Transfer)this.dbManager.getPersistenceManager().getObjectById(Transfer.class, (Object)this.transferId);
            flagReadyObjs = this.transfer.isReadyObjects();
            if (++numSleeps <= 20) continue;
            this.logger.debug((Object)"TransferHandler -- DB did not store the objs in 120s .. transfer aborted-failed..");
            SchedulerUtils.updateStatusAndErrors(this.transferId, this.agent, "FAILED", null);
            return;
        }
        query = ServiceContext.getContext().getDbManager().getPersistenceManager().newQuery(TransferObject.class);
        list = (List)query.execute();
        this.logger.debug((Object)("TransferHandler -- listOfObjects=" + list.size() + " -- transferId=" + this.transferId));
        for (TransferObject obj : list) {
            String transferIdOfSpecific = obj.getTransferid();
            if (transferIdOfSpecific == null || transferIdOfSpecific.compareTo(this.transferId) != 0) continue;
            objectsToBeTransferred.add(obj);
        }
        this.logger.debug((Object)("TransferHandler -- listOfObjectsToBeTransferrwes=" + objectsToBeTransferred.size()));
        ArrayList<URI> inputUris = new ArrayList<URI>();
        for (TransferObject obj : objectsToBeTransferred) {
            try {
                inputUris.add(new URI(obj.getSrcURI()));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        Types.storageType typeOfStorage = null;
        Types.StorageManagerDetails storageManagerDetails = new Types.StorageManagerDetails();
        this.logger.debug((Object)("TransferHandler -- scooooooooope=" + this.scope));
        EndpointReferenceType endpoint = ServiceContext.getContext().getInstance().getAccessPoint().getEndpoint("gcube/datatransfer/scheduler/Scheduler");
        String sourceEndpoint = address = endpoint.getAddress().toString();
        String[] parts = address.split("/");
        if (parts.length >= 3) {
            sourceEndpoint = parts[0] + "//" + parts[2];
        }
        String destEndpoint = "http://" + this.hostAgent + ":" + this.portAgent;
        TransferRequestMessage transferRequestMessage = new TransferRequestMessage();
        transferRequestMessage.setTransferId(this.transferId);
        transferRequestMessage.setSourceEndpoint(sourceEndpoint);
        transferRequestMessage.setDestEndpoint(destEndpoint);
        transferRequestMessage.setScope(this.scope.toString());
        transferRequestMessage.setInputUris(inputUris);
        if (this.transfer.getTypeOfStorage().compareTo(Types.storageType.LocalGHN.name()) == 0) {
            typeOfStorage = Types.storageType.LocalGHN;
            this.logger.debug((Object)"TransferHandler -- storageType=LocalGHN");
            String destinationFolder = this.transfer.getDestinationFolder();
            TransferOptions transferOptions = new TransferOptions();
            transferOptions.setType(typeOfStorage);
            transferOptions.setOverwriteFile(this.transfer.isOverwrite());
            transferOptions.setUnzipFile(this.transfer.isUnzipFile());
            transferOptions.setStorageManagerDetails(storageManagerDetails);
            transferRequestMessage.setDestination(destinationFolder);
            transferRequestMessage.setTransferOptions(SchedulerUtils.fillTransferOptions(transferOptions));
            transferRequestMessage.createTopicName(this.scope);
            try {
                this.msgClient.sendRequestMessage((GCUBEServiceContext)this.context, transferRequestMessage, new GCUBEScope[]{this.scope});
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.debug((Object)"TransferHandler -- Exception when call msgClient.sendRequestMessage ...");
                this.errorsInTransfer.add("TransferHandler -- IllegalArgumentException when call msgClient.sendRequestMessage ...");
                SchedulerUtils.updateStatusAndErrors(this.transferId, this.agent, "FAILED", this.errorsInTransfer);
                return;
            }
        }
        if (this.transfer.getTypeOfStorage().compareTo(Types.storageType.StorageManager.name()) == 0) {
            DataStorage storage = null;
            String storageId = this.transfer.getStorageId();
            Extent resultExtent = this.dbManager.getPersistenceManager().getExtent(DataStorage.class, true);
            Iterator iter = resultExtent.iterator();
            boolean flagExists = false;
            while (iter.hasNext()) {
                DataStorage obj = (DataStorage)iter.next();
                if (obj.getDataStorageId().compareTo(storageId) != 0) continue;
                storage = obj;
                flagExists = true;
                break;
            }
            if (!flagExists) {
                this.logger.error((Object)("TransferHandler - Error - datastorage with id=" + storageId + " does not exist in DB anymore"));
                this.errorsInTransfer.add("TransferHandler - Error - datastorage with id=" + storageId + " does not exist in DB anymore");
                SchedulerUtils.updateStatusAndErrors(this.transferId, this.agent, "FAILED", this.errorsInTransfer);
                return;
            }
            typeOfStorage = Types.storageType.StorageManager;
            this.logger.debug((Object)"TransferHandler -- storageType=StorageManager");
            storageManagerDetails.setOwner(storage.getOwner());
            storageManagerDetails.setServiceName(storage.getServiceName());
            storageManagerDetails.setServiceClass(storage.getServiceClass());
            storageManagerDetails.setAccessType(Types.storageAccessType.valueOf((String)storage.getAccessType()));
            String destinationFolder = this.transfer.getDestinationFolder();
            TransferOptions transferOptions = new TransferOptions();
            transferOptions.setType(typeOfStorage);
            transferOptions.setOverwriteFile(this.transfer.isOverwrite());
            transferOptions.setUnzipFile(this.transfer.isUnzipFile());
            transferOptions.setStorageManagerDetails(storageManagerDetails);
            transferRequestMessage.setDestination(destinationFolder);
            transferRequestMessage.setTransferOptions(SchedulerUtils.fillTransferOptions(transferOptions));
            transferRequestMessage.createTopicName(this.scope);
            try {
                this.msgClient.sendRequestMessage((GCUBEServiceContext)this.context, transferRequestMessage, new GCUBEScope[]{this.scope});
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.debug((Object)"TransferHandler -- Exception when call msgClient.sendRequestMessage ...");
                this.errorsInTransfer.add("TransferHandler -- Exception when call msgClient.sendRequestMessage ...");
                SchedulerUtils.updateStatusAndErrors(this.transferId, this.agent, "FAILED", this.errorsInTransfer);
                return;
            }
        }
        if (this.transfer.getTypeOfStorage().compareTo(Types.storageType.DataStorage.name()) == 0) {
            typeOfStorage = Types.storageType.DataStorage;
            this.logger.debug((Object)"TransferHandler -- storageType=DataStorage");
            ArrayList<URI> outputURIs = new ArrayList<URI>();
            for (TransferObject obj : objectsToBeTransferred) {
                try {
                    outputURIs.add(new URI(obj.getDestUri()));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            TransferOptions transferOptions = new TransferOptions();
            transferOptions.setType(typeOfStorage);
            transferOptions.setOverwriteFile(this.transfer.isOverwrite());
            transferOptions.setUnzipFile(this.transfer.isUnzipFile());
            transferOptions.setStorageManagerDetails(storageManagerDetails);
            transferRequestMessage.setOutputUris(outputURIs);
            transferRequestMessage.setTransferOptions(SchedulerUtils.fillTransferOptions(transferOptions));
            transferRequestMessage.createTopicName(this.scope);
            try {
                this.msgClient.sendRequestMessage((GCUBEServiceContext)this.context, transferRequestMessage, new GCUBEScope[]{this.scope});
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.debug((Object)"TransferHandler -- Exception when call msgClient.sendRequestMessage ...");
                this.errorsInTransfer.add("TransferHandler -- IllegalArgumentException when call msgClient.sendRequestMessage ...");
                SchedulerUtils.updateStatusAndErrors(this.transferId, this.agent, "FAILED", this.errorsInTransfer);
                return;
            }
        }
        this.updateStartTimeInTransfer();
    }

    public void treeBasedProcess() {
    }

    public void updateStartTimeInTransfer() {
        long startTime = System.currentTimeMillis();
        try {
            this.dbManager.updateStartTimeInTransfer(this.transferId, startTime);
        }
        catch (Exception e) {
            this.logger.debug((Object)"TransferHandler -- Exception when updating the start time ...");
            e.printStackTrace();
        }
    }

    public void sleepSixSec() {
        try {
            Thread.sleep(6000L);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)"\nTransferHandler (sleepFiveSec)-- InterruptedException-Unable to sleep");
            e.printStackTrace();
        }
    }
}

