/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.newhandler;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.common.messaging.BrokerSubscription;
import org.gcube.datatransfer.common.messaging.messages.TransferResponseMessage;
import org.gcube.datatransfer.common.messaging.utils.Utils;
import org.gcube.datatransfer.scheduler.impl.newhandler.TransferResponseListener;

public class TransferResponseSubscription
extends BrokerSubscription<TransferResponseListener> {
    private GCUBELog logger = new GCUBELog(((Object)((Object)this)).getClass());

    public TransferResponseSubscription(String subscriberEndpoint) {
        super(subscriberEndpoint);
    }

    public void setScope(GCUBEScope scope) {
        try {
            BrokerSubscription.DestinationPair pair = new BrokerSubscription.DestinationPair((BrokerSubscription)this);
            pair.setScope(scope);
            String topic = null;
            if (scope.isInfrastructure()) {
                topic = Utils.replaceUnderscore((String)scope.getName()) + "." + TransferResponseMessage.dataTransferLabel + ".*";
            } else if (scope.getType().compareTo((Enum)GCUBEScope.Type.VO) == 0) {
                String voName = scope.getName();
                topic = Utils.replaceUnderscore((String)scope.getInfrastructure().getName()) + "." + voName + "." + TransferResponseMessage.dataTransferLabel + ".*";
            }
            pair.setDestinationName(topic);
            pair.setQueue(true);
            this.setDestinationPair(pair);
            this.logger.debug((Object)("TransferResponseSubscription - topic=" + topic));
            this.listener = new TransferResponseListener(scope, this.subscriberEndpoint);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"TransferResponseSubscription - Exception...");
        }
    }
}

