package org.gcube.datatransfer.portlets.user.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

@RemoteServiceRelativePath("scheduler")
public interface SchedulerService extends RemoteService {
	String listFiles(String name) throws IllegalArgumentException;
	String getTransfers(String scope, String resourceName) throws IllegalArgumentException;
	String getObjectsFromIS(String type, String scope, String resourceName) throws IllegalArgumentException;

	String schedule(String obj) throws IllegalArgumentException;
	String monitor(String scope, String resourceName, String transferId) throws IllegalArgumentException;
	String getOutcomes(String scope, String resourceName, String transferId) throws IllegalArgumentException;
	String cancel(String scope, String resourceName, String transferId, boolean force) throws IllegalArgumentException;
	String getFileListOfDataSource(String dataSourceId, String specificPath, String scope,String resourceName) throws IllegalArgumentException;

}
