package org.gcube.datatransfer.portlets.user.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.gcube.datatransfer.portlets.user.shared.obj.BaseDto;
import org.gcube.datatransfer.portlets.user.shared.obj.CallingManagementResult;
import org.gcube.datatransfer.portlets.user.shared.obj.CallingSchedulerResult;
import org.gcube.datatransfer.portlets.user.shared.obj.FolderDto;
import org.gcube.datatransfer.portlets.user.shared.obj.ManuallyScheduled;
import org.gcube.datatransfer.portlets.user.shared.obj.PeriodicallyScheduled;
import org.gcube.datatransfer.portlets.user.shared.obj.SchedulerObj;
import org.gcube.datatransfer.portlets.user.shared.obj.TransferInfo;
import org.gcube.datatransfer.portlets.user.shared.obj.TypeOfSchedule;
import org.gcube.datatransfer.portlets.user.shared.prop.BaseDtoProperties;
import org.gcube.datatransfer.portlets.user.shared.prop.TransferInfoProperties;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.shared.DateTimeFormat;
import com.google.gwt.i18n.shared.DateTimeFormat.PredefinedFormat;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.text.shared.AbstractSafeHtmlRenderer;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.SimpleSafeHtmlCell;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.core.client.Style.Side;
import com.sencha.gxt.core.client.dom.XElement;
import com.sencha.gxt.core.client.util.DateWrapper;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.core.client.util.Point;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.SortDir;
import com.sencha.gxt.data.shared.Store.StoreSortInfo;
import com.sencha.gxt.data.shared.TreeStore;
import com.sencha.gxt.dnd.core.client.DndDropEvent;
import com.sencha.gxt.dnd.core.client.DndDropEvent.DndDropHandler;
import com.sencha.gxt.dnd.core.client.TreeDragSource;
import com.sencha.gxt.dnd.core.client.TreeDropTarget;
import com.sencha.gxt.widget.core.client.ContentPanel;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.box.AutoProgressMessageBox;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.AccordionLayoutContainer;
import com.sencha.gxt.widget.core.client.container.BorderLayoutContainer;
import com.sencha.gxt.widget.core.client.container.BorderLayoutContainer.BorderLayoutData;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutPack;
import com.sencha.gxt.widget.core.client.container.HorizontalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HorizontalLayoutContainer.HorizontalLayoutData;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.BeforeExpandItemEvent;
import com.sencha.gxt.widget.core.client.event.BeforeExpandItemEvent.BeforeExpandItemHandler;
import com.sencha.gxt.widget.core.client.event.CollapseEvent;
import com.sencha.gxt.widget.core.client.event.CollapseEvent.CollapseHandler;
import com.sencha.gxt.widget.core.client.event.DisableEvent;
import com.sencha.gxt.widget.core.client.event.DisableEvent.DisableHandler;
import com.sencha.gxt.widget.core.client.event.ExpandItemEvent;
import com.sencha.gxt.widget.core.client.event.ExpandItemEvent.ExpandItemHandler;
import com.sencha.gxt.widget.core.client.event.ParseErrorEvent;
import com.sencha.gxt.widget.core.client.event.ParseErrorEvent.ParseErrorHandler;
import com.sencha.gxt.widget.core.client.event.RowDoubleClickEvent;
import com.sencha.gxt.widget.core.client.event.RowDoubleClickEvent.RowDoubleClickHandler;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.CheckBox;
import com.sencha.gxt.widget.core.client.form.DateField;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.SimpleComboBox;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.form.TimeField;
import com.sencha.gxt.widget.core.client.form.validator.MinDateValidator;
import com.sencha.gxt.widget.core.client.grid.CellSelectionModel;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.Grid.GridCell;
import com.sencha.gxt.widget.core.client.grid.GridSelectionModel;
import com.sencha.gxt.widget.core.client.grid.editing.GridEditing;
import com.sencha.gxt.widget.core.client.grid.editing.GridRowEditing;
import com.sencha.gxt.widget.core.client.grid.filters.GridFilters;
import com.sencha.gxt.widget.core.client.grid.filters.StringFilter;
import com.sencha.gxt.widget.core.client.info.Info;
import com.sencha.gxt.widget.core.client.info.Info.InfoAppearance;
import com.sencha.gxt.widget.core.client.info.InfoConfig;
import com.sencha.gxt.widget.core.client.tips.ToolTipConfig;
import com.sencha.gxt.widget.core.client.toolbar.LabelToolItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;
import com.sencha.gxt.widget.core.client.tree.Tree;
import com.sencha.gxt.widget.core.client.tree.Tree.TreeNode;


public class SchedulerWidget implements EntryPoint, IsWidget {

	//general 
	private final SchedulerServiceAsync schedulerService = GWT.create(SchedulerService.class);

	//default values 
	String agentHostname;
	String destinationFolder = "/home/nick/Downloads/test";
	String workspaceFolder = "/home/nick/";

	//dialog box
	DialogBox dialogBoxGen;
	Button closeButton;

	//progress box
	AutoProgressMessageBox progressMessageBox;

	// for the layout
	BorderLayoutContainer con;
	VerticalPanel west, east ;
	ContentPanel south;
	BorderLayoutData westData, southData;
	MarginData eastData;

	//for the scheduler widget
	SimpleComboBox<String> frequency, typeOfSchedule, commands;
	TextField ResourceName, scope, transferId;
	FieldLabel dateLabel, timeLabel;
	CheckBox force;
	HorizontalPanel hp;
	DateField date;
	TimeField time;

	//for the tool bar widget for selecting from workspace/DataSources/URI's 
	ContentPanel cpForDatasource;
	SimpleComboBox<String> combo1, combo2 ;
	LabelToolItem combo1Label, combo2Label;
	MenuBar sourceType;
	Command workspaceCommand, datasourceCommand,uriCommand ;
	TextField destinationF;
	LabelToolItem destLabel;
	TextButton hideSchedulerButton, showSchedulerButton, sendButton;

	//for the list files widget (for selecting files from localFolder/DataSource)
	TreeStore<BaseDto> sourceStore, targetStore;
	Tree<BaseDto, String> sourceTree, targetTree;
	TreeDropTarget<BaseDto> targetTreeDropTarget, sourceTreeDropTarget;
	HorizontalLayoutContainer vpListFiles;
	String folderRes, currentPath, selectedDatasourcePath;
	FolderDto folder;
	AccordionLayoutContainer accordionLayout;
	ContentPanel datasources, uris;
	Grid<TransferInfo> grid;

	//for the widget of schedule in a specific row 
	SimpleComboBox<String> commandsInGrid;
	TextField ResourceNameInGrid, scopeInGrid, transferIdInGrid;
	CheckBox forceInGrid;

	//for the URI's widget
	UriProperties uriProperties = GWT.create(UriProperties.class);
	Grid<Uri> uriGrid;
	ListStore<Uri> storeForUris;
	GridEditing<Uri> editing;
	ColumnConfig<Uri, String> cc1Uris;
	ColumnConfig<Uri, String> cc2Uris;
	private GridEditing<Uri> createGridEditing(Grid<Uri> editableGrid) {
		return new GridRowEditing<Uri>(editableGrid);
	}

	//for selecting data source widget
	ListBox multiBox;
	List<String> dataSourcesList;
	String selectedDataSource;

	//other
	String callingManagementResultJson;
	String callingSchedulerResultJson;
	CallingManagementResult callingManagementResult;
	CallingSchedulerResult callingSchedulerResult;
	ListStore<TransferInfo> store;
	TransferInfoProperties props = GWT.create(TransferInfoProperties.class);
	List<String> inputUrls;
	int autoId;


	/*
	 * onModuleLoad
	 * input: Nothing -- output: Nothing
	 * This is the entry point method.
	 */
	public void onModuleLoad() {
		//set the auto Id for making folders in the tree
		this.autoId=0;	
		//create the dialog box general
		createDialogBoxGeneral();	
		//set the border layout
		RootPanel.get("mainContainer").add(asWidgetLayout());   
		//set the west widget for main scheduler service 
		west.add(asWidgetScheduler());
		//set the central widget for choosing files
		listFiles(workspaceFolder, 450);
		//set the south widget for list the transfers in DB
		ResourceName.setText("nick");
		scope.setText("/gcube/devsec");
		getTransfers();

		//some default URI's
		Uri temp=new Uri();
		storeForUris=new ListStore<Uri>(uriProperties.key());
		temp.setName("WikiPhoto1");
		temp.setURI("http://upload.wikimedia.org/wikipedia/commons/6/6e/Wikipedia_logo_silver.png");
		temp.setToBeTransferred(true);
		this.storeForUris.add(temp);
		temp=new Uri();
		temp.setName("WikiPhoto2");
		temp.setURI("http://upload.wikimedia.org/wikipedia/commons/c/c4/Kalamata%2C_Peloponnese%2C_Greece.jpg");
		temp.setToBeTransferred(true);
		this.storeForUris.add(temp);
		temp=new Uri();
		temp.setName("BigFile.iso");
		temp.setURI("http://ftp.lip6.fr/pub/linux/distributions/scientific/6.0/x86_64/iso/SL-60-x86_64-2011-03-03-Everything-DVD2.iso");
		temp.setToBeTransferred(true);
		this.storeForUris.add(temp);

		getDatasources();
	}

	/*
	 * asWidgetLayout
	 * input: Nothing -- output: Widget
	 * Sets the general Layout of the port-let
	 */
	public Widget asWidgetLayout() {

		FramedPanel panelGeneral = new FramedPanel();
		panelGeneral.setHeadingText("Scheduler Service");
		panelGeneral.setWidth("800px");
		panelGeneral.setBodyStyle("background: none; padding: 0px");

		west = new VerticalPanel();	    
		east = new VerticalPanel();    		    
		VerticalPanel southPanel = new VerticalPanel();
		south = new ContentPanel();
		southPanel.add(south);

		// Create a Dock Panel
		DockPanel dock = new DockPanel();
		//dock.setSpacing(4);
		dock.setHorizontalAlignment(DockPanel.ALIGN_CENTER);   

		dock.add(southPanel, DockPanel.SOUTH);
		dock.add(west, DockPanel.WEST);
		dock.add(east, DockPanel.EAST);

		// Return the content
		dock.ensureDebugId("cwDockPanel");
		panelGeneral.add(dock);

		return panelGeneral;
	}

	/*
	 * asWidgetToolbar
	 * input: Nothing -- output: Widget
	 * Creates the panel which provides the options for selecting files
	 * The user can choose between localFile-DataSource-URI
	 */
	public Widget asWidgetToolbar(int width){
		FramedPanel panel = new FramedPanel();
		panel.setHeadingHtml("Schedule Details");
		panel.setPixelSize(width,95);
		panel.addStyleName("margin-25");	
		HorizontalLayoutContainer outer = new HorizontalLayoutContainer();

		VerticalLayoutContainer outer1 = new VerticalLayoutContainer();
		VerticalLayoutContainer outer2 = new VerticalLayoutContainer();

		//item 2	
		if(combo2==null){
			combo2Label = new LabelToolItem("Dest Agent: ");
			combo2 = new SimpleComboBox<String>(new LabelProvider<String>() {
				public String getLabel(String item) {
					return item.toString().substring(0, 1) + item.toString().substring(1).toLowerCase();
				}
			});
			combo2.setTriggerAction(TriggerAction.ALL);
			combo2.setEditable(false);

			// Add a handler to change the data source
			combo2.addCollapseHandler(new CollapseHandler(){
				public void onCollapse(CollapseEvent event) {
					if(combo2==null)return;						
					String v = combo2.getCurrentValue() == null ? "nothing"
							: combo2.getCurrentValue();
					Info.display("Selected", "You selected " + v);
					if(v.compareTo("")==0)agentHostname=null;
					else agentHostname=v;
				}
			});
		}

		//item 1
		if(combo1==null){
			combo1Label = new LabelToolItem("Source: ");

			combo1 = new SimpleComboBox<String>(new LabelProvider<String>() {
				public String getLabel(String item) {
					return item.toString().substring(0, 1) + item.toString().substring(1).toLowerCase();
				}
			});

			combo1.setTriggerAction(TriggerAction.ALL);

			combo1.setEditable(false);
			combo1.add("Workspace");
			combo1.add("DataSource");	    
			combo1.add("URI");
			// Add a handler to change the data source
			combo1.addCollapseHandler(new CollapseHandler(){
				public void onCollapse(CollapseEvent event) {
					if(combo1==null)return;						
					String v = combo1.getCurrentValue() == null ? "nothing"
							: combo1.getCurrentValue();
					Info.display("Selected", "You selected " + v);
					int width=450;
					if(west.getWidgetCount()<1)width=780;

					if(combo1.getCurrentValue().compareTo("Workspace")==0){
						targetStore=null;
						listFiles(workspaceFolder,width);
						combo1.setValue("Workspace");
						combo2Label.show();
						combo2.show();
					}
					else if(combo1.getCurrentValue().compareTo("DataSource")==0){
						targetStore=null;
						getDatasources();
						east.clear();
						east.add(asWidgetToolbar(width));
						combo1.setValue("DataSource");
						combo2Label.show();
						combo2.show();
						east.add(asWidgetDataSource(width));
					}
					else{
						east.clear();
						east.add(asWidgetToolbar(width));
						combo1.setValue("URI");
						combo2Label.show();
						combo2.show();
						east.add(asWidgetUris(width));
					}

					//get the agents now ... 
					if(ResourceName.getCurrentValue()==null){
						printMsgInDialogBox("You should have a Resource Name !");
					}
					if(scope.getCurrentValue()==null){
						printMsgInDialogBox("You should have a Scope !");
					}
					else {
						fillComboBoxWithAgents();
					}
				}
			});
		}

		ToolBar toolbar = new ToolBar();
		toolbar.setBorders(true);	
		toolbar.add(combo1Label);
		toolbar.add(combo1);
		outer1.add(toolbar);

		fillComboBoxWithAgents();
		ToolBar toolbar2 = new ToolBar();
		toolbar2.setBorders(true);	
		toolbar2.add(combo2Label);
		toolbar2.add(combo2);
		outer2.add(toolbar2);


		if(destinationF==null){
			destLabel = new LabelToolItem("Destination: ");
			destinationF = new TextField();
			destinationF.setAllowBlank(false);
			destinationF.setValue(this.destinationFolder);
			destinationF.addValueChangeHandler(new ValueChangeHandler<String>() {
				public void onValueChange(ValueChangeEvent<String> event) {
					Info.display("Destination Folder Changed", "Destination Folder changed to " + event.getValue() == null ? "blank" : event.getValue());
				}
			});
		}

		ToolBar toolbar3 = new ToolBar();
		toolbar3.setBorders(true);	
		toolbar3.add(destLabel);
		toolbar3.add(destinationF);
		outer2.add(toolbar3);

		outer.add(outer1, new HorizontalLayoutData(.5, 1));
		outer.add(outer2, new HorizontalLayoutData(.5, 1));
		panel.setWidget(outer);
		//default value the first time
		if(combo1.getCurrentValue()==null){
			combo1.setValue("Workspace");
		}
		return panel;
	}

	public void fillComboBoxWithAgents(){
		if(combo2==null) return;
		//call the service and get the agents 
		schedulerService.getObjectsFromIS("Agent", scope.getCurrentValue(),ResourceName.getCurrentValue(),
				new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				printMsgInDialogBox("WARNING - Remote Procedure Call - Failure getting the Agents");
				
				List<String> agentsList = new ArrayList<String>();
				agentsList.add("");
				combo2.getStore().replaceAll(agentsList);
				combo2.setValue("");
				agentHostname=null;
			}
			public void onSuccess(String result) {
				if(result==null){
					printMsgInDialogBox("WARNING - Remote Procedure Call - Failure getting the Agents");
					List<String> agentsList = new ArrayList<String>();
					agentsList.add("");
					combo2.getStore().replaceAll(agentsList);
					combo2.setValue("");
					agentHostname=null;
					return;
				}
				else if (result.compareTo("")==0){
					printMsgInDialogBox("WARNING - No Agents exist now !");
					List<String> agentsList = new ArrayList<String>();
					agentsList.add("");
					combo2.getStore().replaceAll(agentsList);
					combo2.setValue("");
					agentHostname=null;
					return;
				}
				String[] agentsArray=result.split("\n");
				int num=0;
				String defaultValue="",defaultValue2="";

				List<String> agentsList = new ArrayList<String>();
				for(String tmp:agentsArray){
					//tmp contains: id--name--hostName--port
					String[] partsOfInfo=tmp.split("--");
					//we store only the hostname - the
					agentsList.add(partsOfInfo[2]);
					if(partsOfInfo[2].startsWith("pcitgt1012"))defaultValue2=partsOfInfo[2];
					if(num==0)defaultValue=partsOfInfo[2];
					else num=1;
				}
				combo2.getStore().replaceAll(agentsList);
				if(defaultValue2.compareTo("")==0){
					combo2.setValue(defaultValue);
					agentHostname=defaultValue;
				}
				else{
					combo2.setValue(defaultValue2);
					agentHostname=defaultValue2;
				}
			}
		}
				);
	}

	public void getDatasources(){

		//call the service and get the dataSources 
		schedulerService.getObjectsFromIS("DataSource", scope.getCurrentValue(),ResourceName.getCurrentValue(),
				new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				printMsgInDialogBox("WARNING - Remote Procedure Call - Failure getting the DataSources");
			}
			public void onSuccess(String result) {
				if(result==null){
					printMsgInDialogBox("WARNING - Remote Procedure Call - Failure getting the DataSources");
					return;
				}
				else if (result.compareTo("")==0){
					printMsgInDialogBox("WARNING - No DataSources exist now !");
					return;
				}
				
				String[] sourcesArray=result.split("\n");
				int num=0;
				dataSourcesList=new ArrayList<String>();
				for(String tmp:sourcesArray){
					//tmp contains: resultIdOfIS--name--description--endpoint--username--password--propertyFolders
					dataSourcesList.add(tmp);
					num++;
				}
				if(num==0){
					printMsgInDialogBox("No DataSources exist now !");
					
					dataSourcesList=null;
				}
			}
		}
				);
	}

	public Widget asWidgetListFiles(int width) {

		final ContentPanel cp1 = new ContentPanel();
		cp1.setPixelSize(width-10, 205);
		cp1.addStyleName("margin-8");

		VerticalLayoutContainer outer = new VerticalLayoutContainer();		 
		vpListFiles = new HorizontalLayoutContainer();

		final BaseDtoProperties props = GWT.create(BaseDtoProperties.class);	 
		if(folder==null){
			if(folderRes==null){
				this.printMsgInDialogBox("Error : retuned folderRes=null");
				folder=	this.makeFolder("Empty Folder");
			}
			else{
				folder = (FolderDto)FolderDto.createSerializer().deSerialize(folderRes, "org.gcube.datatransfer.portlets.user.shared.obj.FolderDto");
				folder = addTheGoBackOption();
			}
		}
		if(currentPath!=null)if(currentPath.compareTo("")==0)selectedDatasourcePath=folder.getName().replaceFirst(".//", "./");

		//printFolder(folder, 0);

		//******* source ******* 
		sourceStore = new TreeStore<BaseDto>(BaseDtoProperties.key);
		sourceStore.addSubTree(0, folder.getChildren());

		sourceTree =  new Tree<BaseDto, String>(sourceStore, props.shortname()) {
			protected boolean hasChildren(BaseDto model) {
				return super.hasChildren(model);
			}
		};		

		sourceTree.addBeforeExpandHandler(new BeforeExpandItemHandler<BaseDto>() {
			public void onBeforeExpand(BeforeExpandItemEvent<BaseDto> event) {
				TreeNode<BaseDto> node = sourceTree.findNode(event.getItem());
				sourceTree.refresh(node.getModel());

				if(event.getItem().getChildren()==null)return;

				//if the folder is empty .. 
				if (sourceTree.getStore().getChildCount(event.getItem())==0 
						|| (sourceTree.getStore().getChildCount(event.getItem())==1 && 
						sourceTree.getStore().getFirstChild(event.getItem()).getName().compareTo("")==0)){
					if(combo1.getCurrentValue().compareTo("DataSource")==0){
						listFilesOfDatasource(selectedDataSource,event.getItem().getName());
					}
					else if(combo1.getCurrentValue().compareTo("Workspace")==0){
						int width=450;
						if(west.getWidgetCount()<1)width=780;
						listFiles(event.getItem().getName(), width);
					}
				}
			}
		});
		sourceTree.addExpandHandler(new ExpandItemHandler<BaseDto>() {
			public void onExpand(ExpandItemEvent<BaseDto> event) {
				//Nothing
			}
		});
		new TreeDragSource<BaseDto>(sourceTree);
		//sourceTreeDropTarget = new TreeDropTarget<BaseDto>(sourceTree);	

		//******* target ******* 
		if(targetStore==null){
			targetStore = new TreeStore<BaseDto>(BaseDtoProperties.key);
			targetTree = new Tree<BaseDto, String>(targetStore, props.shortname()) {
				protected boolean hasChildren(BaseDto model) {
					return super.hasChildren(model);
				}
			};
			new TreeDragSource<BaseDto>(targetTree);
			targetTreeDropTarget = new TreeDropTarget<BaseDto>(targetTree);
			targetTreeDropTarget.addDropHandler(new DndDropHandler() {			
				public void onDrop(DndDropEvent event) {
					int num=0;
					if(targetStore.getAll()!=null){
						for(BaseDto tmp: targetStore.getAll()){
							if(tmp.getName().compareTo("")==0)continue;
							if(tmp.getChildren()!=null){
								if(tmp.getChildren().size()==1 && 
										tmp.getChildren().get(0).getData().getName().compareTo("")==0){
									targetStore.remove(tmp);	
									targetStore.commitChanges();
									Info.display("", "You can drag and drop files but not whole folders!!");
									sourceStore=null;
									continue;								
								}
							}
							num++;
						}
					}
					if(sourceStore==null){
						int width=450;
						if(west.getWidgetCount()<1)width=780;
						east.clear();
						east.add(asWidgetToolbar(width));
						east.add(asWidgetListFiles(width));
					}
					else Info.display("Files To Be Transferred", ""+num);	
				}
			});
		}	

		vpListFiles.add(sourceTree, new HorizontalLayoutData(.5, 1));
		vpListFiles.add(targetTree, new HorizontalLayoutData(.5, 1));
		vpListFiles.setBorders(true);
		sourceTree.setBorders(true);
		targetTree.setBorders(true);

		//*********** buttons  ************
		showSchedulerButton = new TextButton("Show Main");
		hideSchedulerButton=new TextButton("Hide Main");
		sendButton = new TextButton("Schedule");	
		TextButton clearTargetButton = new TextButton("Clear");		


		showSchedulerButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event){
				west.clear();
				west.add(asWidgetScheduler());
				//default values
				ResourceName.setText("nick");
				scope.setText("/gcube/devsec");
				east.clear();
				east.add(asWidgetToolbar(450));
				east.add(asWidgetListFiles(450));	
				showSchedulerButton.hide();
				hideSchedulerButton.show();
			}
		});
		hideSchedulerButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				west.clear();
				east.clear();
				east.add(asWidgetToolbar(780));
				east.add(asWidgetListFiles(780));
				hideSchedulerButton.hide();
				showSchedulerButton.show();
			}
		});
		if(west.getWidgetCount()<1){
			showSchedulerButton.show();
			hideSchedulerButton.hide();
		}
		else{
			showSchedulerButton.hide();
			hideSchedulerButton.show();
		}

		sendButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				//check for the fields of name-scope-and schedule
				if(checkFields())return;
				if(commands.getCurrentValue().compareTo("schedule")!=0){
					printMsgInDialogBox("You must select 'schedule' from the commands first! ");
					return;			
				}
				if(targetStore.getAll().size()<1){
					printMsgInDialogBox("You have not added any files for transfer");
					return;					
				}
				schedule();
			}
		});

		clearTargetButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				targetStore.clear();
				targetStore.commitChanges();
				sourceStore=null;
				int width=450;
				if(west.getWidgetCount()<1)width=780;
				east.clear();
				east.add(asWidgetToolbar(width));
				east.add(asWidgetListFiles(width));
			}
		});

		outer.add(vpListFiles, new VerticalLayoutData(1, 1));
		cp1.setWidget(outer);

		FramedPanel form = new FramedPanel();
		form.setHeadingText("");
		form.setWidth(width);
		VerticalLayoutContainer p = new VerticalLayoutContainer();
		p.add(cp1);

		p.add(hideSchedulerButton);
		p.add(showSchedulerButton);
		p.add(sendButton);
		p.add(clearTargetButton);
		clearTargetButton.getElement().setMargins(new Margins(0,0,0,width-170));

		form.add(p);

		cp1.setHeadingText(folder.getShortname());
		return form;
	}

	public FolderDto addTheGoBackOption(){		
		FolderDto empty = makeFolder("");

		String folderName = folder.getName().replaceFirst(".//", "./");
		String parentName = getParentName(folderName);
		//this.printMsgInDialogBox("folderName="+folderName+"\n"+"parentName="+parentName);
		if(parentName==null)return folder; // it means that there is no upper level

		FolderDto rootFolder=makeFolder(folderName);    //parent		

		FolderDto upFolder = makeFolder(parentName);
		upFolder.addChild(empty);
		upFolder.setShortname("<< Back");
		List<FolderDto> children = new ArrayList<FolderDto>();
		children.add(upFolder);										 //child-go back
		for(FolderDto tmp:folder.getChildren())children.add(tmp);	//rest of children
				rootFolder.setChildren(children);

				return rootFolder;
	}

	public String getParentName(String name){
		if(combo1.getCurrentValue().compareTo("DataSource")==0){
			if(selectedDatasourcePath==null || name.compareTo(selectedDatasourcePath)==0)return null;
		}
		else if(combo1.getCurrentValue().compareTo("Workspace")==0){
			if(name.compareTo(workspaceFolder)==0)return null;
		}
		String folderName =name;
		String upFolder="";
		String[] partsOfName=folderName.split("/");
		for(int i=0;i<partsOfName.length-1;i++){
			upFolder=upFolder.concat(partsOfName[i]+"/");
		}
		return upFolder;
	}

	public FolderDto makeFolder(String name) {
		FolderDto theReturn = new FolderDto(++autoId, name);
		theReturn.setChildren((List<FolderDto>) new ArrayList<FolderDto>());
		return theReturn;
	}

	/*
	 * asWidgetUris
	 * input: Nothing -- output: Widget
	 * Creates a widget for the panel where the user can add/use/modify URI's 
	 */
	public Widget asWidgetUris(int width) {

		cc1Uris = new ColumnConfig<Uri, String>(uriProperties.name(), 70, "Name");
		cc2Uris = new ColumnConfig<Uri, String>(uriProperties.URI(), 280, "URI");
		ColumnConfig<Uri, Boolean> cc3Uris = new ColumnConfig<Uri, Boolean>(uriProperties.toBeTransferred(), 70, "Transfer?");
		cc3Uris.setCell(new SimpleSafeHtmlCell<Boolean>(new AbstractSafeHtmlRenderer<Boolean>() {
			public SafeHtml render(Boolean object) {
				return SafeHtmlUtils.fromString(object ? "Yes" : "No");
			}
		}));
		List<ColumnConfig<Uri, ?>> l = new ArrayList<ColumnConfig<Uri, ?>>();
		l.add(cc1Uris);
		l.add(cc2Uris);
		l.add(cc3Uris);
		ColumnModel<Uri> cm = new ColumnModel<Uri>(l);	 
		if(storeForUris==null)storeForUris = new ListStore<Uri>(uriProperties.key());

		uriGrid = new Grid<Uri>(storeForUris, cm);
		uriGrid.getView().setAutoExpandColumn(cc1Uris);

		editing = createGridEditing(uriGrid);
		CheckBox checkField = new CheckBox();
		editing.addEditor(cc1Uris, new TextField());
		editing.addEditor(cc2Uris,new TextField());
		editing.addEditor(cc3Uris, checkField);

		FramedPanel cp = new FramedPanel();
		cp.setHeadingText("URI's");
		cp.setPixelSize(width, 255);
		cp.addStyleName("margin-10");

		ToolBar toolBar = new ToolBar();

		TextButton add = new TextButton("Add URI");
		add.setBorders(true);
		add.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				Uri uri = new Uri();
				uri.setName("New Uri 1");
				uri.setURI("http://example.gr");
				editing.cancelEditing();
				storeForUris.add(0, uri);
				editing.startEditing(new GridCell(0, 0));
			}
		});

		toolBar.add(add);	 
		VerticalLayoutContainer conGen = new VerticalLayoutContainer();

		VerticalLayoutContainer con = new VerticalLayoutContainer();
		con.setBorders(true);
		con.setHeight("185px");
		con.add(toolBar, new VerticalLayoutData(1, -1));
		con.add(uriGrid, new VerticalLayoutData(1, 1));

		//con.add(toolBar);
		//con.add(uriGrid);

		//cp.setButtonAlign(BoxLayoutPack.CENTER);
		//cp.setButtonAlign(BoxLayoutPack.START);
		// *********** buttons ************
		showSchedulerButton = new TextButton("Show Main");
		hideSchedulerButton=new TextButton("Hide Main");
		sendButton = new TextButton("Schedule");		

		showSchedulerButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event){
				west.clear();
				west.add(asWidgetScheduler());
				//default values
				ResourceName.setText("nick");
				scope.setText("/gcube/devsec");

				east.clear();
				east.add(asWidgetToolbar(450));
				combo1.setValue("URI");
				combo2Label.show();
				combo2.show();
				east.add(asWidgetUris(450));

				showSchedulerButton.hide();
				hideSchedulerButton.show();
			}
		});
		hideSchedulerButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				west.clear();
				east.clear();
				east.add(asWidgetToolbar(780));
				combo1.setValue("URI");
				combo2Label.show();
				combo2.show();
				east.add(asWidgetUris(780));
				hideSchedulerButton.hide();
				showSchedulerButton.show();
			}
		});
		if(west.getWidgetCount()<1){
			showSchedulerButton.show();
			hideSchedulerButton.hide();
		}
		else{
			showSchedulerButton.hide();
			hideSchedulerButton.show();
		}		
		sendButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				//check for the fields of name-scope-and schedule
				if(checkFields())return;
				if(commands.getCurrentValue().compareTo("schedule")!=0){
					printMsgInDialogBox("You must select 'schedule' from the commands first! ");
					return;	
				}
				if(storeForUris.getAll().size()<1){
					printMsgInDialogBox("You have not added any URIS for transfer");
					return;					
				}				
				schedule();
			}
		});
		HorizontalLayoutContainer butt  = new HorizontalLayoutContainer();
		butt.add(showSchedulerButton);
		butt.add(hideSchedulerButton);
		butt.add(sendButton);

		conGen.add(con);
		conGen.add(butt);
		cp.setWidget(conGen);	
		//cp.setButtonAlign(BoxLayoutPack.START);

		uriGrid.setSelectionModel(new CellSelectionModel<Uri>());	     
		uriGrid.getColumnModel().getColumn(0).setHideable(false);

		return cp;
	}

	/*
	 * asWidgetDataSource
	 * input: Nothing -- output: Widget
	 * Creates a widget for the panel where the user can choose a specific datasource
	 */
	public Widget asWidgetDataSource(int width) {

		// Add a list box with multiple selection enabled
		multiBox = new ListBox(true);
		multiBox.ensureDebugId("cwListBox-multiBox");
		multiBox.setWidth("150px");
		multiBox.setVisibleItemCount(10);
		VerticalPanel multiBoxPanel = new VerticalPanel();

		multiBoxPanel.setSpacing(4);
		multiBoxPanel.add(multiBox);

		FramedPanel cp = new FramedPanel();
		cp.setHeadingText("DataSource's");
		cp.setPixelSize(width, 255);
		cp.addStyleName("margin-10");

		VerticalLayoutContainer con = new VerticalLayoutContainer();
		con.setBorders(true);
		con.add(multiBoxPanel, new VerticalLayoutData(1, 1));

		cp.setWidget(con);	 
		//cp.setButtonAlign(BoxLayoutPack.CENTER);
		cp.setButtonAlign(BoxLayoutPack.START);

		TextButton selectButton=new TextButton("Select");
		selectButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				if(multiBox.getSelectedIndex()==-1){
					printMsgInDialogBox("You have not selected DataSource ! ");
				}
				else {
					String dataSourceName = multiBox.getValue(multiBox.getSelectedIndex());
					if(dataSourcesList!=null){
						for(String tmp:dataSourcesList){
							String[] parts=tmp.split("--");
							if(parts[1].compareTo(dataSourceName)==0){
								folderRes=null;
								folder=null;
								selectedDataSource=parts[0];
								listFilesOfDatasource(selectedDataSource,"");
								break;
							}
						}
					}
				}
			}
		});
		cp.addButton(selectButton);
		//adding items
		if(dataSourcesList!=null){
			for(String tmp:dataSourcesList){
				String[] parts=tmp.split("--");
				if(parts.length<2) this.printMsgInDialogBox("there is a datasource with info:\n'"+tmp+"'");
				else multiBox.addItem(parts[1]);
			}
		}
		return cp;
	}

	/*
	 * asWidgetScheduler
	 * input: Nothing -- output: Widget
	 * Creates the widget with the main form - the scheduler
	 */
	private Widget asWidgetScheduler() {

		VerticalPanel vp = new VerticalPanel();
		//vp.setSpacing(10);
		FramedPanel panel = new FramedPanel();
		panel.setHeadingText("Main");
		//panel.setWidth(300);
		panel.setPixelSize(300, 345);

		panel.setBodyStyle("background: none; padding: 5px");

		VerticalLayoutContainer p = new VerticalLayoutContainer();
		panel.add(p);

		ResourceName = new TextField();
		ResourceName.setAllowBlank(false);
		ResourceName.setEmptyText("Enter resource name...");
		ResourceName.addValueChangeHandler(new ValueChangeHandler<String>() {
			public void onValueChange(ValueChangeEvent<String> event) {
				Info.display("Value Changed", "Resource Name changed to " + event.getValue() == null ? "blank" : event.getValue());
			}
		});
		p.add(new FieldLabel(ResourceName, "Resource Name"), new VerticalLayoutData(1, -1));

		scope = new TextField();
		scope.setAllowBlank(false);
		scope.addValueChangeHandler(new ValueChangeHandler<String>() {
			public void onValueChange(ValueChangeEvent<String> event) {
				Info.display("Scope Changed", "Scope Name changed to " + event.getValue() == null ? "blank" : event.getValue());
			}
		});
		p.add(new FieldLabel(scope, "Scope"), new VerticalLayoutData(1, -1));

		transferId = new TextField();
		transferId.setAllowBlank(false);
		transferId.addValueChangeHandler(new ValueChangeHandler<String>() {
			public void onValueChange(ValueChangeEvent<String> event) {
				Info.display("TransferId Changed", "TransferId changed to " + event.getValue() == null ? "blank" : event.getValue());
			}
		});
		p.add(new FieldLabel(transferId, "Transfer id"), new VerticalLayoutData(1, -1));
		transferId.disable();

		force = new CheckBox();
		force.setBoxLabel("force cancel");
		force.disable();
		//hp = new HorizontalPanel();
		//hp.add(force);
		p.add(new FieldLabel(force, "Force cancel"));

		date = new DateField();
		date.addParseErrorHandler(new ParseErrorHandler() {
			public void onParseError(ParseErrorEvent event) {
				Info.display("Parse Error", event.getErrorValue() + " could not be parsed as a date");
			}
		});

		date.addValueChangeHandler(new ValueChangeHandler<Date>() {
			public void onValueChange(ValueChangeEvent<Date> event) {
				String v = event.getValue() == null ? "nothing"
						: DateTimeFormat.getFormat(PredefinedFormat.DATE_MEDIUM).format(event.getValue());
				Info.display("Selected", "You selected " + v);

			}
		});

		final long MILLIS_IN_A_DAY=1000*60*60*24;
		Date minDay=new Date();
		minDay.setTime(new Date().getTime()-MILLIS_IN_A_DAY);
		date.addValidator(new MinDateValidator(minDay));
		dateLabel = new FieldLabel(date, "Schedule Date");
		p.add(dateLabel, new VerticalLayoutData(1, -1));

		time = new TimeField();
		time.addParseErrorHandler(new ParseErrorHandler() {
			public void onParseError(ParseErrorEvent event) {
				Info.display("Parse Error", event.getErrorValue() + " could not be parsed as a valid time");
			}
		});

		time.setMinValue(new DateWrapper().clearTime().addHours(0).asDate());
		time.setMaxValue(new DateWrapper().clearTime().addHours(23).addSeconds(1).asDate());
		timeLabel = new FieldLabel(time, "Schedule Time");
		p.add(timeLabel , new VerticalLayoutData(1, -1));

		frequency = new SimpleComboBox<String>(new LabelProvider<String>() {
			public String getLabel(String item) {
				return item.toString().substring(0, 1) + item.toString().substring(1).toLowerCase();
			}
		});
		frequency.setTriggerAction(TriggerAction.ALL);
		frequency.setEditable(false);
		frequency.add("perMinute");
		frequency.add("perHour");
		frequency.add("perDay");
		frequency.add("perWeek");
		frequency.add("perMonth");
		frequency.add("perYear");
		frequency.setAllowBlank(true);
		frequency.setForceSelection(true);
		frequency.addCollapseHandler(new CollapseHandler(){
			public void onCollapse(CollapseEvent event) {
				if(frequency==null)return;						
				String v = frequency.getCurrentValue() == null ? "nothing"
						: frequency.getCurrentValue();
				Info.display("Selected", "You selected " + v);
			}
		});
		frequency.disable();		
		p.add(new FieldLabel(frequency, "Frequency"), new VerticalLayoutData(1, -1));


		typeOfSchedule = new SimpleComboBox<String>(new LabelProvider<String>() {
			public String getLabel(String item) {
				return item.toString().substring(0, 1) + item.toString().substring(1).toLowerCase();
			}
		});
		typeOfSchedule.setTriggerAction(TriggerAction.ALL);
		typeOfSchedule.setEditable(false);
		typeOfSchedule.add("direct");
		typeOfSchedule.add("manually scheduled");
		typeOfSchedule.add("periodically scheduled");
		typeOfSchedule.addCollapseHandler(new CollapseHandler(){
			public void onCollapse(CollapseEvent event) {
				if(typeOfSchedule==null)return;

				String v = typeOfSchedule.getCurrentValue() == null ? "nothing"
						: typeOfSchedule.getCurrentValue();
				Info.display("Selected", "You selected " + v);

				if(typeOfSchedule.getCurrentValue()==null)return;

				if(typeOfSchedule.getCurrentValue().compareTo("direct")==0){
					date.disable();
					time.disable();
					frequency.disable();
				}
				else if(typeOfSchedule.getCurrentValue().compareTo("manually scheduled")==0){
					date.enable();
					time.enable();
					dateLabel.setText("Schedule Date");
					timeLabel.setText("Schedule Time");
					frequency.disable();
				}
				else if(typeOfSchedule.getCurrentValue().compareTo("periodically scheduled")==0){
					date.enable();
					time.enable();
					dateLabel.setText("Schedule Start Date");
					timeLabel.setText("Schedule Start Time");
					frequency.enable();
				}
			}
		});
		typeOfSchedule.addDisableHandler(new DisableHandler(){
			public void onDisable(DisableEvent event) {
				date.disable();
				time.disable();
				frequency.disable();	
			}
		});
		typeOfSchedule.setAllowBlank(true);
		typeOfSchedule.setForceSelection(true);
		typeOfSchedule.disable();	

		p.add(new FieldLabel(typeOfSchedule, "Type of schedule"), new VerticalLayoutData(1, -1));


		commands = new SimpleComboBox<String>(new LabelProvider<String>() {
			public String getLabel(String item) {
				return item.toString().substring(0, 1) + item.toString().substring(1).toLowerCase();
			}
		});
		commands.setTriggerAction(TriggerAction.ALL);

		commands.setEditable(false);
		commands.add("schedule");
		commands.add("monitor");
		commands.add("get transfers");
		commands.add("get outcomes");
		commands.add("cancel");
		// Add a handler to change the data source
		commands.addCollapseHandler(new CollapseHandler(){
			public void onCollapse(CollapseEvent event) {				
				if(commands.getCurrentValue()==null)return;

				String v = commands.getCurrentValue() == null ? "nothing"
						: commands.getCurrentValue();
				Info.display("Selected", "You selected " + v);

				if(commands.getCurrentValue().compareTo("schedule")==0){
					transferId.disable();
					force.disable();
					typeOfSchedule.enable();
				}
				else if(commands.getCurrentValue().compareTo("monitor")==0){
					transferId.enable();
					force.disable();
					typeOfSchedule.disable();
				}
				else if(commands.getCurrentValue().compareTo("get transfers")==0){
					transferId.disable();
					force.disable();
					typeOfSchedule.disable();
				}
				else if(commands.getCurrentValue().compareTo("get outcomes")==0){
					transferId.enable();
					force.disable();
					typeOfSchedule.disable();
				}
				else if(commands.getCurrentValue().compareTo("cancel")==0){
					transferId.enable();
					force.enable();
					typeOfSchedule.disable();
				}
			}
		});

		commands.setAllowBlank(true);
		commands.setForceSelection(true);

		p.add(new FieldLabel(commands, "Commands"), new VerticalLayoutData(1, -1));

		// **************  buttons  **************
		TextButton submitButton=new TextButton("Submit");
		TextButton cancelButton=new TextButton("Cancel");

		cancelButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				RootPanel.get("scheduler").clear();		
			}
		});
		submitButton.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				//check for the fields of name-scope-and schedule
				if(checkFields())return;

				if(commands.getCurrentValue().compareTo("schedule")==0){			
					listFiles(workspaceFolder, 450);
				}
				else if(commands.getCurrentValue().compareTo("monitor")==0){
					monitor();
				}
				else if(commands.getCurrentValue().compareTo("get transfers")==0){
					getTransfers();
				}
				else if(commands.getCurrentValue().compareTo("get outcomes")==0){
					getOutcomes();
				}
				else if(commands.getCurrentValue().compareTo("cancel")==0){
					cancel();
				}
			}
		});		
		//p.add(cancelButton);
		p.add(submitButton);	
		vp.add(panel);
		return vp;
	}

	/*
	 * asWidgetCommandsInGrid
	 * input: Nothing -- output: Widget
	 * Creates the widget that works like a pop-up panel when the user double-click
	 * a specific transfer 
	 */
	private Widget asWidgetCommandsInGrid() {

		VerticalPanel vp = new VerticalPanel();
		//vp.setSpacing(10);
		FramedPanel panel = new FramedPanel();
		panel.setHeadingText("What do you want to do with this transfer?");
		panel.setWidth(300);
		//panel.setHeight(height);
		panel.setBodyStyle("background: none; padding: 5px");

		VerticalLayoutContainer p = new VerticalLayoutContainer();
		panel.add(p);

		transferIdInGrid = new TextField();
		transferIdInGrid.setAllowBlank(false);
		transferIdInGrid.addValueChangeHandler(new ValueChangeHandler<String>() {
			public void onValueChange(ValueChangeEvent<String> event) {
				Info.display("TransferId Changed", "TransferId changed to " + event.getValue() == null ? "blank" : event.getValue());
			}
		});
		p.add(new FieldLabel(transferIdInGrid, "Transfer id:"), new VerticalLayoutData(1, -1));
		transferIdInGrid.setText(grid.getSelectionModel().getSelection().get(0).getTransferId());


		commandsInGrid = new SimpleComboBox<String>(new LabelProvider<String>() {
			public String getLabel(String item) {
				return item.toString().substring(0, 1) + item.toString().substring(1).toLowerCase();
			}
		});
		commandsInGrid.setTriggerAction(TriggerAction.ALL);

		commandsInGrid.setEditable(false);
		commandsInGrid.add("monitor");
		commandsInGrid.add("get outcomes");
		commandsInGrid.add("cancel");
		// Add a handler to change the datasource
		commandsInGrid.addCollapseHandler(new CollapseHandler(){
			public void onCollapse(CollapseEvent event) {				
				//set the same values in the main form 
				if(commandsInGrid.getCurrentValue()==null)return;
				else commands.setText(commandsInGrid.getCurrentValue());				
				ResourceName.setText(ResourceNameInGrid.getCurrentValue());
				scope.setText(scopeInGrid.getCurrentValue());
				transferId.setText(transferIdInGrid.getCurrentValue());
				if(force.isEnabled())force.setValue(forceInGrid.getValue());
				//-------------------------------------
				String v = commandsInGrid.getCurrentValue() == null ? "nothing"
						: commandsInGrid.getCurrentValue();
				Info.display("Selected", "You selected " + v);

				if(commandsInGrid.getCurrentValue().compareTo("monitor")==0){
					transferId.enable();
					force.disable();
					forceInGrid.disable();
				}
				else if(commands.getCurrentValue().compareTo("get outcomes")==0){
					transferId.enable();
					force.disable();
					forceInGrid.disable();
				}
				else if(commandsInGrid.getCurrentValue().compareTo("cancel")==0){
					transferId.enable();
					force.enable();
					forceInGrid.enable();
				}
			}
		});

		commandsInGrid.setAllowBlank(true);
		commandsInGrid.setForceSelection(true);

		p.add(new FieldLabel(commandsInGrid, "Commands"), new VerticalLayoutData(1, -1));


		ResourceNameInGrid = new TextField();
		ResourceNameInGrid.setAllowBlank(false);
		ResourceNameInGrid.addValueChangeHandler(new ValueChangeHandler<String>() {
			public void onValueChange(ValueChangeEvent<String> event) {
				Info.display("Value Changed", "Resource Name changed to " + event.getValue() == null ? "blank" : event.getValue());
			}
		});
		p.add(new FieldLabel(ResourceNameInGrid, "Resource Name"), new VerticalLayoutData(1, -1));
		ResourceNameInGrid.setText(ResourceName.getCurrentValue());

		scopeInGrid = new TextField();
		scopeInGrid.setAllowBlank(false);
		scopeInGrid.addValueChangeHandler(new ValueChangeHandler<String>() {
			public void onValueChange(ValueChangeEvent<String> event) {
				Info.display("Scope Changed", "Scope Name changed to " + event.getValue() == null ? "blank" : event.getValue());
			}
		});
		p.add(new FieldLabel(scopeInGrid, "Scope"), new VerticalLayoutData(1, -1));
		scopeInGrid.setText(scope.getCurrentValue());

		forceInGrid = new CheckBox();
		forceInGrid.setBoxLabel("force cancel");
		forceInGrid.disable();
		p.add(new FieldLabel(forceInGrid, "Force cancel"));
		forceInGrid.setValue(force.getValue());


		// **************  buttons  **************
		Button submitButton=new Button("Submit");
		Button cancelButton=new Button("Cancel");

		cancelButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				dialogBoxGen.hide();
				createDialogBoxGeneral();
			}
		});
		submitButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				dialogBoxGen.hide();
				createDialogBoxGeneral();

				//check for the fields of name-scope-and schedule
				if(checkFields())return;

				if(commandsInGrid.getCurrentValue().compareTo("monitor")==0){					
					monitor();
				}
				else if(commandsInGrid.getCurrentValue().compareTo("get outcomes")==0){
					getOutcomes();
				}
				else if(commandsInGrid.getCurrentValue().compareTo("cancel")==0){
					cancel();
				}
			}
		});		
		p.add(cancelButton);
		p.add(submitButton);	
		vp.add(panel);
		return vp;
	}

	/*
	 * schedule
	 * Remote procedure call for schedule 
	 */
	void schedule(){	
		String text="";		
		if(this.typeOfSchedule.getCurrentValue().compareTo("direct")==0)text="direct";	
		else if(this.typeOfSchedule.getCurrentValue().compareTo("periodically scheduled")==0)text="periodically";
		else if(this.typeOfSchedule.getCurrentValue().compareTo("manually scheduled")==0)text="manually";

		printMsgInDialogBox("You have submitted a "+text+" scheduled transfer .. ");

		SchedulerObj scheduleObj = new SchedulerObj();
		scheduleObj = fillSchedulerObj(scheduleObj);
		if(scheduleObj==null)return;
		String jsonString = SchedulerObj.createSerializer().serialize(scheduleObj);

		schedulerService.schedule(jsonString,
				new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				printMsgInDialogBox("ERROR - Remote Procedure Call - Failure schedule");
			}
			public void onSuccess(String result) {
				if(result==null){
					printMsgInDialogBox("ERROR - Remote Procedure Call - Failure schedule");
				}
				else{
					String transferIdResult=result;
					printMsgInDialogBox("'schedule': transfer id="+transferIdResult);
				}				
			}
		});

	}

	/*
	 * fillSchedulerObj
	 * Fills an empty SchedulerObj with all the info
	 */
	SchedulerObj fillSchedulerObj(SchedulerObj scheduleObj){
		scheduleObj.setSubmitter(this.ResourceName.getCurrentValue());
		scheduleObj.setScope(this.scope.getCurrentValue());
		scheduleObj.setAgentHostname(agentHostname);
		scheduleObj.setUnzipFile(false);
		scheduleObj.setOverwrite(true);
		scheduleObj.setSyncOp(false);
		scheduleObj.setDestinationFolder(destinationF.getCurrentValue());
		DateTimeFormat formatter = DateTimeFormat.getFormat("dd.MM.yy-HH.mm");
		scheduleObj.setSubmittedDate(formatter.format(new Date()));

		if(combo1.getCurrentValue().compareTo("Workspace")==0){
			inputUrls = new ArrayList<String>();
			for(BaseDto tmp: this.targetStore.getAll()){
				if(tmp.getName().compareTo("")==0)continue;
				if(tmp.getChildren()!=null){
					if(tmp.getChildren().size()==1 && 
							tmp.getChildren().get(0).getData().getName().compareTo("")==0)continue;
				}
				inputUrls.add("file:"+tmp.getName());
			}
			scheduleObj.setInputUrls(inputUrls);	
			scheduleObj.setTypeOfTransfer("LocalFileBasedTransfer");
		}
		else if(combo1.getCurrentValue().compareTo("DataSource")==0){
			if(selectedDataSource==null){
				this.printMsgInDialogBox("You have not selected DataSource !");
				return null;
			}
			scheduleObj.setDataSourceId(selectedDataSource);
			inputUrls = new ArrayList<String>();
			int num=0;
			for(BaseDto tmp: this.targetStore.getAll()){
				if(tmp.getName().compareTo("")==0)continue;
				if(tmp.getChildren()!=null){
					if(tmp.getChildren().size()==1 && 
							tmp.getChildren().get(0).getData().getName().compareTo("")==0)continue;
				}
				inputUrls.add(tmp.getName());
				num++;
			}
			scheduleObj.setInputUrls(inputUrls);	
			scheduleObj.setTypeOfTransfer("FileBasedTransfer");
			scheduleObj.setStorageType("LocalGHN");
		}
		else if(combo1.getCurrentValue().compareTo("URI")==0){		
			printMsgInDialogBox("	URI");
			inputUrls = new ArrayList<String>();
			storeForUris.commitChanges();
			for(Uri tmp: storeForUris.getAll()){
				if(tmp.getURI()==null||tmp.isToBeTransferred()==false)continue;
				inputUrls.add(tmp.getURI());
			}
			scheduleObj.setInputUrls(inputUrls);	
			scheduleObj.setTypeOfTransfer("FileBasedTransfer");
			scheduleObj.setStorageType("LocalGHN");
		}

		TypeOfSchedule typeOfScheduleObj = new TypeOfSchedule();
		if(this.typeOfSchedule.getCurrentValue().compareTo("direct")==0){
			typeOfScheduleObj.setDirectedScheduled(true);
		}
		else if(this.typeOfSchedule.getCurrentValue().compareTo("manually scheduled")==0){
			ManuallyScheduled manuallyScheduled = new ManuallyScheduled();
			//DateTimeFormat formatter = DateTimeFormat.getFormat("dd.MM.yy-HH.mm");
			DateTimeFormat tmpFormatter1 = DateTimeFormat.getFormat("dd.MM.yy");
			String day = tmpFormatter1.format(this.date.getCurrentValue());
			DateTimeFormat tmpFormatter2 = DateTimeFormat.getFormat("HH.mm");
			String time= tmpFormatter2.format(this.time.getCurrentValue());
			//the string below represent the date in a format: "dd.MM.yy-HH.mm"
			String instanceString = day.concat("-").concat(time);

			manuallyScheduled.setInstanceString(instanceString);
			typeOfScheduleObj.setManuallyScheduled(manuallyScheduled);
		}
		else if(this.typeOfSchedule.getCurrentValue().compareTo("periodically scheduled")==0){
			PeriodicallyScheduled periodicallyScheduled = new PeriodicallyScheduled();
			periodicallyScheduled.setFrequency(this.frequency.getCurrentValue());
			//DateTimeFormat formatter = DateTimeFormat.getFormat("dd.MM.yy-HH.mm");
			DateTimeFormat tmpFormatter1 = DateTimeFormat.getFormat("dd.MM.yy");
			String day = tmpFormatter1.format(this.date.getCurrentValue());
			DateTimeFormat tmpFormatter2 = DateTimeFormat.getFormat("HH.mm");
			String time= tmpFormatter2.format(this.time.getCurrentValue());
			//the string below represent the date in a format: "dd.MM.yy-HH.mm"
			String startInstanceString = day.concat("-").concat(time);

			periodicallyScheduled.setStartInstanceString(startInstanceString);
			typeOfScheduleObj.setPeriodicallyScheduled(periodicallyScheduled);
		}
		scheduleObj.setTypeOfSchedule(typeOfScheduleObj);		
		return scheduleObj;
	}

	/*
	 * monitor
	 * Remote procedure call for monitoring
	 */
	void monitor(){
		printMsgInDialogBox("You have submitted a monitor task .. ");

		schedulerService.monitor(this.scope.getCurrentValue(), this.ResourceName.getCurrentValue(), this.transferId.getCurrentValue(),
				new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				printMsgInDialogBox("'monitor': Failure");
			}
			public void onSuccess(String result) {
				if(result==null)printMsgInDialogBox("'monitor': result=null\n");			
				else{
					callingSchedulerResult = (CallingSchedulerResult)CallingSchedulerResult.createSerializer().deSerialize(result, "org.gcube.datatransfer.portlets.user.shared.obj.CallingSchedulerResult");					
					String errors="";
					int i=0;
					for(String tmp: callingSchedulerResult.getErrors()){
						if(tmp.compareTo("")==0)continue;
						if(i==0)errors=errors.concat("errors:\n");
						errors=errors.concat("- "+tmp+"\n");
						i++;
					}	
					printMsgInDialogBox("'monitor':\n   transfer result:"+callingSchedulerResult.getMonitorResult()+"\n"+errors+"\n");
				}
			}
		});
	}

	/*
	 * getOutcomes
	 * Remote procedure call for getting the outcomes 
	 */
	void getOutcomes(){
		printMsgInDialogBox("You have submitted a getOutcomes task .. ");

		schedulerService.getOutcomes(this.scope.getCurrentValue(), this.ResourceName.getCurrentValue(), this.transferId.getCurrentValue(),
				new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				printMsgInDialogBox("'getOutcomes': Failure");
			}
			public void onSuccess(String result) {
				if(result==null)printMsgInDialogBox("'getOutcomes': result=null\n");			
				else{
					callingSchedulerResult = (CallingSchedulerResult)CallingSchedulerResult.createSerializer().deSerialize(result, "org.gcube.datatransfer.portlets.user.shared.obj.CallingSchedulerResult");					
					String errors="";
					int i=0;
					for(String tmp: callingSchedulerResult.getErrors()){
						if(tmp.compareTo("")==0)continue;
						if(i==0)errors=errors.concat("errors:\n");
						errors=errors.concat("- "+tmp+"\n");
						i++;
					}	
					printMsgInDialogBox("'getOutcomes':\n   outcomes:\n"+callingSchedulerResult.getSchedulerOutcomes()+"\n"+errors+"\n");
				}
			}
		});
	}

	/*
	 * cancel
	 * Remote procedure call for canceling 
	 */
	void cancel(){
		printMsgInDialogBox("You have submitted a cancel task .. ");

		schedulerService.cancel(this.scope.getCurrentValue(), this.ResourceName.getCurrentValue(), this.transferId.getCurrentValue(),this.force.getValue(),
				new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				dialogBoxGen
				.setText("'cancel': Failure");
				dialogBoxGen.center();
				closeButton.setFocus(true);
			}
			public void onSuccess(String result) {
				if(result==null)printMsgInDialogBox("'cancel': result=null\n");			
				else{
					callingSchedulerResult = (CallingSchedulerResult)CallingSchedulerResult.createSerializer().deSerialize(result, "org.gcube.datatransfer.portlets.user.shared.obj.CallingSchedulerResult");					
					String errors="";
					int i=0;
					for(String tmp: callingSchedulerResult.getErrors()){
						if(tmp.compareTo("")==0)continue;
						if(i==0)errors=errors.concat("errors:\n");
						errors=errors.concat("- "+tmp+"\n");
						i++;
					}	
					printMsgInDialogBox("'cancel': "+callingSchedulerResult.getCancelResult()+"\n"+errors+"\n");
				}
			}
		});
	}

	/*
	 * getTransfers
	 * Remote procedure call for getting transfers from DB
	 */
	void getTransfers(){
		schedulerService.getTransfers(scope.getCurrentValue(),ResourceName.getCurrentValue(),
				new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				printMsgInDialogBox("'getTransfers': Failure");
			}
			public void onSuccess(String result) {
				if(result==null){
					printMsgInDialogBox("'getTransfers': result=null");
				}
				else{
					callingManagementResultJson=result;
					getTransfersDesign();
				}				
			}
		});
	}

	/*
	 * getTransfersDesign
	 * Designs the grid which presents the transfers from DB
	 */
	void getTransfersDesign(){
		callingManagementResult = (CallingManagementResult)CallingManagementResult.createSerializer().deSerialize(callingManagementResultJson, "org.gcube.datatransfer.portlets.user.shared.obj.CallingManagementResult");

		ColumnConfig<TransferInfo, String> transferId = new ColumnConfig<TransferInfo, String>(props.transferId(), 200, "TransferId");
		ColumnConfig<TransferInfo, String> submitter = new ColumnConfig<TransferInfo, String>(props.submitter(), 100, "Submitter");
		ColumnConfig<TransferInfo, String> status = new ColumnConfig<TransferInfo, String>(props.status(), 100, "Status");

		status.setCell(new AbstractCell<String>() {
			@Override
			public void render(Context context, String value, SafeHtmlBuilder sb) {
				String style;	        
				if(value.compareTo("COMPLETED")==0)style = "style='color: green'"; 			
				else if(value.compareTo("CANCELED")==0 || value.compareTo("FAILED")==0)style = "style='color: red'"; 
				else if(value.compareTo("ONGOING")==0)style = "style='color: navy'"; 
				else style = "style='color: blue'";   
				sb.appendHtmlConstant("<span " + style + " qtitle='Change' qtip='" + value + "'>" + value + "</span>");
			}
		});

		ColumnConfig<TransferInfo, String> type = new ColumnConfig<TransferInfo, String>(props.typeOfScheduleString(), 250, "Type");
		type.setCell(new AbstractCell<String>() {
			@Override
			public void render(Context context, String value, SafeHtmlBuilder sb) {
				//String style="style='color: blue'";	     

				String newValue=null;
				if(value.startsWith("Periodically")){
					String test = value;
					String[] tokens = test.split("-");
					newValue=tokens[0]+"<br/>"+tokens[1]+"-"+tokens[2];
				}
				else newValue=value;				
				sb.appendHtmlConstant("<span qtitle='Change' qtip='type'>" + newValue + "</span>");
			}
		});

		ColumnConfig<TransferInfo, String> submittedDate = new ColumnConfig<TransferInfo, String>(props.submittedDate(), 150, "Submitted Date");
		submittedDate.setCell(new AbstractCell<String>() {
			@Override
			public void render(Context context, String value, SafeHtmlBuilder sb) {
				//String style="style='color: blue'";
				sb.appendHtmlConstant("<span qtitle='submittedDate' qtip='submittedDate'>" + value + "</span>");
			}
		});


		List<ColumnConfig<TransferInfo, ?>> l = new ArrayList<ColumnConfig<TransferInfo, ?>>();
		l.add(transferId);
		l.add(submitter);
		l.add(status);
		l.add(type);
		l.add(submittedDate);


		ColumnModel<TransferInfo> cm = new ColumnModel<TransferInfo>(l);

		store = new ListStore<TransferInfo>(props.key());
		StoreSortInfo<TransferInfo> sortInfo = new StoreSortInfo<TransferInfo>(props.submittedDate(),SortDir.DESC);
		store.addSortInfo(sortInfo);

		south.clear();
		Date current= new Date();

		south.setHeadingText("Transfer Details at "+DateTimeFormat.getFormat("HH:mm:ss  EEE, d MMM yyyy").format(current)+"  --  Submitter: '"+ResourceName.getCurrentValue()+"'");
		//refresh button
		ToolBar toolBar = new ToolBar();
		TextButton refresh = new TextButton("refresh");
		refresh.setBorders(true);
		//refresh.setPixelSize(30, 5);

		refresh.addSelectHandler(new SelectHandler() {
			public void onSelect(SelectEvent event) {
				getTransfers();
			}
		});
		toolBar.add(refresh);	

		VerticalLayoutContainer vert=new VerticalLayoutContainer();
		vert.setWidth("785px");
		vert.add(toolBar);

		grid = new Grid<TransferInfo>(store, cm);

		grid.getView().setAutoExpandColumn(transferId);

		grid.setBorders(false);
		grid.getView().setStripeRows(true);
		grid.getView().setColumnLines(true);
		grid.setHeight("120px");

		// Add a selection model so we can select cells.
		final GridSelectionModel<TransferInfo> selectionModel =
				new GridSelectionModel<TransferInfo>();
		grid.setSelectionModel(selectionModel);
		grid.addRowDoubleClickHandler(new RowDoubleClickHandler() {
			public void onRowDoubleClick(RowDoubleClickEvent event) {
				dialogBoxGen = new DialogBox();
				dialogBoxGen.setAnimationEnabled(true);
				dialogBoxGen.add(asWidgetCommandsInGrid());		
				dialogBoxGen.center();
			}
		});

		StringFilter<TransferInfo> transferIdFilter = new StringFilter<TransferInfo>(props.transferId());
		StringFilter<TransferInfo> submitterFilter = new StringFilter<TransferInfo>(props.submitter());
		StringFilter<TransferInfo> statusFilter = new StringFilter<TransferInfo>(props.status());

		GridFilters<TransferInfo> filters = new GridFilters<TransferInfo>();
		filters.initPlugin(grid);
		filters.setLocal(true);
		filters.addFilter(transferIdFilter);
		filters.addFilter(submitterFilter);
		filters.addFilter(statusFilter);

		vert.add(grid);
		south.add(vert);

		if(this.callingManagementResult!=null){
			for(TransferInfo tmp : this.callingManagementResult.getAllTheTransfersInDB()){
				store.add(tmp);
			}
		}
	}



	/*
	 * checkFields
	 * input: Nothing -- output: Boolean
	 * Depends on the command that the user has selected it checks
	 * the appropriate fields. It returns true when user forgot to fill/select sth.
	 * In other case returns false
	 */
	boolean checkFields(){

		//check for the command combo box
		if(commands==null){
			printMsgInDialogBox("You should choose a Command !");
			return true;
		}
		if(commands.getCurrentValue()==null){
			printMsgInDialogBox("You should choose a Command !");
			return true;
		}

		//check for resource name and scope
		if(ResourceName.getCurrentValue()==null){
			printMsgInDialogBox("You should have a Resource Name !");
			return true;
		}
		if(scope.getCurrentValue()==null){
			printMsgInDialogBox("You should have a Scope !");
			return true;
		}

		if(commands.getCurrentValue().compareTo("monitor")==0 ||
				commands.getCurrentValue().compareTo("get outcomes")==0 ||
				commands.getCurrentValue().compareTo("cancel")==0){
			if(transferId.getCurrentValue()==null){
				printMsgInDialogBox("You should have a transfer id !");
				return true;
			}
		}

		if(commands.getCurrentValue().compareTo("schedule")!=0)return false;

		//check if we have a source type and if it's Uri or Workspace we check if we have agent .. 
		if(this.agentHostname==null){
			printMsgInDialogBox("You should have an agent !");
			return true;
		}

		//check if we have a destination folder 
		if(this.destinationF==null){
			printMsgInDialogBox("You should have a destination folder !");
			return true;
		}
		if(this.destinationF.getCurrentValue()==null){
			printMsgInDialogBox("You should have a destination folder !");
			return true;
		}

		//check for the typeOfSchedule combo box
		if(typeOfSchedule==null){
			printMsgInDialogBox("You should have a type of Schedule !");
			return true;
		}
		if(typeOfSchedule.getCurrentValue()==null){
			printMsgInDialogBox("You should have a type of Schedule !");
			return true;
		}

		//then our check depends on which type of schedule we have
		if(typeOfSchedule.getCurrentValue().compareTo("manually scheduled")==0){
			if(date.getCurrentValue()==null){
				printMsgInDialogBox("You should have a Schedule Date !");
				return true ;
			}
			if(time.getCurrentValue()==null){
				printMsgInDialogBox("You should have a Schedule Time !");
				return true ;
			}
		}
		else if(typeOfSchedule.getCurrentValue().compareTo("periodically scheduled")==0){
			if(date.getCurrentValue()==null){
				printMsgInDialogBox("You should have a Schedule Start Date !");
				return true ;
			}
			if(time.getCurrentValue()==null){
				printMsgInDialogBox("You should have a Schedule -stStart Time !");
				return true ;
			}
			if(frequency.getCurrentValue()==null){
				printMsgInDialogBox("You should have a frequency !");
				return true ;
			}
		}
		return false;
	}

	/*
	 * printFolder
	 * Prints a FolderDto folder
	 */
	public String printFolderString;
	void printFolder(FolderDto folder, int indent){
		if(indent==0)printFolderString="";
		for(int i = 0; i < indent; i++) printFolderString=printFolderString.concat("\t");
		printFolderString=printFolderString.concat("folder: name="+folder.getName() +" - id="+folder.getId()+"\n");

		List<FolderDto> tmpListOfChildren = folder.getChildren();
		if(tmpListOfChildren!=null){
			for(FolderDto tmp : tmpListOfChildren){ //first the files
				if(tmp.getChildren().size() <= 0){
					if(tmp.getName().compareTo("")==0)continue;
					for(int i = 0; i < indent; i++) System.out.print("\t");
					printFolderString=printFolderString.concat("file : id="+tmp.getId()+" - name="+tmp.getName()+"\n");
				}
			}		    	
			for(FolderDto tmp : tmpListOfChildren){ //then the folders
				if(tmp.getChildren().size() > 0){
					printFolder(tmp,indent+1);
				}
			}
		}
		if(indent==0){
			this.printMsgInDialogBox(printFolderString);
		}
	}


	/*
	 * listFiles
	 * input: String -- output: Nothing
	 * Takes a String with the path of the folder that the user
	 * wants to show and select from files. It also re-creates the ListFiles-Widget
	 */
	public void listFiles(String path, int size){
		progressMessageBox = new AutoProgressMessageBox("Please wait", "Loading items...");
		progressMessageBox.setProgressText("Initializing...");
		progressMessageBox.auto();
		progressMessageBox.show();
		final int width=size;

		schedulerService.listFiles(path,
				new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				progressMessageBox.hide();
				printMsgInDialogBox("Remote Procedure Call - Failure list files");
				Info.display("Message", "Items were not loaded");
			}
			public void onSuccess(String folderResult) {
				progressMessageBox.hide();
				folderRes=folderResult;
				folder=null;
				east.clear();
				east.add(asWidgetToolbar(width));
				east.add(asWidgetListFiles(width));	
				if(folderRes==null)Info.display("Message", "Items were not loaded");
				else Info.display("Message", "Items were loaded");
			}
		}
				);
	}

	/*
	 * listFilesOfDatasource
	 * input: String -- output: Nothing
	 * Takes a String with the name of the data source that the user
	 * wants to show and select from files. It also re-creates the ListFiles-Widget
	 */

	public void listFilesOfDatasource(String dataSourceId,String path){
		progressMessageBox = new AutoProgressMessageBox("Please wait", "Loading items...");
		progressMessageBox.setProgressText("Initializing...");
		progressMessageBox.auto();
		progressMessageBox.show();
		int size=450;
		if(west.getWidgetCount()<1)size=780;
		final int width = size;
		currentPath=path;

		schedulerService.getFileListOfDataSource(dataSourceId,path,scope.getCurrentValue(),ResourceName.getCurrentValue(),
				new AsyncCallback<String>() {
			public void onFailure(Throwable caught) {
				progressMessageBox.hide();
				printMsgInDialogBox("Remote Procedure Call - Failure list files");
				Info.display("Message", "Items were not loaded");
			}
			public void onSuccess(String folderResult) {
				progressMessageBox.hide();
				folderRes=folderResult;
				folder=null;
				east.clear();
				east.add(asWidgetToolbar(width));
				east.add(asWidgetListFiles(width));
				if(folderRes==null)Info.display("Message", "Items were not loaded");
				else Info.display("Message", "Items were loaded");
			}
		}
				);
	}

	/*
	 * createDialogBoxGeneral
	 * Sets the DialogBox 
	 */
	public void createDialogBoxGeneral (){
		// --- Create the popup DialogBoxGeneral ---
		dialogBoxGen = new DialogBox();
		dialogBoxGen.setText("");
		dialogBoxGen.setAnimationEnabled(true);

		closeButton = new Button("Close");
		// We can set the id of a widget by accessing its Element
		closeButton.getElement().setId("closeButton");
		// Add a handler to close the DialogBox
		closeButton.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				dialogBoxGen.hide();
			}
		});

		dialogBoxGen.add(closeButton);
	}
	/*
	 * printMsgInDialogBox
	 * input: String -- output: Nothing
	 * Takes a string and prints the message in a dialogBox. 
	 * Newlines in the original string are converted to <br> tags.
	 */
	public void printMsgInDialogBox(String message){
		if(!dialogBoxGen.isShowing()){
		SafeHtmlBuilder builder = new SafeHtmlBuilder();				
		builder.appendEscapedLines(message);
		dialogBoxGen
		.setHTML(builder.toSafeHtml());
		dialogBoxGen.center();
		closeButton.setFocus(true);
		}
		else Info.display("! Message ! ", message);		
	}

	public ToolTipConfig createToolTipConfig(String title, String body){
		ToolTipConfig config = new ToolTipConfig();
		config.setTitleText(title);
		config.setBodyText(body);
		config.setMouseOffset(new int[] {0,0});
		config.setAnchor(Side.LEFT);
		return config;
	}
	public Widget asWidget() {
		return null;
	}


}
