/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.plugins.thredds;

import java.util.concurrent.Callable;
import org.gcube.data.transfer.plugin.model.DataTransferContext;
import org.gcube.data.transfer.plugins.thredds.LocalConfiguration;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationConfigurationRetriever
implements Callable<ApplicationConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(ApplicationConfigurationRetriever.class);
    private DataTransferContext ctx;
    private long timeout = LocalConfiguration.getTTL("context.loading.timeout");

    public ApplicationConfigurationRetriever(DataTransferContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public ApplicationConfiguration call() throws Exception {
        ApplicationConfiguration toReturn = null;
        log.info("Waiting for thredds application to be loaded");
        long startTime = System.currentTimeMillis();
        while (toReturn == null & System.currentTimeMillis() - startTime < this.timeout) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (ApplicationConfiguration app : this.ctx.getCtx().container().configuration().apps()) {
                log.debug("Found app {} ", (Object)app.context());
                if (!app.context().equals("thredds") && !app.context().equals("/thredds")) continue;
                toReturn = app;
            }
        }
        log.info("Retrieved {} after {}ms ", toReturn, (Object)(System.currentTimeMillis() - startTime));
        return toReturn;
    }
}

