package org.gcube.dataanalysis.dataminer.poolmanager.service;

import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Algorithm;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Cluster;
import org.gcube.dataanalysis.dataminer.poolmanager.util.SVNUpdater;

public class StagingJob extends DMPMJob {
	
	
	private Algorithm algorithm;
	private Cluster stagingCluster;
	private Cluster rProtoCluster;

	public StagingJob(SVNUpdater svnUpdater, Algorithm algorithm, Cluster stagingCluster, Cluster rProtoCluster) {
		super(svnUpdater);
		this.algorithm = algorithm;
		this.stagingCluster = stagingCluster;
		this.rProtoCluster = rProtoCluster;
	}

	@Override
	protected void execute() {
		try {
			
			int ret = this.executeAnsibleWorker(
					createWorker(this.algorithm, this.stagingCluster, true, "root"));
		
			if(ret == 0){
				
				
				this.updateSVNDependencies(this.algorithm, true);
				
				
				int ret2 = this.executeAnsibleWorker(
						createWorker(this.algorithm, this.rProtoCluster, false, "gcube"));
				
			}
		
		
		
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
