package org.gcube.dataanalysis.dataminer.poolmanager.clients;

import static org.gcube.resources.discovery.icclient.ICFactory.client;
import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Algorithm;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Cluster;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Dependency;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Domain;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Host;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.comparator.HostComparator;
import org.gcube.dataanalysis.dataminer.poolmanager.service.DataminerPoolManager;
import org.gcube.informationsystem.publisher.AdvancedScopedPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

import au.com.bytecode.opencsv.CSVReader;

public class DMPMClientConfigurator {
	private static final Logger LOGGER = LoggerFactory.getLogger(DMPMClientConfigurator.class);

	public String getStagingHost() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/stage/ghost/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getProdHost() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/prod/ghost/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getSVNStagingAlgorithmsList() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/stage/svn.stage.algorithms-list/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getStageRepository() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/stage/svn.stage.software.repo/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getGhostAlgoDirectory() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/stage/svn.stage.algo.ghost.repo/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getSVNStagingLinuxCompiledDepsList() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/stage/svn.stage.deps-linux-compiled/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getSVNStagingPreInstalledDepsList() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/stage/svn.stage.deps-pre-installed/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getSVNStagingRBDepsList() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/stage/svn.stage.deps-r-blackbox/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getSVNStagingCRANDepsList() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/stage/svn.stage.deps-r/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getSVNStagingJavaDepsList() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/stage/svn.stage.deps-java/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getSVNStagingKWDepsList() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/stage/svn.stage.deps-knime-workflow/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getSVNStagingOctaveDepsList() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/stage/svn.stage.deps-octave/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getSVNStagingPythonDepsList() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/stage/svn.stage.deps-python/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getSVNStagingWCDepsList() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/stage/svn.stage.deps-windows-compiled/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getSVNProdAlgorithmsList() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/prod/svn.prod.algorithms-list/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getProdRepository() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/prod/svn.prod.software.repo/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getProdGhostAlgoDirectory() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/prod/svn.prod.algo.ghost.repo/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getSVNProdLinuxCompiledDepsList() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/prod/svn.prod.deps-linux-compiled/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getSVNProdPreInstalledDepsList() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/prod/svn.prod.deps-pre-installed/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getSVNProdRBDepsList() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/prod/svn.prod.deps-r-blackbox/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getSVNProdCRANDepsList() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/prod/svn.prod.deps-r/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getSVNProdJavaDepsList() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/prod/svn.prod.deps-java/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getSVNProdKWDepsList() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/prod/svn.prod.deps-knime-workflow/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getSVNProdOctaveDepsList() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/prod/svn.prod.deps-octave/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getSVNProdPythonDepsList() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/prod/svn.prod.deps-python/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
	
	public String getSVNProdWCDepsList() {
		// TODO Auto-generated method stub
		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource/Profile/Body/prod/svn.prod.deps-windows-compiled/text()");
		DiscoveryClient<String> client = client();
		List<String> ds = client.submit(query);
		for (String a : ds) {
			ghost = a;
		}		
		return ghost.trim();
	}
		
	public String getSVNRepository() {
		// TODO Auto-generated method stub

		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource");
		DiscoveryClient<GenericResource> client = clientFor(GenericResource.class);
		List<GenericResource> ds = client.submit(query);
		for (GenericResource a : ds) {
			ghost = a.profile().body().getElementsByTagName("svn.repository").item(0).getTextContent();
		}
		return ghost.trim();
	}
	
//	public String getSVNRepo() {
//		// TODO Auto-generated method stub
//
//		String ghost = "";
//		SimpleQuery query = queryFor(GenericResource.class);
//		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource");
//		DiscoveryClient<GenericResource> client = clientFor(GenericResource.class);
//		List<GenericResource> ds = client.submit(query);
//		for (GenericResource a : ds) {
//			ghost = a.profile().body().getElementsByTagName("svn_repo").item(0).getTextContent();
//		}
//		return ghost;
//	}

	public String getSVNMainAlgoRepo() {
		// TODO Auto-generated method stub

		String ghost = "";
		SimpleQuery query = queryFor(GenericResource.class);
		query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource");
		DiscoveryClient<GenericResource> client = clientFor(GenericResource.class);
		List<GenericResource> ds = client.submit(query);
		for (GenericResource a : ds) {
			ghost = a.profile().body().getElementsByTagName("svn.algo.main.repo").item(0).getTextContent();
		}
		return ghost.trim();
	}
	
	
	public static void main(String[] args) throws IOException, SVNException {
		DMPMClientConfigurator a = new DMPMClientConfigurator();
		ScopeProvider.instance.set("/gcube/devNext/NextNext");
		//SecurityTokenProvider.instance.set("708e7eb8-11a7-4e9a-816b-c9ed7e7e99fe-98187548");
		
		System.out.println(a.getSVNProdCRANDepsList());
		//System.out.println(a.getRepo());
		//System.out.println(a.getAlgoRepo());
		//System.out.println(a.getSVNRepo());

	}
}
