/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.dataminer.poolmanager.ansiblebridge;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import org.gcube.dataanalysis.dataminer.poolmanager.ansible.AnsibleWorker;
import org.gcube.dataanalysis.dataminer.poolmanager.ansible.model.AnsibleHost;
import org.gcube.dataanalysis.dataminer.poolmanager.ansible.model.Inventory;
import org.gcube.dataanalysis.dataminer.poolmanager.ansible.model.Playbook;
import org.gcube.dataanalysis.dataminer.poolmanager.ansible.model.Role;
import org.gcube.dataanalysis.dataminer.poolmanager.ansiblebridge.template.AlgorithmPackage;
import org.gcube.dataanalysis.dataminer.poolmanager.ansiblebridge.template.CranDependencyPackage;
import org.gcube.dataanalysis.dataminer.poolmanager.ansiblebridge.template.CustomDependencyPackage;
import org.gcube.dataanalysis.dataminer.poolmanager.ansiblebridge.template.CustomRoleManager;
import org.gcube.dataanalysis.dataminer.poolmanager.ansiblebridge.template.OSDependencyPackage;
import org.gcube.dataanalysis.dataminer.poolmanager.ansiblebridge.template.StaticRoleManager;
import org.gcube.dataanalysis.dataminer.poolmanager.ansiblebridge.template.TemplateManager;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Algorithm;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.AlgorithmSet;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Cluster;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Dependency;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Host;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.comparator.HostComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnsibleBridge {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnsibleBridge.class);
    private String dpmRoot;

    public AnsibleBridge() {
        this(System.getProperty("user.home") + File.separator + "dataminer-pool-manager");
    }

    public AnsibleBridge(String root) {
        this.dpmRoot = root;
        this.ensureServiceRoot();
    }

    private void ensureServiceRoot() {
        new File(this.dpmRoot).mkdirs();
        this.getWorkDir().mkdirs();
    }

    private File getWorkDir() {
        return new File(this.dpmRoot, "work");
    }

    public AnsibleWorker createWorker(Algorithm algorithm, Cluster dataminerCluster, boolean includeAlgorithmDependencies, String user) throws IOException {
        File workerRoot = new File(this.getWorkDir(), UUID.randomUUID().toString());
        AnsibleWorker worker = new AnsibleWorker(workerRoot);
        Vector<Role> algoRoles = new Vector<Role>();
        for (Object r : this.generateRoles(algorithm, includeAlgorithmDependencies)) {
            algoRoles.add((Role)r);
            worker.addRole((Role)r);
        }
        if (includeAlgorithmDependencies) {
            for (Dependency d : algorithm.getDependencies()) {
                for (Role r : this.generateRoles(d)) {
                    worker.addRole(r);
                }
            }
        }
        for (Object r : this.getStaticRoleManager().getStaticRoles()) {
            worker.addRole((Role)r);
        }
        Inventory inventory = new Inventory();
        for (Host h : dataminerCluster.getHosts()) {
            AnsibleHost ah = new AnsibleHost(h.getName());
            inventory.addHost(ah, "universe");
            inventory.addHost(ah, "d4science");
        }
        worker.setInventory(inventory);
        Playbook playbook = new Playbook();
        playbook.setRemote_user(user);
        playbook.applyTo("universe");
        for (Role r : algoRoles) {
            if (r.getName().endsWith("remove")) continue;
            playbook.addRole(r.getName());
        }
        worker.setPlaybook(playbook);
        return worker;
    }

    public void printInventoryByDomainAndSets(Collection<Cluster> clusters) {
        TreeMap<String, TreeSet<Host>> inventory = new TreeMap<String, TreeSet<Host>>();
        for (Cluster cluster : clusters) {
            for (AlgorithmSet as : cluster.getAlgorithmSets()) {
                String asName = as.getName();
                for (Host h : cluster.getHosts()) {
                    String domain = h.getDomain().getName();
                    String key = String.format("[%s@%s]", asName, domain);
                    TreeSet<Host> hosts = (TreeSet<Host>)inventory.get(key);
                    if (hosts == null) {
                        hosts = new TreeSet<Host>((Comparator<Host>)new HostComparator());
                        inventory.put(key, hosts);
                    }
                    hosts.add(h);
                }
            }
        }
        for (String key : inventory.keySet()) {
            System.out.println(key);
            Collection hosts = (Collection)inventory.get(key);
            for (Host h : hosts) {
                System.out.println(h.getName() + "." + h.getDomain().getName());
            }
            System.out.println();
        }
    }

    public void printInventoryBySets(Collection<Cluster> clusters) {
        TreeMap<String, TreeSet<Host>> inventory = new TreeMap<String, TreeSet<Host>>();
        for (Cluster cluster : clusters) {
            for (AlgorithmSet as : cluster.getAlgorithmSets()) {
                String asName = as.getName();
                for (Host h : cluster.getHosts()) {
                    String key = String.format("[%s]", asName);
                    TreeSet<Host> hosts = (TreeSet<Host>)inventory.get(key);
                    if (hosts == null) {
                        hosts = new TreeSet<Host>((Comparator<Host>)new HostComparator());
                        inventory.put(key, hosts);
                    }
                    hosts.add(h);
                }
            }
        }
        for (String key : inventory.keySet()) {
            System.out.println(key);
            Collection hosts = (Collection)inventory.get(key);
            for (Host h : hosts) {
                System.out.println(h.getName() + "." + h.getDomain().getName());
            }
            System.out.println();
        }
    }

    private TemplateManager getTemplateManager() {
        return new TemplateManager();
    }

    private CustomRoleManager getCustomRoleManager() {
        return new CustomRoleManager();
    }

    private StaticRoleManager getStaticRoleManager() {
        return new StaticRoleManager();
    }

    public Collection<Role> generateRoles(Dependency d) {
        CranDependencyPackage pkg;
        Vector<Role> roles = new Vector<Role>();
        if ("os".equalsIgnoreCase(d.getType())) {
            OSDependencyPackage pkg2 = new OSDependencyPackage(d);
            if (pkg2 != null) {
                roles.addAll(pkg2.getRoles(this.getTemplateManager()));
            }
        } else if ("custom".equalsIgnoreCase(d.getType())) {
            CustomDependencyPackage pkg3 = new CustomDependencyPackage(d);
            if (pkg3 != null) {
                roles.addAll(pkg3.getRoles(this.getCustomRoleManager()));
            }
        } else if ("github".equalsIgnoreCase(d.getType())) {
            CranDependencyPackage pkg4 = new CranDependencyPackage(d);
            if (pkg4 != null) {
                roles.addAll(pkg4.getRoles(this.getTemplateManager()));
            }
        } else if ("cran".equalsIgnoreCase(d.getType()) && (pkg = new CranDependencyPackage(d)) != null) {
            roles.addAll(pkg.getRoles(this.getTemplateManager()));
        }
        return roles;
    }

    public Collection<Role> generateRoles(Algorithm a, boolean includeAlgorithmDependencies) {
        AlgorithmPackage pkg = new AlgorithmPackage(a, includeAlgorithmDependencies);
        return pkg.getRoles(this.getTemplateManager());
    }
}

