package org.gcube.dataaccess.ckanutillibrary;

import java.util.List;
import java.util.Map;

import org.gcube.dataaccess.ckanutillibrary.models.CKanUserWrapper;
import org.gcube.dataaccess.ckanutillibrary.models.ROLES_IN_ORGANIZATION;

import eu.trentorise.opendata.jackan.model.CkanOrganization;

/**
 * This is the ckan-util-library interface that shows the utility methods.
 * @author Costantino Perciante at ISTI-CNR (costantino.perciante@isti.cnr.it)
 */
public interface CKanUtilsInterface {
	
	/**
	 * Retrieve the API_KEY given the username .
	 * @param username
	 * @return an API_KEY string
	 */
	public String getApiKeyFromUser(String username);
	
	/**
	 * Retrieve the user given the API_KEY (the user is retrieved if it is active).
	 * @param username
	 * @return an API_KEY string
	 */
	public CKanUserWrapper getUserFromApiKey(String apiKey);
	
	/**
	 * Returns the list of organizations to whom the user belongs. 
	 * @param username
	 * @return a list of organizations
	 */
	public List<CkanOrganization> getOrganizationsByUser(String username);
	
	/**
	 * Returns the list of organizations' names to whom the user belongs. 
	 * @param username
	 * @return a list of organizations
	 */
	public List<String> getOrganizationsNamesByUser(String username);
	
	/**
	 * Given a username and a list of roles to be matched, find the organizations to who the user
	 * belongs and the role(s) he has in them.
	 * @param username
	 * @param rolesToMatch
	 * @return
	 */
	public Map<String, List<ROLES_IN_ORGANIZATION>> getGroupsAndRolesByUser(String username, List<ROLES_IN_ORGANIZATION> rolesToMatch);

	/**
	 * Return the ckan catalogue url in this scope.
	 * @return
	 */
	public String getCatalogueUrl();
	
	/**
	 * Get the list of licenses' titles.
	 * @return
	 */
	public List<String> getLicenseTitles();
	
	/**
	 * Finds the id associated to the chosen license
	 * @param chosenLicense
	 * @return
	 */
	public String findLicenseIdByLicense(String chosenLicense);
	
}
