/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.algorithms.drmalgorithms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataaccess.databases.access.DatabasesDiscoverer;
import org.gcube.dataaccess.databases.resources.DBResource;
import org.gcube.dataaccess.databases.utils.DatabaseManagement;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalInfraAlgorithm;
import org.gcube.resources.discovery.client.api.DiscoveryException;
import org.gcube.resources.discovery.client.api.InvalidResultException;
import org.hibernate.HibernateException;

public class GetTableDetails
extends StandardLocalInfraAlgorithm {
    private static final String ROWS_NUMBER = "Rows Number";
    private static final String NAME_OF_COLUMNS = "Name Of Columns";
    private static final String CREATE_TABLE_STATEMENT = "Create Table Statement";
    private LinkedHashMap<String, StatisticalType> map = new LinkedHashMap();
    private DatabaseManagement mgt;
    private String driverInfo;
    private String resourceName = null;
    private String databaseName = null;
    private String schemaName = null;
    private String tableName = null;

    public void init() throws Exception {
        this.mgt = new DatabaseManagement(this.config.getConfigPath());
        AnalysisLogger.getLogger().debug((Object)"In GetTableDetails->Initialization");
        String scope = this.config.getGcubeScope();
        AnalysisLogger.getLogger().debug((Object)("In GetTableDetails->scope set by config: " + scope));
    }

    public String getDescription() {
        return "Algorithm that allows to view table details of a chosen database";
    }

    protected void process() throws Exception, IOException, IllegalStateException, DiscoveryException, InvalidResultException, HibernateException {
        AnalysisLogger.getLogger().debug((Object)"In GetTableDetails->Processing");
        try {
            List<String> Info = this.retrieveInfo();
            this.getConnection(Info);
            this.map = this.getDetails();
        }
        catch (HibernateException h) {
            AnalysisLogger.getLogger().debug((Object)("In GetTableDetails-> ERROR " + h.getMessage()));
            throw h;
        }
        catch (IllegalStateException e) {
            AnalysisLogger.getLogger().debug((Object)("In GetTableDetails-> ERROR " + e.getMessage()));
            throw e;
        }
        catch (DiscoveryException e1) {
            AnalysisLogger.getLogger().debug((Object)("In GetTableDetails-> ERROR " + e1.getMessage()));
            throw e1;
        }
        catch (InvalidResultException e2) {
            AnalysisLogger.getLogger().debug((Object)("In GetTableDetails-> ERROR " + e2.getMessage()));
            throw e2;
        }
        catch (IOException e3) {
            AnalysisLogger.getLogger().debug((Object)("In GetTableDetails-> Exception " + e3.getMessage()));
            throw e3;
        }
        catch (Exception e4) {
            AnalysisLogger.getLogger().debug((Object)("In GetTableDetails-> Exception " + e4.getMessage()));
            throw e4;
        }
        finally {
            this.mgt.closeConnection();
        }
    }

    protected void setInputParameters() {
        this.addStringInput("ResourceName", "The name of the resource", "");
        this.addStringInput("DatabaseName", "The name of the database", "");
        this.addStringInput("SchemaName", "The name of the schema", "");
        this.addStringInput("TableName", "The name of the table", "");
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"In GetTableDetails->Shutdown");
    }

    public StatisticalType getOutput() {
        AnalysisLogger.getLogger().debug((Object)"In GetTableDetails->retrieving outputs");
        PrimitiveType output = new PrimitiveType(LinkedHashMap.class.getName(), this.map, PrimitiveTypes.MAP, "ResultsMap" + UUID.randomUUID(), "Results Map");
        return output;
    }

    private void getConnection(List<String> Info) throws IOException {
        Iterator<String> iterator = Info.iterator();
        String DatabaseUserName = iterator.next();
        String DatabasePassword = iterator.next();
        String DatabaseDriver = iterator.next();
        String DatabaseDialect = iterator.next();
        String DatabaseURL = iterator.next();
        String DatabaseName = iterator.next();
        this.mgt.createConnection(DatabaseUserName, DatabasePassword, DatabaseDriver, DatabaseDialect, DatabaseURL, DatabaseName);
        AnalysisLogger.getLogger().debug((Object)("In GetTableDetails->database " + DatabaseName + ": connected"));
    }

    private List<String> retrieveInfo() throws Exception, IllegalStateException, DiscoveryException, InvalidResultException {
        this.resourceName = this.getInputParameter("ResourceName");
        if (this.resourceName != null) {
            this.resourceName = this.getInputParameter("ResourceName").trim();
        }
        if (this.resourceName == null || this.resourceName.equals("")) {
            throw new Exception("Warning: insert the resource name");
        }
        this.databaseName = this.getInputParameter("DatabaseName");
        if (this.databaseName != null) {
            this.databaseName = this.getInputParameter("DatabaseName").trim();
        }
        if (this.databaseName == null || this.databaseName.equals("")) {
            throw new Exception("Warning: insert the database name");
        }
        DatabasesDiscoverer discovery = new DatabasesDiscoverer();
        List resources = discovery.discover();
        AnalysisLogger.getLogger().debug((Object)("In GetTableDetails->number of database resources: " + resources.size()));
        for (int i = 0; i < resources.size(); ++i) {
            AnalysisLogger.getLogger().debug((Object)("In GetTableDetails->Resource's name: " + ((DBResource)resources.get(i)).getResourceName()));
        }
        ArrayList<String> info = new ArrayList<String>();
        block1: for (int i = 0; i < resources.size(); ++i) {
            if (!((DBResource)resources.get(i)).getResourceName().toLowerCase().equals(this.resourceName.toLowerCase())) continue;
            this.normalizeDBInfo((DBResource)resources.get(i));
            for (int j = 0; j < ((DBResource)resources.get(i)).getAccessPoints().size(); ++j) {
                if (!((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDatabaseName().toLowerCase().equals(this.databaseName.toLowerCase())) continue;
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getUsername());
                AnalysisLogger.getLogger().debug((Object)("In GetTableDetails->username: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getUsername()));
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getPassword());
                AnalysisLogger.getLogger().debug((Object)("In GetTableDetails->password: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getPassword()));
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDriver());
                this.driverInfo = ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDriver();
                AnalysisLogger.getLogger().debug((Object)("In GetTableDetails->driver: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDriver()));
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDialect());
                AnalysisLogger.getLogger().debug((Object)("In GetTableDetails->dialect: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDialect()));
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).address());
                AnalysisLogger.getLogger().debug((Object)("In GetTableDetails->url: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).address()));
                info.add(this.databaseName);
                AnalysisLogger.getLogger().debug((Object)("In GetTableDetails->databasename: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDatabaseName()));
                break block1;
            }
        }
        AnalysisLogger.getLogger().debug((Object)"In GetTableDetails->information useful for connection: retrieved");
        return info;
    }

    private LinkedHashMap<String, StatisticalType> getDetails() throws Exception {
        this.tableName = this.getInputParameter("TableName");
        if (this.tableName != null) {
            this.tableName = this.getInputParameter("TableName").trim();
        }
        if (this.tableName == null || this.tableName.equals("")) {
            throw new Exception("Warning: insert the table name");
        }
        if (this.driverInfo.toLowerCase().contains("postgres")) {
            this.schemaName = this.getInputParameter("SchemaName");
            if (this.schemaName != null) {
                this.schemaName = this.getInputParameter("SchemaName").trim();
            }
            if (this.schemaName == null || this.schemaName.equals("")) {
                throw new Exception("Warning: insert the schema name");
            }
        }
        AnalysisLogger.getLogger().debug((Object)("In GetTableDetails->getting details on the table: " + this.tableName));
        String createTable = null;
        if (this.driverInfo.toLowerCase().contains("postgres")) {
            createTable = this.mgt.getCreateTable(this.tableName, this.schemaName);
        }
        if (this.driverInfo.toLowerCase().contains("mysql")) {
            createTable = this.mgt.getCreateTable(this.tableName, this.databaseName);
        }
        PrimitiveType valCreateTable = new PrimitiveType(String.class.getName(), (Object)createTable, PrimitiveTypes.STRING, CREATE_TABLE_STATEMENT, CREATE_TABLE_STATEMENT);
        this.map.put(CREATE_TABLE_STATEMENT, (StatisticalType)valCreateTable);
        AnalysisLogger.getLogger().debug((Object)("In GetTableDetails->getting the \"CreateTableStatement\": " + createTable));
        List listColumnNamesTable = this.mgt.getListColumnNamesTable();
        String ColumnName = "";
        for (int i = 0; i < listColumnNamesTable.size(); ++i) {
            ColumnName = i != listColumnNamesTable.size() - 1 ? ColumnName + (String)listColumnNamesTable.get(i) + "," : ColumnName + (String)listColumnNamesTable.get(i);
        }
        AnalysisLogger.getLogger().debug((Object)("In GetTableDetails->column names: " + ColumnName));
        PrimitiveType valListColumnNamesTable = new PrimitiveType(String.class.getName(), (Object)ColumnName, PrimitiveTypes.STRING, NAME_OF_COLUMNS, NAME_OF_COLUMNS);
        this.map.put(NAME_OF_COLUMNS, (StatisticalType)valListColumnNamesTable);
        AnalysisLogger.getLogger().debug((Object)("In GetTableDetails->getting the column names list: " + createTable));
        long rows = 0L;
        if (this.driverInfo.toLowerCase().contains("postgres")) {
            AnalysisLogger.getLogger().debug((Object)("In GetTableDetails->schemaName:" + this.schemaName));
            rows = this.mgt.getNumberOfRows(this.tableName, this.schemaName);
        }
        if (this.driverInfo.toLowerCase().contains("mysql")) {
            AnalysisLogger.getLogger().debug((Object)("In GetTableDetails->*databasename:" + this.databaseName));
            rows = this.mgt.getNumberOfRows(this.tableName, this.databaseName);
        }
        PrimitiveType valRows = new PrimitiveType(String.class.getName(), (Object)Long.toString(rows), PrimitiveTypes.STRING, ROWS_NUMBER, ROWS_NUMBER);
        this.map.put(ROWS_NUMBER, (StatisticalType)valRows);
        AnalysisLogger.getLogger().debug((Object)("In GetTableDetails->getting the number of rows: " + Long.toString(rows)));
        return this.map;
    }

    private void normalizeDBInfo(DBResource resource) throws Exception {
        try {
            int ap = resource.getAccessPoints().size();
            for (int i = 0; i < ap; ++i) {
                resource.normalize(i);
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("In GetTableDetails->: Error in normalization process" + e.getMessage()));
            throw e;
        }
    }
}

