/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.algorithms.drmalgorithms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataaccess.databases.access.DatabasesDiscoverer;
import org.gcube.dataaccess.databases.resources.DBResource;
import org.gcube.dataaccess.databases.utils.DatabaseManagement;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalInfraAlgorithm;
import org.gcube.resources.discovery.client.api.DiscoveryException;
import org.gcube.resources.discovery.client.api.InvalidResultException;
import org.hibernate.HibernateException;

public class ListSchemas
extends StandardLocalInfraAlgorithm {
    private static final String SCHEMA_NAME = "Schema Name ";
    private LinkedHashMap<String, StatisticalType> map = new LinkedHashMap();
    private DatabaseManagement mgt;
    private String resourceName = null;
    private String databaseName = null;

    public void init() throws Exception {
        this.mgt = new DatabaseManagement(this.config.getConfigPath());
        AnalysisLogger.getLogger().debug((Object)"In ListSchemas->Initialization");
        String scope = this.config.getGcubeScope();
        AnalysisLogger.getLogger().debug((Object)("In ListSchemas->scope set by config object: " + scope));
    }

    public String getDescription() {
        return "Algorithm that allows to view the schema names of a chosen database for which the type is Postgres";
    }

    protected void process() throws Exception, IOException, IllegalStateException, DiscoveryException, InvalidResultException, HibernateException {
        AnalysisLogger.getLogger().debug((Object)"In ListSchemas->Processing");
        try {
            List<String> Info = this.retrieveInfo();
            this.getConnection(Info);
            List<Object> listSchemas = new ArrayList();
            listSchemas = this.getSchemas();
            if (listSchemas.size() == 0) {
                AnalysisLogger.getLogger().debug((Object)"In ListSchemas->Warning: no schema available");
            }
            for (int i = 0; i < listSchemas.size(); ++i) {
                String schemaId = SCHEMA_NAME + (i + 1);
                PrimitiveType val = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, schemaId, schemaId);
                val.setContent(listSchemas.get(i));
                this.map.put(schemaId, (StatisticalType)val);
            }
        }
        catch (HibernateException h) {
            AnalysisLogger.getLogger().debug((Object)("In ListSchemas-> ERROR " + h.getMessage()));
            throw h;
        }
        catch (IllegalStateException e) {
            AnalysisLogger.getLogger().debug((Object)("In ListSchemas-> ERROR " + e.getMessage()));
            throw e;
        }
        catch (DiscoveryException e1) {
            AnalysisLogger.getLogger().debug((Object)("In ListSchemas-> ERROR " + e1.getMessage()));
            throw e1;
        }
        catch (InvalidResultException e2) {
            AnalysisLogger.getLogger().debug((Object)("In ListSchemas-> ERROR " + e2.getMessage()));
            throw e2;
        }
        catch (IOException e3) {
            AnalysisLogger.getLogger().debug((Object)("In ListSchemas-> Exception " + e3.getMessage()));
            throw e3;
        }
        catch (Exception e4) {
            AnalysisLogger.getLogger().debug((Object)("In ListSchemas-> Exception " + e4.getMessage()));
            throw e4;
        }
        finally {
            this.mgt.closeConnection();
        }
    }

    protected void setInputParameters() {
        this.addStringInput("ResourceName", "The name of the resource", "");
        this.addStringInput("DatabaseName", "The name of the database", "");
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"In ListSchemas->Shutdown");
    }

    public StatisticalType getOutput() {
        AnalysisLogger.getLogger().debug((Object)"In ListSchemas->retrieving outputs");
        PrimitiveType output = new PrimitiveType(LinkedHashMap.class.getName(), this.map, PrimitiveTypes.MAP, "ResultsMap" + UUID.randomUUID(), "Results Map");
        return output;
    }

    private List<String> getSchemas() throws Exception {
        ArrayList<String> listSchemas = new ArrayList();
        listSchemas = this.mgt.getSchemas();
        return listSchemas;
    }

    private List<String> retrieveInfo() throws Exception, IllegalStateException, DiscoveryException, InvalidResultException {
        int i;
        this.resourceName = this.getInputParameter("ResourceName");
        if (this.resourceName != null) {
            this.resourceName = this.getInputParameter("ResourceName").trim();
        }
        if (this.resourceName == null || this.resourceName.equals("")) {
            throw new Exception("Warning: insert the resource name");
        }
        this.databaseName = this.getInputParameter("DatabaseName");
        if (this.databaseName != null) {
            this.databaseName = this.getInputParameter("DatabaseName").trim();
        }
        if (this.databaseName == null || this.databaseName.equals("")) {
            throw new Exception("Warning: insert the database name");
        }
        DatabasesDiscoverer discovery = new DatabasesDiscoverer();
        ArrayList<String> info = new ArrayList<String>();
        List resources = discovery.discover();
        AnalysisLogger.getLogger().debug((Object)("In ListSchemas->number of database resources: " + resources.size()));
        for (i = 0; i < resources.size(); ++i) {
            AnalysisLogger.getLogger().debug((Object)("In ListSchemas->Resource's name: " + ((DBResource)resources.get(i)).getResourceName()));
        }
        block1: for (i = 0; i < resources.size(); ++i) {
            if (!((DBResource)resources.get(i)).getResourceName().toLowerCase().equals(this.resourceName.toLowerCase())) continue;
            this.normalizeDBInfo((DBResource)resources.get(i));
            for (int j = 0; j < ((DBResource)resources.get(i)).getAccessPoints().size(); ++j) {
                if (!((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDatabaseName().toLowerCase().equals(this.databaseName.toLowerCase())) continue;
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getUsername());
                AnalysisLogger.getLogger().debug((Object)("In ListSchemas->username: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getUsername()));
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getPassword());
                AnalysisLogger.getLogger().debug((Object)("In ListSchemas->password: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getPassword()));
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDriver());
                AnalysisLogger.getLogger().debug((Object)("In ListSchemas->driver: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDriver()));
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDialect());
                AnalysisLogger.getLogger().debug((Object)("In ListSchemas->dialect: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDialect()));
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).address());
                AnalysisLogger.getLogger().debug((Object)("In ListSchemas->url: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).address()));
                info.add(this.databaseName);
                AnalysisLogger.getLogger().debug((Object)("In ListSchemas->databasename: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDatabaseName()));
                break block1;
            }
        }
        AnalysisLogger.getLogger().debug((Object)"In ListSchemas->information useful for connection: retrieved");
        return info;
    }

    private void getConnection(List<String> Info) throws IOException {
        Iterator<String> iterator = Info.iterator();
        String DatabaseUserName = iterator.next();
        String DatabasePassword = iterator.next();
        String DatabaseDriver = iterator.next();
        String DatabaseDialect = iterator.next();
        String DatabaseURL = iterator.next();
        String DatabaseName = iterator.next();
        this.mgt.createConnection(DatabaseUserName, DatabasePassword, DatabaseDriver, DatabaseDialect, DatabaseURL, DatabaseName);
    }

    private void normalizeDBInfo(DBResource resource) throws Exception {
        try {
            int ap = resource.getAccessPoints().size();
            for (int i = 0; i < ap; ++i) {
                resource.normalize(i);
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("In ListSchemas->: Error in normalization process" + e.getMessage()));
            throw e;
        }
    }
}

