/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.algorithms.examples;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.contentmanagement.graphtools.plotting.graphs.HistogramGraph;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;

public class AbsoluteSpeciesBarChartsAlgorithm
extends StandardLocalExternalAlgorithm {
    LinkedHashMap<String, StatisticalType> map = new LinkedHashMap();
    static String databaseName = "DatabaseName";
    static String userParameterName = "DatabaseUserName";
    static String passwordParameterName = "DatabasePassword";
    static String urlParameterName = "DatabaseURL";
    protected String fileName;
    BufferedWriter out;
    private String firstSpeciesNumber = " SpeciesNumber :";
    private String yearStart = "Start year :";
    private String yearEnd = "End year :";
    private int speciesNumber;
    String databaseJdbc;
    String year_start;
    String year_end;
    String databaseUser;
    String databasePwd;
    private Connection connection = null;
    private DefaultCategoryDataset defaultcategorydataset;

    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Initialization");
    }

    public String getDescription() {
        return ": A transducer algorithm that produces the list of top n most observed taxa, i.e. the species taxa having the largest number of occurrence records, in the OBIS database in a given time interval";
    }

    public void fulfilParameters() {
        AnalysisLogger.getLogger().debug((Object)"fulfilParameters method");
        List list = this.getInputParameters();
        System.out.println("size: " + list.size());
        for (int i = 0; i < list.size(); ++i) {
            System.out.println(((StatisticalType)list.get(i)).getName() + " " + ((StatisticalType)list.get(i)).getDefaultValue());
            if (((StatisticalType)list.get(i)).getName().equals(this.firstSpeciesNumber)) {
                String tmp = ((StatisticalType)list.get(i)).getDefaultValue();
                this.speciesNumber = Integer.parseInt(tmp);
            }
            if (((StatisticalType)list.get(i)).getName().equals(this.yearStart)) {
                this.year_start = ((StatisticalType)list.get(i)).getDefaultValue();
            }
            if (((StatisticalType)list.get(i)).getName().equals(this.yearEnd)) {
                this.year_end = ((StatisticalType)list.get(i)).getDefaultValue();
            }
            this.databaseJdbc = this.getInputParameter("DatabaseURL");
            this.databaseUser = this.getInputParameter("DatabaseUserName");
            this.databasePwd = this.getInputParameter("DatabasePassword");
        }
        this.fileName = this.config.getConfigPath() + "results.csv";
        AnalysisLogger.getLogger().debug((Object)("Percorso file: " + this.fileName));
        AnalysisLogger.getLogger().debug((Object)"fulfilParameters method");
    }

    private ResultSet performeQuery() throws SQLException {
        this.connection = DriverManager.getConnection(this.databaseJdbc, this.databaseUser, this.databasePwd);
        Statement stmt = this.connection.createStatement();
        String query = "SELECT  tname, sum(count)AS count FROM public.count_species_per_year WHERE year::integer >=" + this.year_start + "AND year::integer <=" + this.year_end + "GROUP BY tname ORDER BY count desc;";
        return stmt.executeQuery(query);
    }

    protected void process() throws Exception {
        System.out.println("In the process");
        this.defaultcategorydataset = new DefaultCategoryDataset();
        System.out.println("pre fulfill");
        this.fulfilParameters();
        System.out.println("post fulfill");
        this.out = new BufferedWriter(new FileWriter(this.fileName));
        System.out.println("pre query");
        ResultSet rs = this.performeQuery();
        System.out.println("post query");
        String s = "Species";
        for (int i = 0; rs.next() && i < this.speciesNumber; ++i) {
            System.out.println(rs.toString());
            String tname = rs.getString("tname");
            String count = rs.getString("count");
            System.out.println("tname:" + tname);
            System.out.println("count:" + count);
            this.write(tname + "," + count);
            int countOcc = Integer.parseInt(count);
            PrimitiveType val = new PrimitiveType(String.class.getName(), (Object)count, PrimitiveTypes.STRING, tname, tname);
            if (i < 100) {
                this.map.put(tname, (StatisticalType)val);
            }
            if (i >= 16) continue;
            this.defaultcategorydataset.addValue((double)countOcc, (Comparable)((Object)s), (Comparable)((Object)tname));
        }
        this.out.close();
        this.connection.close();
    }

    protected void setInputParameters() {
        System.out.println("Sono in SetParameters");
        this.addStringInput(this.firstSpeciesNumber, "Number of species to report (max 17 will be visualized on the chart)", "10");
        this.addStringInput(this.yearStart, "Starting year of the analysis", "1800");
        this.addStringInput(this.yearEnd, "Ending year of the analysis", "2020");
        System.out.println("pre addRemoteDB");
        System.out.println("post addRemoteDB");
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"Shutdown");
    }

    public StatisticalType getOutput() {
        AnalysisLogger.getLogger().debug((Object)"In getOutput");
        PrimitiveType p = new PrimitiveType(Map.class.getName(), (Object)PrimitiveType.stringMap2StatisticalMap((HashMap)this.outputParameters), PrimitiveTypes.MAP, "Discrepancy Analysis", "");
        AnalysisLogger.getLogger().debug((Object)"MapsComparator: Producing Gaussian Distribution for the errors");
        HashMap<String, Image> producedImages = new HashMap<String, Image>();
        JFreeChart chart = HistogramGraph.createStaticChart((Dataset)this.defaultcategorydataset);
        Image image = ImageTools.toImage((BufferedImage)chart.createBufferedImage(680, 420));
        producedImages.put("Species Observations", image);
        PrimitiveType images = new PrimitiveType(HashMap.class.getName(), producedImages, PrimitiveTypes.IMAGES, "ErrorRepresentation", "Graphical representation of the error spread");
        PrimitiveType f = new PrimitiveType(File.class.getName(), (Object)new File(this.fileName), PrimitiveTypes.FILE, "OccFile", "OccFile");
        AnalysisLogger.getLogger().debug((Object)"Bar Charts Species Occurrences Produced");
        this.map.put("File", (StatisticalType)f);
        this.map.put("Result", (StatisticalType)p);
        this.map.put("Images", (StatisticalType)images);
        PrimitiveType output = new PrimitiveType(HashMap.class.getName(), this.map, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return output;
    }

    public void write(String writeSt) {
        try {
            this.out.write(writeSt);
            this.out.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

