/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.databases.resources.processing;

import java.io.IOException;
import java.net.UnknownHostException;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataaccess.databases.resources.DBResource;
import org.gcube.dataaccess.databases.resources.processing.Decider;
import org.gcube.dataaccess.databases.resources.processing.Guesser;

public class Normalizer {
    public static void normalize(DBResource obj, int index) throws IOException {
        AnalysisLogger.getLogger().debug((Object)"In class Normalizer->starting to guess the database's type");
        Guesser guess = new Guesser();
        String db = guess.guessDB(obj, index);
        obj.setDBguessed(db);
        AnalysisLogger.getLogger().debug((Object)"In class Normalizer->starting the normalization process");
        if (obj.getAccessPoints().get(index).address().contains("//") || obj.getAccessPoints().get(index).address().contains("/") || obj.getAccessPoints().get(index).address().contains(":")) {
            AnalysisLogger.getLogger().debug((Object)"In class Normalizer->calling the parsing process of the url");
            Decider.decide(obj, index);
        } else {
            AnalysisLogger.getLogger().debug((Object)"In class Normalizer->starting to manage an indecision");
            if (obj.getAccessPoints().get(index).address().equals(obj.getHostedOn()) && !obj.getHostedOn().equals("")) {
                obj.getAccessPoints().get(index).setUrl("//" + obj.getAccessPoints().get(index).address());
                AnalysisLogger.getLogger().debug((Object)"In class Normalizer->starting the tree decision process using the hostname");
                Decider.decide(obj, index);
            } else {
                if (!obj.getAccessPoints().get(index).address().equals("") && !obj.getAccessPoints().get(index).address().equals(obj.getHostedOn()) && obj.getHostedOn().equals("")) {
                    throw new UnknownHostException("the available information are not sufficient to determine the complete address: please fill the field 'Hosted On'");
                }
                if (!(obj.getAccessPoints().get(index).address().equals("jdbc") || obj.getAccessPoints().get(index).address().toLowerCase().toLowerCase().contains("mysql") || obj.getAccessPoints().get(index).address().toLowerCase().contains("postgres") || obj.getAccessPoints().get(index).address().toLowerCase().contains("postgis") || obj.getAccessPoints().get(index).address().toLowerCase().contains(obj.getPort()) || obj.getAccessPoints().get(index).address().equals(""))) {
                    obj.getAccessPoints().get(index).setUrl("/" + obj.getAccessPoints().get(index).address());
                    AnalysisLogger.getLogger().debug((Object)"In class Normalizer->starting the tree decision process using the database's name");
                    Decider.decide(obj, index);
                } else if (obj.getAccessPoints().get(index).address().toLowerCase().contains("postgres") || obj.getAccessPoints().get(index).address().toLowerCase().contains("postgis") || obj.getAccessPoints().get(index).address().toLowerCase().contains("mysql")) {
                    obj.getAccessPoints().get(index).setUrl("jdbc:" + obj.getAccessPoints().get(index).address() + "://");
                    AnalysisLogger.getLogger().debug((Object)"In class Normalizer->starting the tree decision process using the driver's name");
                    Decider.decide(obj, index);
                }
            }
            if (obj.getAccessPoints().get(index).address().equals("")) {
                AnalysisLogger.getLogger().debug((Object)"In class Normalizer->managing the address null");
                if (!obj.getHostedOn().equals("") && obj.getHostedOn() != null) {
                    AnalysisLogger.getLogger().debug((Object)"In class Normalizer->managing the address null using the hostname");
                    obj.getAccessPoints().get(index).setUrl(obj.getHostedOn());
                    AnalysisLogger.getLogger().debug((Object)"In class Normalizer->recalling the 'normalize' method");
                    Normalizer.normalize(obj, index);
                }
            }
        }
    }
}

