/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.databases.lexer;

import java.util.ArrayList;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;

public class LexicalAnalyzer {
    private ArrayList<String> BlackList = new ArrayList();

    public boolean analyze(String query) throws Exception {
        boolean NotAllowed = false;
        this.BlackList.add("INSERT");
        this.BlackList.add("DELETE");
        this.BlackList.add("UPDATE");
        this.BlackList.add("CREATE");
        this.BlackList.add("ALTER");
        this.BlackList.add("DROP");
        this.BlackList.add("GRANT");
        this.BlackList.add("REVOKE");
        this.BlackList.add("TRUNCATE");
        this.BlackList.add("DO");
        this.BlackList.add("START TRANSACTION");
        this.BlackList.add("COMMIT");
        this.BlackList.add("BEGIN");
        this.BlackList.add("ROLLBACK");
        this.BlackList.add("SET");
        this.BlackList.add("SAVEPOINT");
        this.BlackList.add("RELEASE SAVEPOINT");
        this.BlackList.add("LOCK");
        this.BlackList.add("DECLARE");
        this.BlackList.add("PREPARE");
        this.BlackList.add("FETCH");
        this.BlackList.add("ANALYZE");
        this.BlackList.add("EXECUTE");
        this.BlackList.add("SHOW");
        this.BlackList.add("RESET");
        String queryParsed = null;
        int NumOfBlackList = this.BlackList.size();
        AnalysisLogger.getLogger().debug((Object)("LexicalAnalyzer->blacklist size: " + NumOfBlackList));
        queryParsed = LexicalAnalyzer.parseRegularExpressions(query);
        NotAllowed = this.check(queryParsed);
        AnalysisLogger.getLogger().debug((Object)("LexicalAnalyzer->query not allowed: " + NotAllowed));
        if (NotAllowed) {
            throw new Exception("Only read-only queries are allowed");
        }
        return NotAllowed;
    }

    public boolean check(String query) {
        System.out.println("query: " + query);
        boolean NotAllowed = false;
        int j = 0;
        while (j < this.BlackList.size()) {
            String Keyword = this.BlackList.get(j);
            String regex = ".*\\b" + Keyword.replaceAll(" +", "[ ]\\+") + "\\b.*";
            System.out.println("keyword: " + regex);
            if (query.toUpperCase().matches(regex)) {
                NotAllowed = true;
                break;
            }
            ++j;
        }
        return NotAllowed;
    }

    public ArrayList<String> getBlackList() {
        return this.BlackList;
    }

    private static String parseRegularExpressions(String phrase) {
        phrase = phrase.replaceAll("\n", " ");
        String todelete = "[\\]\\[!#$%&()*+,./:;<=>?@\\^{|}~-]";
        phrase = phrase.replaceAll(todelete, " ");
        phrase = phrase.replaceAll("[ ]+", " ");
        AnalysisLogger.getLogger().debug((Object)("LexicalAnalyzer-> : replacing query " + phrase));
        String apex = "'.*'";
        phrase = phrase.replaceAll(apex, "");
        String apex2 = "\".*\"";
        phrase = phrase.replaceAll(apex2, "");
        String apex3 = "`.*`";
        phrase = phrase.replaceAll(apex3, "");
        AnalysisLogger.getLogger().debug((Object)("LexicalAnalyzer-> : parsed string " + phrase));
        return phrase;
    }
}

