/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.testsuite.test.scan.classification;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.exceptions.ExternalRepositoryException;
import org.gcube.data.spd.plugin.fwk.exceptions.IdNotValidException;
import org.gcube.data.spd.plugin.fwk.exceptions.MethodNotSupportedException;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.testsuite.test.common.ListObjectWriter;

public enum ClassificationMethodCall {
    TAXON_CHILDS("retrieveTaxonChildsByTaxonId"){

        @Override
        public List<TaxonomyItem> call(ClassificationCapability classification, String id) throws IdNotValidException {
            return classification.retrieveTaxonChildsByTaxonId(id);
        }
    }
    ,
    TAXON_BY_ID("retrieveTaxonById"){

        @Override
        public List<TaxonomyItem> call(ClassificationCapability classification, String id) throws IdNotValidException, ExternalRepositoryException {
            TaxonomyItem item = classification.retrieveTaxonById(id);
            return Collections.singletonList(item);
        }
    }
    ,
    TAXON_BY_IDS("retrieveTaxonByIds"){

        @Override
        public List<TaxonomyItem> call(ClassificationCapability classification, String id) throws IdNotValidException, ExternalRepositoryException, MethodNotSupportedException {
            ListObjectWriter writer = new ListObjectWriter();
            Iterator<String> ids = Collections.singletonList(id).iterator();
            classification.retrieveTaxonByIds(ids, writer);
            return writer.getElements();
        }
    };

    protected String methodName;

    private ClassificationMethodCall(String methodName) {
        this.methodName = methodName;
    }

    public abstract List<TaxonomyItem> call(ClassificationCapability var1, String var2) throws IdNotValidException, ExternalRepositoryException, MethodNotSupportedException;

    public String getMethodName() {
        return this.methodName;
    }

    /* synthetic */ ClassificationMethodCall(String string, int n, String string2, ClassificationMethodCall classificationMethodCall) {
        this(string2);
    }
}

