/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.testsuite;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.testsuite.TestSuite;
import org.gcube.data.spd.testsuite.provider.cn.CommonNameProvider;
import org.gcube.data.spd.testsuite.provider.cn.CommonNameSet;
import org.gcube.data.spd.testsuite.provider.sn.ScientificNameProvider;
import org.gcube.data.spd.testsuite.provider.sn.ScientificNameSet;
import org.gcube.data.spd.testsuite.test.NeedsCommonNameProvider;
import org.gcube.data.spd.testsuite.test.NeedsScientificNameProvider;
import org.gcube.data.spd.testsuite.test.Test;
import org.gcube.data.spd.testsuite.test.scan.ScanTest;
import org.gcube.data.spd.testsuite.test.scan.ScanTests;
import org.gcube.data.spd.testsuite.util.ISUtil;
import org.gcube.data.spd.testsuite.util.Verbosity;

public class TestSuiteBuilder {
    public static Verbosity DEFAULT_VERBOSITY = Verbosity.INFO;
    protected static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
    protected static String DEFAULT_LOG_LAYOUT_PATTERN = "[%d] %m%n";
    protected AbstractPlugin plugin;
    protected Verbosity verbosity;
    protected List<Test> tests;
    protected ScientificNameProvider scientificNameProvider;
    protected CommonNameProvider commonNameProvider;
    protected ServiceEndpoint runtimeResource;
    protected List<LogFileConfiguration> logFileConfigurations;

    public static TestSuiteBuilder create(AbstractPlugin plugin) {
        return new TestSuiteBuilder(plugin);
    }

    protected TestSuiteBuilder(AbstractPlugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("The plugin can't be null");
        }
        this.plugin = plugin;
        this.verbosity = DEFAULT_VERBOSITY;
        this.tests = new ArrayList<Test>();
        this.scientificNameProvider = ScientificNameSet.UNIQUE;
        this.commonNameProvider = CommonNameSet.NCBI;
        this.logFileConfigurations = new ArrayList<LogFileConfiguration>();
    }

    public TestSuiteBuilder verbose() {
        this.verbosity = Verbosity.VERBOSE;
        return this;
    }

    public TestSuiteBuilder detailVerbose() {
        this.verbosity = Verbosity.DETAIL;
        return this;
    }

    public TestSuiteBuilder quiet() {
        this.verbosity = Verbosity.NONE;
        return this;
    }

    public TestSuiteBuilder reportToFile() {
        String logFile = "TestLog-" + sdf.format(new Date()) + ".log";
        return this.reportToFile(logFile, DEFAULT_VERBOSITY);
    }

    public TestSuiteBuilder reportToFile(Verbosity verbosity) {
        String logFile = "TestLog-" + sdf.format(new Date()) + ".log";
        return this.reportToFile(logFile, verbosity);
    }

    public TestSuiteBuilder reportToFile(String fileName, Verbosity verbosity) {
        LogFileConfiguration configuration = new LogFileConfiguration(verbosity, fileName);
        this.logFileConfigurations.add(configuration);
        return this;
    }

    public TestSuiteBuilder withScientificNameSet(ScientificNameSet set) {
        this.scientificNameProvider = set;
        return this;
    }

    public TestSuiteBuilder withScientificNameProvider(ScientificNameProvider scientificNameProvider) {
        this.scientificNameProvider = scientificNameProvider;
        return this;
    }

    public TestSuiteBuilder withCommonNameSet(CommonNameSet set) {
        this.commonNameProvider = set;
        return this;
    }

    public TestSuiteBuilder withCommonNameProvider(CommonNameProvider commonNameProvider) {
        this.commonNameProvider = commonNameProvider;
        return this;
    }

    public TestSuiteBuilder runtimeResourceFromIS(GCUBEScope scope) throws Exception {
        this.runtimeResource = ISUtil.retrievePluginRuntimeResource(this.plugin, scope);
        return this;
    }

    public TestSuiteBuilder addScanTest() {
        for (ScanTest scanTest : ScanTests.getCompatibleTests(this.plugin)) {
            this.addScanTest(scanTest);
        }
        return this;
    }

    public TestSuiteBuilder addScanTest(ScanTest scanTest) {
        this.tests.add(scanTest.getTest());
        return this;
    }

    protected void setupTests() {
        for (Test test : this.tests) {
            if (test instanceof NeedsScientificNameProvider) {
                ((NeedsScientificNameProvider)((Object)test)).setScientificNameProvider(this.scientificNameProvider);
            }
            if (!(test instanceof NeedsCommonNameProvider)) continue;
            ((NeedsCommonNameProvider)((Object)test)).setCommonNameProvider(this.commonNameProvider);
        }
    }

    protected void setupLogger() {
        Logger rootLogger = Logger.getLogger((String)"org.gcube.data.spd.testsuite");
        Level rootLevel = this.verbosity == Verbosity.NONE && this.logFileConfigurations.size() == 0 ? Level.OFF : Level.ALL;
        System.out.println("rootLevel " + rootLevel + " " + Level.ALL);
        rootLogger.setLevel(rootLevel);
        if (this.verbosity != Verbosity.NONE) {
            ConsoleAppender consoleAppender = new ConsoleAppender((Layout)new PatternLayout(DEFAULT_LOG_LAYOUT_PATTERN));
            Level consoleLevel = this.getLevel(this.verbosity);
            System.out.println("console level " + consoleLevel + " " + Level.DEBUG);
            consoleAppender.setThreshold((Priority)consoleLevel);
            rootLogger.addAppender((Appender)consoleAppender);
        }
        for (LogFileConfiguration logFileConfiguration : this.logFileConfigurations) {
            if (logFileConfiguration.verbosity == Verbosity.NONE) continue;
            try {
                FileAppender fileAppender = new FileAppender((Layout)new PatternLayout(DEFAULT_LOG_LAYOUT_PATTERN), logFileConfiguration.logFile);
                Level fileLevel = this.getLevel(logFileConfiguration.verbosity);
                fileAppender.setThreshold((Priority)fileLevel);
                rootLogger.addAppender((Appender)fileAppender);
            }
            catch (IOException e) {
                throw new RuntimeException("File Appender creation failed", e);
            }
        }
    }

    protected Level getLevel(Verbosity verbosity) {
        switch (verbosity) {
            case DETAIL: {
                return Level.TRACE;
            }
            case INFO: {
                return Level.INFO;
            }
            case NONE: {
                return Level.OFF;
            }
            case VERBOSE: {
                return Level.DEBUG;
            }
        }
        return Level.ALL;
    }

    public TestSuite build() {
        this.setupTests();
        this.setupLogger();
        if (this.runtimeResource == null) {
            throw new IllegalStateException("No RuntimeResource specified for the plugin");
        }
        return new TestSuite(this.plugin, this.runtimeResource, this.tests);
    }

    protected class LogFileConfiguration {
        protected Verbosity verbosity;
        protected String logFile;

        public LogFileConfiguration(Verbosity verbosity, String logFile) {
            this.verbosity = verbosity;
            this.logFile = logFile;
        }
    }
}

