/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.algorithm.annotation;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;
import org.n52.wps.algorithm.descriptor.BoundDescriptor;
import org.n52.wps.algorithm.descriptor.InputDescriptor;
import org.n52.wps.algorithm.descriptor.OutputDescriptor;
import org.n52.wps.algorithm.util.ClassUtil;
import org.n52.wps.io.data.IData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnnotationBinding<M extends AccessibleObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationBinding.class);
    private M member;
    public final Type NOT_PARAMETERIZED_TYPE = new WildcardType(){

        @Override
        public Type[] getUpperBounds() {
            return new Type[]{Object.class};
        }

        @Override
        public Type[] getLowerBounds() {
            return new Type[0];
        }
    };

    public AnnotationBinding(M member) {
        this.member = member;
    }

    public M getMember() {
        return this.member;
    }

    protected boolean checkModifier() {
        return (((Member)this.getMember()).getModifiers() & 1) != 0;
    }

    public abstract boolean validate();

    public static class OutputMethodBinding<D extends OutputDescriptor>
    extends OutputBinding<Method, D> {
        public OutputMethodBinding(Method method) {
            super(method);
        }

        @Override
        public Type getMemberType() {
            return ((Method)this.getMember()).getGenericReturnType();
        }

        @Override
        public boolean validate() {
            Method method = (Method)this.getMember();
            if (method.getParameterTypes().length != 0) {
                LOGGER.error("Method {} with output annotation can't be used, parameter count != 0", this.getMember());
                return false;
            }
            if (!this.checkModifier()) {
                LOGGER.error("Method {} with output annotation can't be used, not public", this.getMember());
                return false;
            }
            if (!this.checkType()) {
                LOGGER.error("Method {} with output annotation can't be used, unable to safely construct binding using method return type", this.getMember());
                return false;
            }
            return true;
        }

        @Override
        public IData get(Object annotatedInstance) {
            Object value;
            try {
                value = ((Method)this.getMember()).invoke(annotatedInstance, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Internal error processing inputs", ex);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException("Internal error processing inputs", ex);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause() == null ? ex : ex.getCause();
                throw new RuntimeException(cause.getMessage(), cause);
            }
            return value == null ? null : this.bindOutputValue(value);
        }
    }

    public static class OutputFieldBinding<D extends OutputDescriptor>
    extends OutputBinding<Field, D> {
        public OutputFieldBinding(Field field) {
            super(field);
        }

        @Override
        public Type getMemberType() {
            return ((Field)this.getMember()).getGenericType();
        }

        @Override
        public boolean validate() {
            if (!this.checkModifier()) {
                LOGGER.error("Field {} with output annotation can't be used, not public.", this.getMember());
                return false;
            }
            if (!this.checkType()) {
                LOGGER.error("Field {} with output annotation can't be used, unable to safely construct binding using field type", this.getMember());
                return false;
            }
            return true;
        }

        @Override
        public IData get(Object annotatedInstance) {
            Object value;
            try {
                value = ((Field)this.getMember()).get(annotatedInstance);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException("Internal error processing inputs", ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Internal error processing inputs", ex);
            }
            return value == null ? null : this.bindOutputValue(value);
        }
    }

    public static class InputMethodBinding<D extends InputDescriptor>
    extends InputBinding<Method, D> {
        public InputMethodBinding(Method method) {
            super(method);
        }

        @Override
        public Type getMemberType() {
            Type[] genericParameterTypes = ((Method)this.getMember()).getGenericParameterTypes();
            return genericParameterTypes.length == 0 ? Void.class : genericParameterTypes[0];
        }

        @Override
        public boolean validate() {
            if (!this.checkModifier()) {
                LOGGER.error("Field {} with input annotation can't be used, not public.", this.getMember());
                return false;
            }
            if (((InputDescriptor)this.getDescriptor()).getMaxOccurs().intValue() >= 2 && !this.isMemberTypeList()) {
                LOGGER.error("Field {} with input annotation can't be used, maxOccurs > 1 and field is not of type List", this.getMember());
                return false;
            }
            if (!this.checkType()) {
                LOGGER.error("Field {} with input annotation can't be used, unable to safely assign field using binding payload type", this.getMember());
                return false;
            }
            return true;
        }

        @Override
        public void set(Object annotatedObject, List<IData> boundInputList) {
            try {
                ((Method)this.getMember()).invoke(annotatedObject, this.unbindInput(boundInputList));
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Internal error processing inputs", ex);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException("Internal error processing inputs", ex);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause() == null ? ex : ex.getCause();
                throw new RuntimeException(cause.getMessage(), cause);
            }
        }
    }

    public static class InputFieldBinding<D extends InputDescriptor>
    extends InputBinding<Field, D> {
        public InputFieldBinding(Field field) {
            super(field);
        }

        @Override
        public Type getMemberType() {
            return ((Field)this.getMember()).getGenericType();
        }

        @Override
        public boolean validate() {
            if (!this.checkModifier()) {
                LOGGER.error("Field {} with input annotation can't be used, not public.", this.getMember());
                return false;
            }
            if (((InputDescriptor)this.getDescriptor()).getMaxOccurs().intValue() >= 2 && !this.isMemberTypeList()) {
                LOGGER.error("Field {} with input annotation can't be used, maxOccurs > 1 and field is not of type List", this.getMember());
                return false;
            }
            if (!this.checkType()) {
                LOGGER.error("Field {} with input annotation can't be used, unable to safely assign field using binding payload type", this.getMember());
                return false;
            }
            return true;
        }

        @Override
        public void set(Object annotatedObject, List<IData> boundInputList) {
            try {
                ((Field)this.getMember()).set(annotatedObject, this.unbindInput(boundInputList));
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException("Internal error processing inputs", ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Internal error processing inputs", ex);
            }
        }
    }

    public static abstract class OutputBinding<M extends AccessibleObject, D extends OutputDescriptor>
    extends DataBinding<M, D> {
        private Constructor<? extends IData> bindingConstructor;

        public OutputBinding(M member) {
            super(member);
        }

        protected boolean checkType() {
            return this.getConstructor() != null;
        }

        public IData bindOutputValue(Object outputValue) {
            try {
                if (this.isTypeEnum()) {
                    outputValue = ((Enum)outputValue).name();
                }
                return this.getConstructor().newInstance(outputValue);
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("Internal error processing outputs", ex);
            }
            catch (SecurityException ex) {
                throw new RuntimeException("Internal error processing outputs", ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Internal error processing outputs", ex);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause() == null ? ex : ex.getCause();
                throw new RuntimeException(cause.getMessage(), cause);
            }
        }

        public abstract IData get(Object var1);

        private synchronized Constructor<? extends IData> getConstructor() {
            if (this.bindingConstructor == null) {
                try {
                    Class bindingPayloadClass;
                    Object bindingClass = ((OutputDescriptor)this.getDescriptor()).getBinding();
                    Class<?> outputPayloadClass = ((Class)bindingClass).getMethod("getPayload", null).getReturnType();
                    Type bindingPayloadType = this.getPayloadType();
                    if (bindingPayloadType instanceof Class && (bindingPayloadClass = (Class)bindingPayloadType).isAssignableFrom(outputPayloadClass)) {
                        this.bindingConstructor = ((Class)bindingClass).getConstructor(bindingPayloadClass);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return this.bindingConstructor;
        }
    }

    public static abstract class InputBinding<M extends AccessibleObject, D extends InputDescriptor>
    extends DataBinding<M, D> {
        public InputBinding(M member) {
            super(member);
        }

        @Override
        public Type getType() {
            Type memberType;
            Type inputType = memberType = this.getMemberType();
            if (memberType instanceof Class) {
                Class memberClass = (Class)memberType;
                if (List.class.isAssignableFrom(memberClass)) {
                    inputType = this.NOT_PARAMETERIZED_TYPE;
                }
            } else if (memberType instanceof ParameterizedType) {
                ParameterizedType parameterizedMemberType = (ParameterizedType)memberType;
                Class rawClass = (Class)parameterizedMemberType.getRawType();
                if (List.class.isAssignableFrom(rawClass)) {
                    inputType = parameterizedMemberType.getActualTypeArguments()[0];
                }
            } else {
                LOGGER.error("Unable to infer concrete type information for " + this.getMember());
            }
            return inputType;
        }

        public boolean isMemberTypeList() {
            Type memberType = this.getMemberType();
            if (memberType instanceof Class) {
                return List.class.isAssignableFrom((Class)memberType);
            }
            if (memberType instanceof ParameterizedType) {
                Class rawClass = (Class)((ParameterizedType)memberType).getRawType();
                return List.class.isAssignableFrom(rawClass);
            }
            LOGGER.error("Unable to infer concrete type information for " + this.getMember());
            return false;
        }

        protected boolean checkType() {
            Type inputPayloadType = this.getPayloadType();
            Object bindingClass = ((InputDescriptor)this.getDescriptor()).getBinding();
            try {
                Class<?> bindingPayloadClass = ((Class)bindingClass).getMethod("getPayload", null).getReturnType();
                if (inputPayloadType instanceof Class) {
                    return ((Class)inputPayloadType).isAssignableFrom(bindingPayloadClass);
                }
                if (inputPayloadType instanceof ParameterizedType) {
                    return ((Class)((ParameterizedType)inputPayloadType).getRawType()).isAssignableFrom(bindingPayloadClass);
                }
                if (inputPayloadType instanceof WildcardType) {
                    WildcardType inputTypeWildcardType = (WildcardType)inputPayloadType;
                    Type[] lowerBounds = inputTypeWildcardType.getLowerBounds();
                    Type[] upperBounds = inputTypeWildcardType.getUpperBounds();
                    Class lowerBoundClass = null;
                    Class upperBoundClass = null;
                    if (lowerBounds != null && lowerBounds.length > 0) {
                        if (lowerBounds[0] instanceof Class) {
                            lowerBoundClass = (Class)lowerBounds[0];
                        } else if (lowerBounds[0] instanceof ParameterizedType) {
                            lowerBoundClass = (Class)((ParameterizedType)lowerBounds[0]).getRawType();
                        }
                    }
                    if (upperBounds != null && upperBounds.length > 0) {
                        if (upperBounds[0] instanceof Class) {
                            upperBoundClass = (Class)upperBounds[0];
                        } else if (upperBounds[0] instanceof ParameterizedType) {
                            upperBoundClass = (Class)((ParameterizedType)upperBounds[0]).getRawType();
                        }
                    }
                    return !(upperBoundClass != null && !upperBoundClass.isAssignableFrom(bindingPayloadClass) || lowerBounds != null && !bindingPayloadClass.isAssignableFrom(lowerBoundClass));
                }
                LOGGER.error("Unable to infer assignability from type for " + this.getMember());
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            return false;
        }

        public Object unbindInput(List<IData> boundValueList) {
            Object value = null;
            if (boundValueList != null && boundValueList.size() > 0) {
                if (this.isMemberTypeList()) {
                    ArrayList<Object> valueList = new ArrayList<Object>(boundValueList.size());
                    for (IData bound : boundValueList) {
                        value = bound.getPayload();
                        if (this.isTypeEnum()) {
                            value = Enum.valueOf((Class)this.getType(), (String)value);
                        }
                        valueList.add(value);
                    }
                    value = valueList;
                } else if (boundValueList.size() == 1) {
                    value = boundValueList.get(0).getPayload();
                    if (this.isTypeEnum()) {
                        value = Enum.valueOf((Class)this.getType(), (String)value);
                    }
                }
            }
            return value;
        }

        public abstract void set(Object var1, List<IData> var2);
    }

    public static abstract class DataBinding<M extends AccessibleObject, D extends BoundDescriptor>
    extends AnnotationBinding<M> {
        private D descriptor;

        public DataBinding(M member) {
            super(member);
        }

        public void setDescriptor(D descriptor) {
            this.descriptor = descriptor;
        }

        public D getDescriptor() {
            return this.descriptor;
        }

        public abstract Type getMemberType();

        public Type getType() {
            return this.getMemberType();
        }

        public Type getPayloadType() {
            Class inputClass;
            Type type = this.getType();
            if (this.isTypeEnum()) {
                return String.class;
            }
            if (type instanceof Class && (inputClass = (Class)type).isPrimitive()) {
                return ClassUtil.wrap(inputClass);
            }
            return type;
        }

        public boolean isTypeEnum() {
            Type inputType = this.getType();
            return inputType instanceof Class && ((Class)inputType).isEnum();
        }
    }

    public static class ExecuteMethodBinding
    extends AnnotationBinding<Method> {
        public ExecuteMethodBinding(Method method) {
            super(method);
        }

        @Override
        public boolean validate() {
            if (!this.checkModifier()) {
                LOGGER.error("Method {} with Execute annotation can't be used, not public.", this.getMember());
                return false;
            }
            if (!((Method)this.getMember()).getReturnType().equals(Void.TYPE)) {
                LOGGER.error("Method {} with Execute annotation can't be used, return type not void", this.getMember());
                return false;
            }
            if (((Method)this.getMember()).getParameterTypes().length != 0) {
                LOGGER.error("Method {} with Execute annotation can't be used, method parameter count is > 0.", this.getMember());
                return false;
            }
            return true;
        }

        public void execute(Object annotatedInstance) {
            try {
                ((Method)this.getMember()).invoke(annotatedInstance, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Internal error executing process", ex);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException("Internal error executing process", ex);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause() == null ? ex : ex.getCause();
                throw new RuntimeException(cause.getMessage(), cause);
            }
        }
    }
}

