/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.algorithm.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.n52.test.mock.MockEnum;
import org.n52.wps.algorithm.annotation.AnnotationBinding;
import org.n52.wps.algorithm.annotation.AnnotationMemberDescriptorSample;

public class AnnotatedMemberDescriptorTest
extends TestCase {
    public String stringField;
    public List<String> stringListField;
    public List<? extends String> stringExtendListField;
    public List<? super String> stringSuperListField;
    public List unboundListField;
    public MockEnum enumField;
    public List<MockEnum> enumListField;
    Map<String, Method> methodMap = new HashMap<String, Method>();

    public void setString(String stringParameter) {
        this.stringField = stringParameter;
    }

    public String getString() {
        return this.stringField;
    }

    public void setStringList(List<String> stringListParameter) {
        this.stringListField = stringListParameter;
    }

    public List<String> getStringList() {
        return this.stringListField;
    }

    public void setStringExtendList(List<? extends String> stringExtendListParameter) {
        this.stringExtendListField = stringExtendListParameter;
    }

    public List<? extends String> getStringExtendList() {
        return this.stringExtendListField;
    }

    public void setStringSuperList(List<? super String> stringSuperListParameter) {
        this.stringSuperListField = stringSuperListParameter;
    }

    public List<? super String> getStringSuperList() {
        return this.stringSuperListField;
    }

    public void setUnboundList(List unboundListParameter) {
        this.unboundListField = unboundListParameter;
    }

    public List getUnboundList() {
        return this.unboundListField;
    }

    public MockEnum getEnum() {
        return this.enumField;
    }

    public void setEnum(MockEnum enumParameter) {
        this.enumField = enumParameter;
    }

    public List<MockEnum> getEnumList() {
        return this.enumListField;
    }

    public void setEnumList(List<MockEnum> enumListParameter) {
        this.enumListField = enumListParameter;
    }

    public AnnotatedMemberDescriptorTest(String testName) {
        super(testName);
        for (Method method : AnnotationMemberDescriptorSample.class.getDeclaredMethods()) {
            this.methodMap.put(method.getName(), method);
        }
        this.methodMap = Collections.unmodifiableMap(this.methodMap);
    }

    private Method getSampleMethod(String name) throws NoSuchMethodException {
        Method method = this.methodMap.get(name);
        if (method == null) {
            throw new NoSuchMethodException(name);
        }
        return method;
    }

    private Field getSampleField(String name) throws NoSuchFieldException {
        return AnnotationMemberDescriptorSample.class.getDeclaredField(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testStringFieldAsInput() throws NoSuchFieldException {
        Field field = this.getSampleField("stringField");
        AnnotationBinding.InputFieldBinding memberDescriptor = new AnnotationBinding.InputFieldBinding(field);
        AnnotatedMemberDescriptorTest.assertEquals((Object)field, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)field.getGenericType(), (Object)memberDescriptor.getMemberType());
        this.validateInputMember((AnnotationBinding.InputBinding)memberDescriptor);
    }

    public void testStringFieldAsOutput() throws NoSuchFieldException {
        Field field = this.getSampleField("stringField");
        AnnotationBinding.OutputFieldBinding memberDescriptor = new AnnotationBinding.OutputFieldBinding(field);
        AnnotatedMemberDescriptorTest.assertEquals((Object)field, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)field.getGenericType(), (Object)memberDescriptor.getMemberType());
        this.validateOutputMember((AnnotationBinding.OutputBinding)memberDescriptor);
    }

    public void testStringSetter() throws NoSuchMethodException {
        Method method = this.getSampleMethod("setString");
        AnnotationBinding.InputMethodBinding memberDescriptor = new AnnotationBinding.InputMethodBinding(method);
        AnnotatedMemberDescriptorTest.assertEquals((Object)method, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)method.getGenericParameterTypes()[0], (Object)memberDescriptor.getMemberType());
        this.validateInputMember((AnnotationBinding.InputBinding)memberDescriptor);
    }

    public void testStringGetter() throws NoSuchMethodException {
        Method method = this.getSampleMethod("getString");
        AnnotationBinding.OutputMethodBinding memberDescriptor = new AnnotationBinding.OutputMethodBinding(method);
        AnnotatedMemberDescriptorTest.assertEquals((Object)method, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)method.getGenericReturnType(), (Object)memberDescriptor.getMemberType());
        this.validateOutputMember((AnnotationBinding.OutputBinding)memberDescriptor);
    }

    private void validateInputMember(AnnotationBinding.InputBinding memberDescriptor) {
        AnnotatedMemberDescriptorTest.assertEquals((Object)memberDescriptor.getMemberType(), (Object)memberDescriptor.getType());
        AnnotatedMemberDescriptorTest.assertEquals((Object)memberDescriptor.getType(), (Object)memberDescriptor.getPayloadType());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)false, (boolean)memberDescriptor.isMemberTypeList());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)false, (boolean)memberDescriptor.isTypeEnum());
    }

    private void validateOutputMember(AnnotationBinding.OutputBinding memberDescriptor) {
        AnnotatedMemberDescriptorTest.assertEquals((Object)memberDescriptor.getMemberType(), (Object)memberDescriptor.getType());
        AnnotatedMemberDescriptorTest.assertEquals((Object)memberDescriptor.getType(), (Object)memberDescriptor.getPayloadType());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)false, (boolean)memberDescriptor.isTypeEnum());
    }

    public void testStringListFieldAsInput() throws NoSuchFieldException {
        Field field = this.getSampleField("stringListField");
        AnnotationBinding.InputFieldBinding memberDescriptor = new AnnotationBinding.InputFieldBinding(field);
        AnnotatedMemberDescriptorTest.assertEquals((Object)field, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)field.getGenericType(), (Object)memberDescriptor.getMemberType());
        this.validateInputListMember((AnnotationBinding.InputBinding)memberDescriptor);
    }

    public void testStringListFieldAsOutput() throws NoSuchFieldException {
        Field field = this.getSampleField("stringListField");
        AnnotationBinding.OutputFieldBinding memberDescriptor = new AnnotationBinding.OutputFieldBinding(field);
        AnnotatedMemberDescriptorTest.assertEquals((Object)field, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)field.getGenericType(), (Object)memberDescriptor.getMemberType());
        this.validateOutputListMember((AnnotationBinding.OutputBinding)memberDescriptor);
    }

    public void testStringListSetter() throws NoSuchMethodException {
        Method method = this.getSampleMethod("setStringList");
        AnnotationBinding.InputMethodBinding memberDescriptor = new AnnotationBinding.InputMethodBinding(method);
        AnnotatedMemberDescriptorTest.assertEquals((Object)method, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)method.getGenericParameterTypes()[0], (Object)memberDescriptor.getMemberType());
        this.validateInputListMember((AnnotationBinding.InputBinding)memberDescriptor);
    }

    public void testStringListGetter() throws NoSuchMethodException {
        Method method = this.getSampleMethod("getStringList");
        AnnotationBinding.OutputMethodBinding memberDescriptor = new AnnotationBinding.OutputMethodBinding(method);
        AnnotatedMemberDescriptorTest.assertEquals((Object)method, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)method.getGenericReturnType(), (Object)memberDescriptor.getMemberType());
        this.validateOutputListMember((AnnotationBinding.OutputBinding)memberDescriptor);
    }

    private void validateInputListMember(AnnotationBinding.InputBinding memberDescriptor) {
        AnnotatedMemberDescriptorTest.assertEquals(String.class, (Object)memberDescriptor.getType());
        AnnotatedMemberDescriptorTest.assertEquals((Object)memberDescriptor.getType(), (Object)memberDescriptor.getPayloadType());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)true, (boolean)memberDescriptor.isMemberTypeList());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)false, (boolean)memberDescriptor.isTypeEnum());
    }

    private void validateOutputListMember(AnnotationBinding.OutputBinding memberDescriptor) {
        AnnotatedMemberDescriptorTest.assertEquals((Object)memberDescriptor.getMemberType(), (Object)memberDescriptor.getType());
        AnnotatedMemberDescriptorTest.assertEquals((Object)memberDescriptor.getMemberType(), (Object)memberDescriptor.getPayloadType());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)false, (boolean)memberDescriptor.isTypeEnum());
    }

    public void testStringExtendListFieldAsInput() throws NoSuchFieldException {
        Field field = this.getSampleField("stringExtendListField");
        AnnotationBinding.InputFieldBinding memberDescriptor = new AnnotationBinding.InputFieldBinding(field);
        AnnotatedMemberDescriptorTest.assertEquals((Object)field, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)field.getGenericType(), (Object)memberDescriptor.getMemberType());
        this.validateExtendListInputMember((AnnotationBinding.InputBinding)memberDescriptor);
    }

    public void testStringExtendListFieldAsOutput() throws NoSuchFieldException {
        Field field = this.getSampleField("stringExtendListField");
        AnnotationBinding.OutputFieldBinding memberDescriptor = new AnnotationBinding.OutputFieldBinding(field);
        AnnotatedMemberDescriptorTest.assertEquals((Object)field, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)field.getGenericType(), (Object)memberDescriptor.getMemberType());
        this.validateExtendListOutputMember((AnnotationBinding.OutputBinding)memberDescriptor);
    }

    public void testStringExtendListSetter() throws NoSuchMethodException {
        Method method = this.getSampleMethod("setStringExtendList");
        AnnotationBinding.InputMethodBinding memberDescriptor = new AnnotationBinding.InputMethodBinding(method);
        AnnotatedMemberDescriptorTest.assertEquals((Object)method, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)method.getGenericParameterTypes()[0], (Object)memberDescriptor.getMemberType());
        this.validateExtendListInputMember((AnnotationBinding.InputBinding)memberDescriptor);
    }

    public void testStringExtendListGetter() throws NoSuchMethodException {
        Method method = this.getSampleMethod("getStringExtendList");
        AnnotationBinding.OutputMethodBinding memberDescriptor = new AnnotationBinding.OutputMethodBinding(method);
        AnnotatedMemberDescriptorTest.assertEquals((Object)method, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)method.getGenericReturnType(), (Object)memberDescriptor.getMemberType());
        this.validateExtendListOutputMember((AnnotationBinding.OutputBinding)memberDescriptor);
    }

    private void validateExtendListInputMember(AnnotationBinding.InputBinding memberDescriptor) {
        Type type = memberDescriptor.getType();
        AnnotatedMemberDescriptorTest.assertTrue((boolean)(type instanceof WildcardType));
        WildcardType typeWildcard = (WildcardType)type;
        AnnotatedMemberDescriptorTest.assertEquals((int)0, (int)typeWildcard.getLowerBounds().length);
        AnnotatedMemberDescriptorTest.assertEquals((int)1, (int)typeWildcard.getUpperBounds().length);
        AnnotatedMemberDescriptorTest.assertEquals(String.class, (Object)typeWildcard.getUpperBounds()[0]);
        AnnotatedMemberDescriptorTest.assertEquals((Object)memberDescriptor.getType(), (Object)memberDescriptor.getPayloadType());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)true, (boolean)memberDescriptor.isMemberTypeList());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)false, (boolean)memberDescriptor.isTypeEnum());
    }

    private void validateExtendListOutputMember(AnnotationBinding.OutputBinding memberDescriptor) {
        AnnotatedMemberDescriptorTest.assertEquals((Object)memberDescriptor.getMemberType(), (Object)memberDescriptor.getType());
        AnnotatedMemberDescriptorTest.assertEquals((Object)memberDescriptor.getMemberType(), (Object)memberDescriptor.getPayloadType());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)false, (boolean)memberDescriptor.isTypeEnum());
    }

    public void testStringSuperListFieldAsInput() throws NoSuchFieldException {
        Field field = this.getSampleField("stringSuperListField");
        AnnotationBinding.InputFieldBinding memberDescriptor = new AnnotationBinding.InputFieldBinding(field);
        AnnotatedMemberDescriptorTest.assertEquals((Object)field, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)field.getGenericType(), (Object)memberDescriptor.getMemberType());
        this.validateSuperListInputMember((AnnotationBinding.InputBinding)memberDescriptor);
    }

    public void testStringSuperListFieldAsOutput() throws NoSuchFieldException {
        Field field = this.getSampleField("stringSuperListField");
        AnnotationBinding.OutputFieldBinding memberDescriptor = new AnnotationBinding.OutputFieldBinding(field);
        AnnotatedMemberDescriptorTest.assertEquals((Object)field, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)field.getGenericType(), (Object)memberDescriptor.getMemberType());
        this.validateSuperListOutputMember((AnnotationBinding.OutputBinding)memberDescriptor);
    }

    public void testStringSuperListSetter() throws NoSuchMethodException {
        Method method = this.getSampleMethod("setStringSuperList");
        AnnotationBinding.InputMethodBinding memberDescriptor = new AnnotationBinding.InputMethodBinding(method);
        AnnotatedMemberDescriptorTest.assertEquals((Object)method, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)method.getGenericParameterTypes()[0], (Object)memberDescriptor.getMemberType());
        this.validateSuperListInputMember((AnnotationBinding.InputBinding)memberDescriptor);
    }

    public void testStringSuperListGetter() throws NoSuchMethodException {
        Method method = this.getSampleMethod("getStringSuperList");
        AnnotationBinding.OutputMethodBinding memberDescriptor = new AnnotationBinding.OutputMethodBinding(method);
        AnnotatedMemberDescriptorTest.assertEquals((Object)method, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)method.getGenericReturnType(), (Object)memberDescriptor.getMemberType());
        this.validateSuperListOutputMember((AnnotationBinding.OutputBinding)memberDescriptor);
    }

    private void validateSuperListInputMember(AnnotationBinding.InputBinding memberDescriptor) {
        Type type = memberDescriptor.getType();
        AnnotatedMemberDescriptorTest.assertTrue((boolean)(type instanceof WildcardType));
        WildcardType typeWildcard = (WildcardType)type;
        AnnotatedMemberDescriptorTest.assertEquals((int)1, (int)typeWildcard.getLowerBounds().length);
        AnnotatedMemberDescriptorTest.assertEquals(String.class, (Object)typeWildcard.getLowerBounds()[0]);
        AnnotatedMemberDescriptorTest.assertEquals((int)1, (int)typeWildcard.getUpperBounds().length);
        AnnotatedMemberDescriptorTest.assertEquals(Object.class, (Object)typeWildcard.getUpperBounds()[0]);
        AnnotatedMemberDescriptorTest.assertEquals((Object)memberDescriptor.getType(), (Object)memberDescriptor.getPayloadType());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)true, (boolean)memberDescriptor.isMemberTypeList());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)false, (boolean)memberDescriptor.isTypeEnum());
    }

    private void validateSuperListOutputMember(AnnotationBinding.OutputBinding memberDescriptor) {
        AnnotatedMemberDescriptorTest.assertEquals((Object)memberDescriptor.getMemberType(), (Object)memberDescriptor.getType());
        AnnotatedMemberDescriptorTest.assertEquals((Object)memberDescriptor.getMemberType(), (Object)memberDescriptor.getPayloadType());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)false, (boolean)memberDescriptor.isTypeEnum());
    }

    public void testUnboundListFieldAsInput() throws NoSuchFieldException {
        Field field = this.getSampleField("unboundListField");
        AnnotationBinding.InputFieldBinding memberDescriptor = new AnnotationBinding.InputFieldBinding(field);
        AnnotatedMemberDescriptorTest.assertEquals((Object)field, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)field.getGenericType(), (Object)memberDescriptor.getMemberType());
        this.validateUnboundListInputMember((AnnotationBinding.InputBinding)memberDescriptor);
    }

    public void testUnboundListFieldAsOutput() throws NoSuchFieldException {
        Field field = this.getSampleField("unboundListField");
        AnnotationBinding.OutputFieldBinding memberDescriptor = new AnnotationBinding.OutputFieldBinding(field);
        AnnotatedMemberDescriptorTest.assertEquals((Object)field, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)field.getGenericType(), (Object)memberDescriptor.getMemberType());
        this.validateUnboundListOutputMember((AnnotationBinding.OutputBinding)memberDescriptor);
    }

    public void testUnboundListSetter() throws NoSuchMethodException {
        Method method = this.getSampleMethod("setUnboundList");
        AnnotationBinding.InputMethodBinding memberDescriptor = new AnnotationBinding.InputMethodBinding(method);
        AnnotatedMemberDescriptorTest.assertEquals((Object)method, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)method.getGenericParameterTypes()[0], (Object)memberDescriptor.getMemberType());
        this.validateUnboundListInputMember((AnnotationBinding.InputBinding)memberDescriptor);
    }

    public void testUnboundListGetter() throws NoSuchMethodException {
        Method method = this.getSampleMethod("getUnboundList");
        AnnotationBinding.OutputMethodBinding memberDescriptor = new AnnotationBinding.OutputMethodBinding(method);
        AnnotatedMemberDescriptorTest.assertEquals((Object)method, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)method.getGenericReturnType(), (Object)memberDescriptor.getMemberType());
        this.validateUnboundListOutputMember((AnnotationBinding.OutputBinding)memberDescriptor);
    }

    private void validateUnboundListInputMember(AnnotationBinding.InputBinding memberDescriptor) {
        Type type = memberDescriptor.getType();
        AnnotatedMemberDescriptorTest.assertTrue((boolean)(type instanceof WildcardType));
        WildcardType typeWildcard = (WildcardType)type;
        AnnotatedMemberDescriptorTest.assertEquals((int)0, (int)typeWildcard.getLowerBounds().length);
        AnnotatedMemberDescriptorTest.assertEquals((int)1, (int)typeWildcard.getUpperBounds().length);
        AnnotatedMemberDescriptorTest.assertEquals(Object.class, (Object)typeWildcard.getUpperBounds()[0]);
        AnnotatedMemberDescriptorTest.assertEquals((Object)memberDescriptor.getType(), (Object)memberDescriptor.getPayloadType());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)true, (boolean)memberDescriptor.isMemberTypeList());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)false, (boolean)memberDescriptor.isTypeEnum());
    }

    private void validateUnboundListOutputMember(AnnotationBinding.OutputBinding memberDescriptor) {
        AnnotatedMemberDescriptorTest.assertEquals((Object)memberDescriptor.getMemberType(), (Object)memberDescriptor.getType());
        AnnotatedMemberDescriptorTest.assertEquals((Object)memberDescriptor.getMemberType(), (Object)memberDescriptor.getPayloadType());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)false, (boolean)memberDescriptor.isTypeEnum());
    }

    public void testEnumFieldAsInput() throws NoSuchFieldException {
        Field field = this.getSampleField("enumField");
        AnnotationBinding.InputFieldBinding memberDescriptor = new AnnotationBinding.InputFieldBinding(field);
        AnnotatedMemberDescriptorTest.assertEquals((Object)field, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)field.getGenericType(), (Object)memberDescriptor.getMemberType());
        this.validateEnumInputMember((AnnotationBinding.InputBinding)memberDescriptor);
    }

    public void testEnumFieldAsOutput() throws NoSuchFieldException {
        Field field = this.getSampleField("enumField");
        AnnotationBinding.OutputFieldBinding memberDescriptor = new AnnotationBinding.OutputFieldBinding(field);
        AnnotatedMemberDescriptorTest.assertEquals((Object)field, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)field.getGenericType(), (Object)memberDescriptor.getMemberType());
        this.validateEnumOutputMember((AnnotationBinding.OutputBinding)memberDescriptor);
    }

    public void testEnumSetter() throws NoSuchMethodException {
        Method method = this.getSampleMethod("setEnum");
        AnnotationBinding.InputMethodBinding memberDescriptor = new AnnotationBinding.InputMethodBinding(method);
        AnnotatedMemberDescriptorTest.assertEquals((Object)method, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)method.getGenericParameterTypes()[0], (Object)memberDescriptor.getMemberType());
        this.validateEnumInputMember((AnnotationBinding.InputBinding)memberDescriptor);
    }

    public void testEnumGetter() throws NoSuchMethodException {
        Method method = this.getSampleMethod("getEnum");
        AnnotationBinding.OutputMethodBinding memberDescriptor = new AnnotationBinding.OutputMethodBinding(method);
        AnnotatedMemberDescriptorTest.assertEquals((Object)method, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)method.getGenericReturnType(), (Object)memberDescriptor.getMemberType());
        this.validateEnumOutputMember((AnnotationBinding.OutputBinding)memberDescriptor);
    }

    private void validateEnumInputMember(AnnotationBinding.InputBinding memberDescriptor) {
        AnnotatedMemberDescriptorTest.assertEquals(MockEnum.class, (Object)memberDescriptor.getType());
        AnnotatedMemberDescriptorTest.assertEquals(String.class, (Object)memberDescriptor.getPayloadType());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)false, (boolean)memberDescriptor.isMemberTypeList());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)true, (boolean)memberDescriptor.isTypeEnum());
    }

    private void validateEnumOutputMember(AnnotationBinding.OutputBinding memberDescriptor) {
        AnnotatedMemberDescriptorTest.assertEquals(MockEnum.class, (Object)memberDescriptor.getType());
        AnnotatedMemberDescriptorTest.assertEquals(String.class, (Object)memberDescriptor.getPayloadType());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)true, (boolean)memberDescriptor.isTypeEnum());
    }

    public void testEnumListFieldAsInput() throws NoSuchFieldException {
        Field field = this.getSampleField("enumListField");
        AnnotationBinding.InputFieldBinding memberDescriptor = new AnnotationBinding.InputFieldBinding(field);
        AnnotatedMemberDescriptorTest.assertEquals((Object)field, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)field.getGenericType(), (Object)memberDescriptor.getMemberType());
        this.validateEnumListInputMember((AnnotationBinding.InputBinding)memberDescriptor);
    }

    public void testEnumListFieldAsOutput() throws NoSuchFieldException {
        Field field = this.getSampleField("enumListField");
        AnnotationBinding.OutputFieldBinding memberDescriptor = new AnnotationBinding.OutputFieldBinding(field);
        AnnotatedMemberDescriptorTest.assertEquals((Object)field, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)field.getGenericType(), (Object)memberDescriptor.getMemberType());
        this.validateEnumListOutputMember((AnnotationBinding.OutputBinding)memberDescriptor);
    }

    public void testEnumListSetter() throws NoSuchFieldException, NoSuchMethodException {
        Method method = this.getSampleMethod("setEnumList");
        AnnotationBinding.InputMethodBinding memberDescriptor = new AnnotationBinding.InputMethodBinding(method);
        AnnotatedMemberDescriptorTest.assertEquals((Object)method, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)method.getGenericParameterTypes()[0], (Object)memberDescriptor.getMemberType());
        this.validateEnumListInputMember((AnnotationBinding.InputBinding)memberDescriptor);
    }

    public void testEnumListGetter() throws NoSuchFieldException, NoSuchMethodException {
        Method method = this.getSampleMethod("getEnumList");
        AnnotationBinding.OutputMethodBinding memberDescriptor = new AnnotationBinding.OutputMethodBinding(method);
        AnnotatedMemberDescriptorTest.assertEquals((Object)method, (Object)memberDescriptor.getMember());
        AnnotatedMemberDescriptorTest.assertEquals((Object)method.getGenericReturnType(), (Object)memberDescriptor.getMemberType());
        this.validateEnumListOutputMember((AnnotationBinding.OutputBinding)memberDescriptor);
    }

    private void validateEnumListInputMember(AnnotationBinding.InputBinding memberDescriptor) {
        AnnotatedMemberDescriptorTest.assertEquals(MockEnum.class, (Object)memberDescriptor.getType());
        AnnotatedMemberDescriptorTest.assertEquals(String.class, (Object)memberDescriptor.getPayloadType());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)true, (boolean)memberDescriptor.isMemberTypeList());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)true, (boolean)memberDescriptor.isTypeEnum());
    }

    private void validateEnumListOutputMember(AnnotationBinding.OutputBinding memberDescriptor) {
        AnnotatedMemberDescriptorTest.assertEquals((Object)memberDescriptor.getMemberType(), (Object)memberDescriptor.getType());
        AnnotatedMemberDescriptorTest.assertEquals((Object)memberDescriptor.getMemberType(), (Object)memberDescriptor.getPayloadType());
        AnnotatedMemberDescriptorTest.assertEquals((boolean)false, (boolean)memberDescriptor.isTypeEnum());
    }
}

