/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.algorithm.descriptor;

import java.util.List;
import junit.framework.TestCase;
import org.n52.wps.algorithm.descriptor.LiteralDataInputDescriptor;
import org.n52.wps.algorithm.util.ClassUtil;
import org.n52.wps.io.data.binding.literal.LiteralAnyURIBinding;
import org.n52.wps.io.data.binding.literal.LiteralBooleanBinding;
import org.n52.wps.io.data.binding.literal.LiteralByteBinding;
import org.n52.wps.io.data.binding.literal.LiteralDateTimeBinding;
import org.n52.wps.io.data.binding.literal.LiteralDoubleBinding;
import org.n52.wps.io.data.binding.literal.LiteralFloatBinding;
import org.n52.wps.io.data.binding.literal.LiteralIntBinding;
import org.n52.wps.io.data.binding.literal.LiteralLongBinding;
import org.n52.wps.io.data.binding.literal.LiteralShortBinding;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;

public class LiteralDataInputDescriptorTest
extends TestCase {
    public static final String MOCK_UNALLOWED = "MOCK_UNALLOWED";

    public LiteralDataInputDescriptorTest(String testName) {
        super(testName);
    }

    public void testDefaultValue() {
        LiteralDataInputDescriptor descriptor = null;
        descriptor = LiteralDataInputDescriptor.builder((String)"mock_identifier", LiteralStringBinding.class).build();
        LiteralDataInputDescriptorTest.assertNull((Object)descriptor.getDefaultValue());
        LiteralDataInputDescriptorTest.assertFalse((boolean)descriptor.hasDefaultValue());
        descriptor = LiteralDataInputDescriptor.builder((String)"mock_identifier", LiteralStringBinding.class).defaultValue("").build();
        LiteralDataInputDescriptorTest.assertEquals((String)"", (String)descriptor.getDefaultValue());
        LiteralDataInputDescriptorTest.assertFalse((boolean)descriptor.hasDefaultValue());
        descriptor = LiteralDataInputDescriptor.builder((String)"mock_identifier", LiteralStringBinding.class).defaultValue("mock_default").build();
        LiteralDataInputDescriptorTest.assertEquals((String)"mock_default", (String)descriptor.getDefaultValue());
        LiteralDataInputDescriptorTest.assertTrue((boolean)descriptor.hasDefaultValue());
    }

    public void testAllowedValues() {
        LiteralDataInputDescriptor descriptor = null;
        descriptor = LiteralDataInputDescriptor.builder((String)"mock_identifier", LiteralStringBinding.class).build();
        LiteralDataInputDescriptorTest.assertNotNull((Object)descriptor.getAllowedValues());
        LiteralDataInputDescriptorTest.assertEquals((int)0, (int)descriptor.getAllowedValues().size());
        LiteralDataInputDescriptorTest.assertFalse((boolean)descriptor.hasAllowedValues());
        descriptor = LiteralDataInputDescriptor.builder((String)"mock_identifier", LiteralStringBinding.class).allowedValues(ClassUtil.convertEnumToStringArray(MOCK_ALLOWED_VALUES.class)).build();
        this.validateAllowValues(descriptor);
        descriptor = LiteralDataInputDescriptor.builder((String)"mock_identifier", LiteralStringBinding.class).allowedValues(ClassUtil.convertEnumToStringList(MOCK_ALLOWED_VALUES.class)).build();
        this.validateAllowValues(descriptor);
        descriptor = LiteralDataInputDescriptor.builder((String)"mock_identifier", LiteralStringBinding.class).allowedValues(MOCK_ALLOWED_VALUES.class).build();
        this.validateAllowValues(descriptor);
        descriptor = LiteralDataInputDescriptor.builder((String)"mock_identifier", LiteralStringBinding.class).defaultValue(MOCK_ALLOWED_VALUES.MOCK_ALLOWED1.name()).allowedValues(MOCK_ALLOWED_VALUES.class).build();
        this.validateAllowValues(descriptor);
        boolean thrown = false;
        try {
            LiteralDataInputDescriptor.builder((String)"mock_identifier", LiteralStringBinding.class).defaultValue(MOCK_UNALLOWED).allowedValues(MOCK_ALLOWED_VALUES.class).build();
            LiteralDataInputDescriptorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException e) {
            thrown = true;
        }
        LiteralDataInputDescriptorTest.assertTrue((boolean)thrown);
    }

    public void testBuilder() {
        LiteralDataInputDescriptor descriptor = LiteralDataInputDescriptor.builder((String)"mock_identifier", LiteralStringBinding.class).build();
        LiteralDataInputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataInputDescriptorTest.assertEquals(LiteralStringBinding.class, (Object)descriptor.getBinding());
        boolean thrown = false;
        try {
            LiteralDataInputDescriptor.builder(null, LiteralStringBinding.class);
            LiteralDataInputDescriptorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        LiteralDataInputDescriptorTest.assertTrue((boolean)thrown);
        thrown = false;
        try {
            LiteralDataInputDescriptor.builder((String)"", LiteralStringBinding.class);
            LiteralDataInputDescriptorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        LiteralDataInputDescriptorTest.assertTrue((boolean)thrown);
        thrown = false;
        try {
            LiteralDataInputDescriptor.builder((String)"mock_identifier", null);
            LiteralDataInputDescriptorTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        LiteralDataInputDescriptorTest.assertTrue((boolean)thrown);
    }

    public void testAnyURIBuilder() {
        LiteralDataInputDescriptor descriptor = LiteralDataInputDescriptor.anyURIBuilder((String)"mock_identifier").build();
        LiteralDataInputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataInputDescriptorTest.assertEquals(LiteralAnyURIBinding.class, (Object)descriptor.getBinding());
        LiteralDataInputDescriptorTest.assertEquals((String)"xs:anyURI", (String)descriptor.getDataType());
    }

    public void testBase64BinaryBuilder() {
        LiteralDataInputDescriptor descriptor = LiteralDataInputDescriptor.anyURIBuilder((String)"mock_identifier").build();
        LiteralDataInputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataInputDescriptorTest.assertEquals(LiteralAnyURIBinding.class, (Object)descriptor.getBinding());
        LiteralDataInputDescriptorTest.assertEquals((String)"xs:anyURI", (String)descriptor.getDataType());
    }

    public void testBooleanBuilder() {
        LiteralDataInputDescriptor descriptor = LiteralDataInputDescriptor.booleanBuilder((String)"mock_identifier").build();
        LiteralDataInputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataInputDescriptorTest.assertEquals(LiteralBooleanBinding.class, (Object)descriptor.getBinding());
        LiteralDataInputDescriptorTest.assertEquals((String)"xs:boolean", (String)descriptor.getDataType());
    }

    public void testByteBuilder() {
        LiteralDataInputDescriptor descriptor = LiteralDataInputDescriptor.byteBuilder((String)"mock_identifier").build();
        LiteralDataInputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataInputDescriptorTest.assertEquals(LiteralByteBinding.class, (Object)descriptor.getBinding());
        LiteralDataInputDescriptorTest.assertEquals((String)"xs:byte", (String)descriptor.getDataType());
    }

    public void testDateTimeBuilder() {
        LiteralDataInputDescriptor descriptor = LiteralDataInputDescriptor.dateTimeBuilder((String)"mock_identifier").build();
        LiteralDataInputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataInputDescriptorTest.assertEquals(LiteralDateTimeBinding.class, (Object)descriptor.getBinding());
        LiteralDataInputDescriptorTest.assertEquals((String)"xs:dateTime", (String)descriptor.getDataType());
    }

    public void testDoubleBuilder() {
        LiteralDataInputDescriptor descriptor = LiteralDataInputDescriptor.doubleBuilder((String)"mock_identifier").build();
        LiteralDataInputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataInputDescriptorTest.assertEquals(LiteralDoubleBinding.class, (Object)descriptor.getBinding());
        LiteralDataInputDescriptorTest.assertEquals((String)"xs:double", (String)descriptor.getDataType());
    }

    public void testFloatBuilder() {
        LiteralDataInputDescriptor descriptor = LiteralDataInputDescriptor.floatBuilder((String)"mock_identifier").build();
        LiteralDataInputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataInputDescriptorTest.assertEquals(LiteralFloatBinding.class, (Object)descriptor.getBinding());
        LiteralDataInputDescriptorTest.assertEquals((String)"xs:float", (String)descriptor.getDataType());
    }

    public void testIntBuilder() {
        LiteralDataInputDescriptor descriptor = LiteralDataInputDescriptor.intBuilder((String)"mock_identifier").build();
        LiteralDataInputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataInputDescriptorTest.assertEquals(LiteralIntBinding.class, (Object)descriptor.getBinding());
        LiteralDataInputDescriptorTest.assertEquals((String)"xs:int", (String)descriptor.getDataType());
    }

    public void testLongBuilder() {
        LiteralDataInputDescriptor descriptor = LiteralDataInputDescriptor.longBuilder((String)"mock_identifier").build();
        LiteralDataInputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataInputDescriptorTest.assertEquals(LiteralLongBinding.class, (Object)descriptor.getBinding());
        LiteralDataInputDescriptorTest.assertEquals((String)"xs:long", (String)descriptor.getDataType());
    }

    public void testShortBuilder() {
        LiteralDataInputDescriptor descriptor = LiteralDataInputDescriptor.shortBuilder((String)"mock_identifier").build();
        LiteralDataInputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataInputDescriptorTest.assertEquals(LiteralShortBinding.class, (Object)descriptor.getBinding());
        LiteralDataInputDescriptorTest.assertEquals((String)"xs:short", (String)descriptor.getDataType());
    }

    public void testStringBuilder() {
        LiteralDataInputDescriptor descriptor = LiteralDataInputDescriptor.stringBuilder((String)"mock_identifier").build();
        LiteralDataInputDescriptorTest.assertEquals((String)"mock_identifier", (String)descriptor.getIdentifier());
        LiteralDataInputDescriptorTest.assertEquals(LiteralStringBinding.class, (Object)descriptor.getBinding());
        LiteralDataInputDescriptorTest.assertEquals((String)"xs:string", (String)descriptor.getDataType());
    }

    private void validateAllowValues(LiteralDataInputDescriptor descriptor) {
        LiteralDataInputDescriptorTest.assertTrue((boolean)descriptor.hasAllowedValues());
        List allowedValueList = descriptor.getAllowedValues();
        LiteralDataInputDescriptorTest.assertNotNull((Object)allowedValueList);
        LiteralDataInputDescriptorTest.assertEquals((int)MOCK_ALLOWED_VALUES.values().length, (int)allowedValueList.size());
        for (int index = 0; index < allowedValueList.size(); ++index) {
            LiteralDataInputDescriptorTest.assertNotNull(allowedValueList.get(index));
            LiteralDataInputDescriptorTest.assertEquals((String)MOCK_ALLOWED_VALUES.values()[index].name(), (String)((String)allowedValueList.get(index)));
        }
    }

    public static enum MOCK_ALLOWED_VALUES {
        MOCK_ALLOWED1,
        MOCK_ALLOWED2,
        MOCK_ALLOWED3;

    }
}

