/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.job.management;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.log4j.Logger;
import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.FileTools;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.connectors.livemonitor.ResourceLoad;
import org.gcube.dataanalysis.ecoengine.connectors.livemonitor.Resources;
import org.gcube.dataanalysis.ecoengine.utils.Operations;
import org.gcube.dataanalysis.executor.job.management.QueueJobManager;

public class DistributedProcessingAgent {
    protected QueueJobManager jobManager;
    protected boolean deletefiles = true;
    protected String mainclass;
    protected int maxElementsAllowedPerJob = 20;
    protected boolean forceUpload = true;
    protected boolean stop = false;
    protected String gscope;
    protected String userName;
    protected String pathToLib;
    protected String modelName;
    protected String containerFolder;
    protected Serializable configurationFile;
    protected int rightSetNumberOfElements;
    protected int leftSetNumberOfElements;
    protected List<String> endpoints;
    protected int subdivisiondiv;
    protected static String defaultJobOutput = "execution.output";
    protected static String defaultScriptFile = "script";
    protected Logger logger;
    private long lastTime;
    private int lastProcessed;

    public DistributedProcessingAgent(Serializable configurationFile, String gCubeScope, String computationOwner, String mainClass, String pathToLibFolder, String modelName, String containerFolder, int maxElementsPerJob, boolean forceReUploadofLibs, int leftSetNumberOfElements, int rightSetNumberOfElements) {
        this.gscope = gCubeScope;
        this.mainclass = mainClass;
        this.maxElementsAllowedPerJob = maxElementsPerJob;
        this.forceUpload = forceReUploadofLibs;
        this.configurationFile = configurationFile;
        this.rightSetNumberOfElements = rightSetNumberOfElements;
        this.leftSetNumberOfElements = leftSetNumberOfElements;
        this.userName = computationOwner;
        this.pathToLib = pathToLibFolder;
        this.modelName = modelName;
        this.containerFolder = containerFolder;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setEndPoints(List<String> endpoints) {
        this.endpoints = endpoints;
    }

    public boolean hasResentMessages() {
        return this.jobManager.hasResentMessages();
    }

    public void compute() throws Exception {
        block14: {
            try {
                if (this.logger == null) {
                    this.logger = AnalysisLogger.getLogger();
                }
                if (this.gscope == null) {
                    throw new Exception("Null Scope");
                }
                if (this.endpoints != null) {
                    ArrayList<EndpointReferenceType> eprtList = new ArrayList<EndpointReferenceType>();
                    for (String ep : this.endpoints) {
                        eprtList.add(new EndpointReferenceType(new Address(ep)));
                    }
                    this.jobManager = new QueueJobManager(this.gscope, this.endpoints.size(), eprtList);
                } else {
                    this.jobManager = new QueueJobManager(this.gscope, 1);
                }
                int numberOfResources = this.jobManager.getNumberOfNodes();
                if (numberOfResources > 0) {
                    this.subdivisiondiv = this.rightSetNumberOfElements / (numberOfResources * this.maxElementsAllowedPerJob);
                    int rest = this.rightSetNumberOfElements % (numberOfResources * this.maxElementsAllowedPerJob);
                    if (rest > 0) {
                        ++this.subdivisiondiv;
                    }
                    if (this.subdivisiondiv == 0) {
                        this.subdivisiondiv = 1;
                    }
                    this.executeWork(this.leftSetNumberOfElements, this.rightSetNumberOfElements, 0, this.subdivisiondiv, this.deletefiles, this.forceUpload);
                    if (this.jobManager.wasAborted()) {
                        this.logger.debug((Object)"Warning: Job was aborted");
                        throw new Exception("Job System Error");
                    }
                    break block14;
                }
                this.logger.debug((Object)"Warning: No Workers available");
                throw new Exception("No Workers available");
            }
            catch (Exception e) {
                this.logger.error((Object)"ERROR: An Error occurred ", (Throwable)e);
                e.printStackTrace();
                throw e;
            }
            finally {
                this.shutdown();
            }
        }
    }

    private void executeWork(int leftNum, int rightNum, int offset, int numberOfResources, boolean deletefiles, boolean forceUpload) throws Exception {
        String owner = this.userName;
        int[] chunkSizes = Operations.takeChunks((int)rightNum, (int)numberOfResources);
        ArrayList<String> arguments = new ArrayList<String>();
        for (int i = 0; i < chunkSizes.length; ++i) {
            String argumentString = "0 " + leftNum + " " + offset + " " + chunkSizes[i] + " ./ " + this.mainclass;
            arguments.add(argumentString);
            offset += chunkSizes[i];
            this.logger.debug((Object)("Generator-> Argument " + i + ": " + argumentString));
        }
        if (owner == null) {
            throw new Exception("Null Owner");
        }
        String pathToDir = new File(this.pathToLib, this.containerFolder).getAbsolutePath();
        if (!new File(pathToDir).exists()) {
            throw new Exception("No Implementation of node-model found for algorithm " + pathToDir);
        }
        if (this.mainclass == null) {
            throw new Exception("No mainClass found for algorithm " + pathToDir);
        }
        this.buildScriptFile(this.modelName, defaultJobOutput, pathToDir, this.mainclass);
        this.jobManager.uploadAndExecuteChunkized(AlgorithmConfiguration.StatisticalManagerClass, AlgorithmConfiguration.StatisticalManagerService, owner, pathToDir, "/" + this.modelName + "/", "./", this.getScriptName(this.mainclass), arguments, new XStream().toXML((Object)this.configurationFile), deletefiles, forceUpload);
    }

    private String getScriptName(String fullMainClass) {
        String scriptName = defaultScriptFile + "_" + fullMainClass.substring(fullMainClass.lastIndexOf(".") + 1) + ".sh";
        return scriptName;
    }

    public void buildScriptFile(String jobName, String jobOutput, String jarsPath, String fullMainClass) throws Exception {
        File expectedscript = new File(jarsPath, this.getScriptName(fullMainClass));
        if (!expectedscript.exists()) {
            File[] files;
            StringBuffer sb = new StringBuffer();
            sb.append("#!/bin/sh\n");
            sb.append("# " + jobName + "\n");
            sb.append("cd $1\n");
            sb.append("\n");
            sb.append("java -Xmx1024M -classpath ./:");
            File jarsPathF = new File(jarsPath);
            for (File jar : files = jarsPathF.listFiles()) {
                if (!jar.getName().endsWith(".jar")) continue;
                sb.append("./" + jar.getName());
                sb.append(":");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(" " + fullMainClass + " $2 " + jobOutput);
            sb.append("\n");
            AnalysisLogger.getLogger().trace((Object)("D4ScienceGenerator->Generating script in " + expectedscript.getAbsolutePath()));
            FileTools.saveString((String)expectedscript.getAbsolutePath(), (String)sb.toString(), (boolean)true, (String)"UTF-8");
        }
        AnalysisLogger.getLogger().trace((Object)("D4ScienceGenerator->Script " + expectedscript.getAbsolutePath() + " yet exists!"));
    }

    public String getResources() {
        Resources res = new Resources();
        try {
            int activeNodes = this.jobManager.getActiveNodes();
            for (int i = 0; i < activeNodes; ++i) {
                try {
                    res.addResource("Worker_" + (i + 1), 100.0);
                    continue;
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)"D4ScienceGenerator->active nodes not ready");
        }
        if (res != null && res.list != null) {
            return HttpRequest.toJSon((Object)res.list).replace("resId", "resID");
        }
        return "";
    }

    public float getStatus() {
        try {
            if (this.stop) {
                return 100.0f;
            }
            if (this.jobManager != null) {
                return Math.max(0.5f, this.jobManager.getStatus() * 100.0f);
            }
            return 0.0f;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public ALG_PROPS[] getSupportedAlgorithms() {
        ALG_PROPS[] p = new ALG_PROPS[]{ALG_PROPS.PHENOMENON_VS_PARALLEL_PHENOMENON};
        return p;
    }

    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.D4SCIENCE;
    }

    public void shutdown() {
        try {
            this.jobManager.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stop = true;
    }

    public String getLoad() {
        long tk = System.currentTimeMillis();
        ResourceLoad rs = null;
        rs = this.jobManager != null ? new ResourceLoad(tk, (double)(this.jobManager.currentNumberOfStages * this.subdivisiondiv)) : new ResourceLoad(tk, 0.0);
        return rs.toString();
    }

    public String getResourceLoad() {
        long thisTime = System.currentTimeMillis();
        int processedRecords = 0;
        if (this.jobManager != null && this.subdivisiondiv > 0) {
            processedRecords = this.jobManager.currentNumberOfStages * this.subdivisiondiv;
        }
        int estimatedProcessedRecords = 0;
        estimatedProcessedRecords = processedRecords == this.lastProcessed ? Math.round((float)thisTime * (float)this.lastProcessed / (float)this.lastTime) : (this.lastProcessed = processedRecords);
        this.lastTime = thisTime;
        ResourceLoad rs = new ResourceLoad(thisTime, (double)estimatedProcessedRecords);
        return rs.toString();
    }
}

