/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.job.management;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.executor.job.management.QueueJobManager;
import org.gcube.dataanalysis.executor.messagequeue.Producer;
import org.gcube.dataanalysis.executor.messagequeue.QCONSTANTS;

public class QueueWorkerWatcher {
    protected int maxwaitingTime = QueueJobManager.queueWatcherMaxwaitingTime;
    private long lastTimeClock;
    Timer watcher;
    Producer producer;
    Map<String, Object> message;
    public boolean resent = false;
    int order;

    public QueueWorkerWatcher(Producer producer, Map<String, Object> message, int order) {
        this.producer = producer;
        this.message = message;
        this.resent = false;
        this.order = order;
        this.watcher = new Timer();
        this.watcher.schedule((TimerTask)new Controller(), 0L, (long)QCONSTANTS.refreshStatusTime);
        this.resetTime();
    }

    public synchronized void resetTime() {
        this.lastTimeClock = System.currentTimeMillis();
    }

    public synchronized void destroy() {
        if (this.watcher != null) {
            this.watcher.cancel();
            this.watcher.purge();
            this.watcher = null;
        }
    }

    public boolean hasResent() {
        return this.resent;
    }

    private class Controller
    extends TimerTask {
        private Controller() {
        }

        @Override
        public void run() {
            try {
                long t0 = System.currentTimeMillis();
                AnalysisLogger.getLogger().debug((Object)("Watcher " + QueueWorkerWatcher.this.order + " Timing Is " + (t0 - QueueWorkerWatcher.this.lastTimeClock) + " max waiting time: " + QueueWorkerWatcher.this.maxwaitingTime));
                if (t0 - QueueWorkerWatcher.this.lastTimeClock > (long)QueueWorkerWatcher.this.maxwaitingTime) {
                    AnalysisLogger.getLogger().info((Object)("Watcher " + QueueWorkerWatcher.this.order + " Time Is Over " + (t0 - QueueWorkerWatcher.this.lastTimeClock)));
                    AnalysisLogger.getLogger().info((Object)("Watcher " + QueueWorkerWatcher.this.order + " Re-Sending Message " + QueueWorkerWatcher.this.message));
                    QueueWorkerWatcher.this.producer.sendMessage(QueueWorkerWatcher.this.message, QCONSTANTS.timeToLive);
                    QueueWorkerWatcher.this.resent = true;
                    AnalysisLogger.getLogger().info((Object)("Watcher " + QueueWorkerWatcher.this.order + " Destroying watcher"));
                    QueueWorkerWatcher.this.destroy();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

