/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.nodes.algorithms;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.ActorNode;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.Transformations;
import org.gcube.dataanalysis.executor.generators.D4ScienceDistributedProcessing;
import org.gcube.dataanalysis.executor.job.management.QueueJobManager;
import org.gcube.dataanalysis.executor.scripts.OSCommand;
import org.hibernate.SessionFactory;

public class LWR
extends ActorNode {
    public String destinationTable;
    public String destinationTableLabel;
    public String originTable;
    public String familyColumn;
    public int count;
    public float status = 0.0f;
    public int prevbroadcastTimePeriod;
    public int prevmaxNumberOfStages;
    public int prevmaxMessages;
    private SessionFactory dbconnection;
    private static String createOutputTable = "CREATE TABLE %1$s (Fam character varying(255),   SF character varying(255), BS character varying(255),\t  SpC character varying(255),\t  LWR real,\t  priormeanlog10a real,\t  priorsdlog10a real,\t  priormeanb real,\t\t  priorsdb real,\t\t  note character varying(255)\t\t)";
    private static String columnNames = "Fam,SF,BS,SpC,LWR,priormeanlog10a,priorsdlog10a,priormeanb,priorsdb,note";
    private static String scriptName = "UpdateLWR_4.R";
    boolean haspostprocessed = false;

    public ALG_PROPS[] getProperties() {
        ALG_PROPS[] p = new ALG_PROPS[]{ALG_PROPS.PHENOMENON_VS_PARALLEL_PHENOMENON};
        return p;
    }

    public String getName() {
        return "LWR";
    }

    public String getDescription() {
        return "An algorithm to estimate Length-Weight relationship parameters for marine species, using Bayesian methods. Runs an R procedure. Based on the Cube-law theory.";
    }

    public List<StatisticalType> getInputParameters() {
        ArrayList<TableTemplates> templateLWRInput = new ArrayList<TableTemplates>();
        templateLWRInput.add(TableTemplates.GENERIC);
        InputTable p1 = new InputTable(templateLWRInput, "LWR_Input", "Input table containing taxa and species information", "lwr");
        ColumnType p3 = new ColumnType("LWR_Input", "FamilyColumn", "The column containing Family information", "Family", false);
        ServiceType p4 = new ServiceType(ServiceParameters.RANDOMSTRING, "RealOutputTable", "name of the resulting table", "lwr_");
        PrimitiveType p2 = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, "TableLabel", "Name of the table which will contain the model output", "lwrout");
        ArrayList<StatisticalType> parameters = new ArrayList<StatisticalType>();
        parameters.add((StatisticalType)p1);
        parameters.add((StatisticalType)p3);
        parameters.add((StatisticalType)p2);
        parameters.add((StatisticalType)p4);
        DatabaseType.addDefaultDBPars(parameters);
        return parameters;
    }

    public StatisticalType getOutput() {
        ArrayList<TableTemplates> template = new ArrayList<TableTemplates>();
        template.add(TableTemplates.GENERIC);
        OutputTable p = new OutputTable(template, this.destinationTableLabel, this.destinationTable, "Output lwr table");
        return p;
    }

    public void initSingleNode(AlgorithmConfiguration config) {
    }

    public float getInternalStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeNode(int leftStartIndex, int numberOfLeftElementsToProcess, int rightStartIndex, int numberOfRightElementsToProcess, boolean duplicate, String sandboxFolder, String nodeConfigurationFileObject, String logfileNameToProduce) {
        String insertQuery = null;
        try {
            this.status = 0.0f;
            AlgorithmConfiguration config = Transformations.restoreConfig((String)nodeConfigurationFileObject);
            config.setConfigPath(sandboxFolder);
            System.out.println("Initializing DB");
            this.dbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)config);
            this.destinationTableLabel = config.getParam("TableLabel");
            this.destinationTable = config.getParam("RealOutputTable");
            System.out.println("Destination Table: " + this.destinationTable);
            System.out.println("Destination Table Label: " + this.destinationTableLabel);
            this.originTable = config.getParam("LWR_Input");
            this.familyColumn = config.getParam("FamilyColumn");
            System.out.println("Origin Table: " + this.originTable);
            List families = DatabaseFactory.executeSQLQuery((String)DatabaseUtils.getDinstictElements((String)this.originTable, (String)this.familyColumn, (String)""), (SessionFactory)this.dbconnection);
            StringBuffer familiesFilter = new StringBuffer();
            familiesFilter.append("Families <- Fam.All[");
            int end = rightStartIndex + numberOfRightElementsToProcess;
            for (int i = rightStartIndex; i < end; ++i) {
                familiesFilter.append("Fam.All == \"" + families.get(i) + "\"");
                if (i >= end - 1) continue;
                familiesFilter.append(" | ");
            }
            familiesFilter.append("]");
            OSCommand.ExecuteGetLine("ls", null);
            OSCommand.ExecuteGetLine("pwd", null);
            OSCommand.ExecuteGetLine("chmod +x * | whoami", null);
            String substitutioncommand = "sed -i 's/Families <- Fam.All[Fam.All== \"Acanthuridae\" | Fam.All == \"Achiridae\"]/" + familiesFilter + "/g' " + "UpdateLWR_Test2.R";
            System.out.println("Preparing for processing the families names: " + familiesFilter.toString());
            LWR.substring(sandboxFolder + scriptName, sandboxFolder + "UpdateLWR_Tester.R", "Families <- Fam.All[Fam.All== \"Acanthuridae\" | Fam.All == \"Achiridae\"]", familiesFilter.toString());
            System.out.println("Creating local file from remote table");
            DatabaseUtils.createLocalFileFromRemoteTable((String)(sandboxFolder + "RF_LWR.csv"), (String)this.originTable, (String)",", (String)config.getDatabaseUserName(), (String)config.getDatabasePassword(), (String)config.getDatabaseURL());
            String headers = "Subfamily,Family,Genus,Species,FBname,SpecCode,AutoCtr,Type,a,b,CoeffDetermination,Number,LengthMin,Score,BodyShapeI";
            System.out.println("Adding headers to the file");
            String headerscommand = "sed -i '1s/^/" + headers + "\\n/g' " + "RF_LWR2.csv";
            LWR.addheader(sandboxFolder + "RF_LWR.csv", sandboxFolder + "RF_LWR2.csv", headers);
            System.out.println("Headers added");
            System.out.println("Executing R script R --no-save < UpdateLWR_Tester.R");
            Process process = Runtime.getRuntime().exec("R --no-save");
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
            bw.write("source('UpdateLWR_Tester.R')\n");
            bw.write("q()\n");
            bw.close();
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = br.readLine();
            System.out.println(line);
            while (line != null) {
                line = br.readLine();
                System.out.println(line);
            }
            process.destroy();
            System.out.println("Appending csv to table");
            StringBuffer lines = this.readFromCSV("LWR_Test1.csv");
            insertQuery = DatabaseUtils.insertFromBuffer((String)this.destinationTable, (String)columnNames, (StringBuffer)lines);
            DatabaseFactory.executeSQLUpdate((String)insertQuery, (SessionFactory)this.dbconnection);
            System.out.println("The procedure was successful");
            this.status = 1.0f;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("warning: error in node execution " + e.getLocalizedMessage());
            System.out.println("Insertion Query: " + insertQuery);
            System.err.println("Error in node execution " + e.getLocalizedMessage());
            int n = -1;
            return n;
        }
        finally {
            if (this.dbconnection != null) {
                try {
                    this.dbconnection.close();
                }
                catch (Exception e) {}
            }
        }
        return 0;
    }

    private StringBuffer readFromCSV(String csvfile) throws Exception {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(csvfile));
        String line = br.readLine();
        while (line != null) {
            lines.add(line);
            line = br.readLine();
        }
        br.close();
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int m = lines.size();
        for (int i = 0; i < m; ++i) {
            sb.append(((String)lines.get(i)).replace("\"", "'"));
            if (i >= m - 1) continue;
            sb.append("),(");
        }
        sb.append(")");
        return sb;
    }

    private static void substring(String file, String newFile, String s, String sub) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(new File(file)));
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(newFile)));
        String line = br.readLine();
        while (line != null) {
            int idx = line.indexOf(s);
            if (idx >= 0) {
                line = line.replace(s, sub);
            }
            bw.write(line + "\n");
            line = br.readLine();
        }
        br.close();
        bw.close();
    }

    private static void addheader(String file, String newFile, String header) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(new File(file)));
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(newFile)));
        bw.write(header + "\n");
        String line = br.readLine();
        while (line != null) {
            bw.write(line + "\n");
            line = br.readLine();
        }
        br.close();
        bw.close();
    }

    public void setup(AlgorithmConfiguration config) throws Exception {
        this.destinationTableLabel = config.getParam("TableLabel");
        AnalysisLogger.getLogger().info((Object)("Table Label: " + this.destinationTableLabel));
        this.destinationTable = config.getParam("RealOutputTable");
        AnalysisLogger.getLogger().info((Object)("Uderlying Table Name: " + this.destinationTable));
        this.originTable = config.getParam("LWR_Input");
        AnalysisLogger.getLogger().info((Object)("Original Table: " + this.originTable));
        this.familyColumn = config.getParam("FamilyColumn");
        AnalysisLogger.getLogger().info((Object)("Family Column: " + this.familyColumn));
        this.haspostprocessed = false;
        AnalysisLogger.getLogger().info((Object)"Initializing DB Connection");
        this.dbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)config);
        List families = DatabaseFactory.executeSQLQuery((String)DatabaseUtils.getDinstictElements((String)this.originTable, (String)this.familyColumn, (String)""), (SessionFactory)this.dbconnection);
        this.count = families.size();
        this.prevmaxMessages = D4ScienceDistributedProcessing.maxMessagesAllowedPerJob;
        D4ScienceDistributedProcessing.maxMessagesAllowedPerJob = 1;
        this.prevbroadcastTimePeriod = QueueJobManager.broadcastTimePeriod;
        QueueJobManager.broadcastTimePeriod = 14400000;
        this.prevmaxNumberOfStages = QueueJobManager.maxNumberOfStages;
        QueueJobManager.maxNumberOfStages = 10000;
        AnalysisLogger.getLogger().info((Object)("Creating Destination Table " + this.destinationTable));
        try {
            DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)this.destinationTable), (SessionFactory)this.dbconnection);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().info((Object)("Table " + this.destinationTable + " did not exist"));
        }
        DatabaseFactory.executeSQLUpdate((String)String.format(createOutputTable, this.destinationTable), (SessionFactory)this.dbconnection);
        AnalysisLogger.getLogger().info((Object)("Destination Table Created! Addressing " + this.count + " species"));
    }

    public int getNumberOfRightElements() {
        return this.count;
    }

    public int getNumberOfLeftElements() {
        return 1;
    }

    public void stop() {
        if (!this.haspostprocessed) {
            try {
                AnalysisLogger.getLogger().info((Object)("The procedure did NOT correctly postprocessed ....Removing Table " + this.destinationTable + " because of computation stop!"));
                DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)this.destinationTable), (SessionFactory)this.dbconnection);
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().info((Object)("Table " + this.destinationTable + " did not exist"));
            }
        } else {
            AnalysisLogger.getLogger().info((Object)"The procedure has correctly postprocessed: shutting down the connection!");
        }
        if (this.dbconnection != null) {
            try {
                this.dbconnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void postProcess(boolean manageDuplicates, boolean manageFault) {
        QueueJobManager.broadcastTimePeriod = this.prevbroadcastTimePeriod;
        QueueJobManager.maxNumberOfStages = this.prevmaxNumberOfStages;
        D4ScienceDistributedProcessing.maxMessagesAllowedPerJob = this.prevmaxMessages;
        this.haspostprocessed = true;
    }
}

