/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.nodes.algorithms;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.ActorNode;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.gcube.dataanalysis.ecoengine.utils.Transformations;
import org.gcube.dataanalysis.executor.scripts.OSCommand;
import org.gcube.dataanalysis.executor.util.RScriptsManager;
import org.gcube.dataanalysis.executor.util.StorageUtils;

public class FAOMSY
extends ActorNode {
    public int count;
    public float status = 0.0f;
    static String stocksFile = "StocksFile";
    static String processOutput = "ProcessOutput";
    static String nonProcessedOutput = "NonProcessedOutput";
    static String scriptName = "CatchMSY_Dec2014.R";
    AlgorithmConfiguration config;
    int nstocks = 0;
    boolean haspostprocessed = false;

    public ALG_PROPS[] getProperties() {
        ALG_PROPS[] p = new ALG_PROPS[]{ALG_PROPS.PHENOMENON_VS_PARALLEL_PHENOMENON};
        return p;
    }

    public String getName() {
        return "FAOMSY";
    }

    public String getDescription() {
        return "An algorithm to estimate the Maximum Sustainable Yield from a catch statistic by FAO.";
    }

    public List<StatisticalType> getInputParameters() {
        ArrayList<StatisticalType> parameters = new ArrayList<StatisticalType>();
        IOHelper.addStringInput(parameters, (String)stocksFile, (String)"Http link to a file containing catch statistics for a group of species. Example: http://goo.gl/g6YtVx", (String)"");
        return parameters;
    }

    public StatisticalType getOutput() {
        File outfile = new File(this.config.getPersistencePath(), this.config.getParam(processOutput));
        File outfile2 = new File(this.config.getPersistencePath(), this.config.getParam(nonProcessedOutput));
        PrimitiveTypesList list = new PrimitiveTypesList(File.class.getName(), PrimitiveTypes.FILE, "OutputFiles", "Textual output files - processed and non-processed species", false);
        if (outfile.exists()) {
            PrimitiveType o = new PrimitiveType(File.class.getName(), (Object)outfile, PrimitiveTypes.FILE, "ProcessedSpecies", "Output file");
            list.add(o);
        }
        if (outfile2.exists()) {
            PrimitiveType o2 = new PrimitiveType(File.class.getName(), (Object)outfile2, PrimitiveTypes.FILE, "NonProcessedSpecies", "Output file");
            list.add(o2);
        }
        return list;
    }

    public void initSingleNode(AlgorithmConfiguration config) {
    }

    public float getInternalStatus() {
        return this.status;
    }

    public int executeNode(int leftStartIndex, int numberOfLeftElementsToProcess, int rightStartIndex, int numberOfRightElementsToProcess, boolean duplicate, String sandboxFolder, String nodeConfigurationFileObject, String logfileNameToProduce) {
        try {
            this.status = 0.0f;
            this.config = Transformations.restoreConfig((String)nodeConfigurationFileObject);
            String outputFile = String.valueOf(this.config.getParam(processOutput)) + "_part" + rightStartIndex;
            String nonprocessedoutputFile = String.valueOf(this.config.getParam(nonProcessedOutput)) + "_part" + rightStartIndex;
            AnalysisLogger.getLogger().info((Object)("FAOMSY ranges:  Li:" + leftStartIndex + " NLi:" + leftStartIndex + " Ri:" + rightStartIndex + " NRi:" + numberOfRightElementsToProcess));
            AnalysisLogger.getLogger().info((Object)("FAOMSY expected output " + outputFile));
            File filestock = new File(sandboxFolder, "D20_1.csv");
            StorageUtils.downloadInputFile(this.config.getParam(stocksFile), filestock.getAbsolutePath());
            AnalysisLogger.getLogger().debug((Object)("Check fileStocks: " + filestock.getAbsolutePath() + " " + filestock.exists()));
            File filestocksub = new File(sandboxFolder, "D20.csv");
            StorageUtils.FileSubset(filestock, filestocksub, rightStartIndex, numberOfRightElementsToProcess, true);
            RScriptsManager scriptmanager = new RScriptsManager();
            HashMap<String, String> codeinj = new HashMap<String, String>();
            this.config.setConfigPath("./");
            scriptmanager.executeRScript(this.config, scriptName, "", new HashMap<String, String>(), "", "CatchMSY_Output.csv", codeinj, false, false, false);
            AnalysisLogger.getLogger().info((Object)"FAOMSY The script has finished");
            String outputFileName = "";
            try {
                outputFileName = scriptmanager.getCurrentOutputFileName();
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().info((Object)"FAOMSY Could not get curent output file");
            }
            String optionalFileOutputName = "NonProcessedSpecies.csv";
            if (outputFileName != null && outputFileName.length() > 0 && new File(outputFileName).exists()) {
                AnalysisLogger.getLogger().info((Object)"FAOMSY Main file exists!");
                outputFileName = scriptmanager.getCurrentOutputFileName();
                String outputFilePath = new File(sandboxFolder, outputFile).getAbsolutePath();
                AnalysisLogger.getLogger().info((Object)("FAOMSY writing output file in path " + outputFilePath));
                OSCommand.FileCopy(outputFileName, outputFilePath);
                AnalysisLogger.getLogger().info((Object)("FAOMSY uploading output file " + outputFile));
                StorageUtils.uploadFilesOnStorage(this.config.getGcubeScope(), this.config.getParam("ServiceUserName"), sandboxFolder, outputFile);
            }
            if (new File(optionalFileOutputName).exists()) {
                AnalysisLogger.getLogger().info((Object)"FAOMSY Optional file exists!");
                OSCommand.FileCopy(optionalFileOutputName, nonprocessedoutputFile);
                AnalysisLogger.getLogger().info((Object)("FAOMSY uploading output file " + nonprocessedoutputFile));
                StorageUtils.uploadFilesOnStorage(this.config.getGcubeScope(), this.config.getParam("ServiceUserName"), sandboxFolder, nonprocessedoutputFile);
            }
            AnalysisLogger.getLogger().info((Object)"FAOMSY Finished");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public void setup(AlgorithmConfiguration config) throws Exception {
        this.config = config;
        AnalysisLogger.getLogger().info((Object)"FAOMSY process is initialized");
        String uuid = (UUID.randomUUID() + ".txt").replace("-", "");
        config.setParam(processOutput, "FAOMSY_output_" + uuid);
        config.setParam(nonProcessedOutput, "FAOMSY_nonprocessed_output_" + uuid);
        File tempfile = new File(config.getPersistencePath(), "FAOMSY_input_" + (UUID.randomUUID() + ".csv").replace("-", ""));
        StorageUtils.downloadInputFile(config.getParam(stocksFile), tempfile.getAbsolutePath());
        this.nstocks = StorageUtils.calcFileRows(tempfile, true);
        AnalysisLogger.getLogger().info((Object)("FAOMSY Found " + this.nstocks + " stocks!"));
        if (this.nstocks == 0) {
            throw new Exception("Error in FAOMSY: No stocks to process found in the file " + config.getParam(stocksFile));
        }
    }

    public int getNumberOfRightElements() {
        return this.nstocks;
    }

    public int getNumberOfLeftElements() {
        return 1;
    }

    public void stop() {
        AnalysisLogger.getLogger().info((Object)"CMSY process stopped");
    }

    public void assembleFiles(String outputFileName) throws Exception {
        ArrayList<String> fileslist = new ArrayList<String>();
        int i = 0;
        while (i <= this.nstocks) {
            String filename = String.valueOf(outputFileName) + "_part" + i;
            try {
                StorageUtils.downloadFilefromStorage(this.config.getGcubeScope(), this.config.getParam("ServiceUserName"), this.config.getPersistencePath(), filename);
                AnalysisLogger.getLogger().debug((Object)("FAOMSY - Saved from Storage: " + filename));
                fileslist.add(filename);
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().debug((Object)("FAOMSY - Did not save file from Storage: " + filename));
            }
            ++i;
        }
        AnalysisLogger.getLogger().debug((Object)("FAOMSY - Merging files in " + outputFileName));
        if (fileslist.size() > 0) {
            StorageUtils.mergeFiles(this.config.getPersistencePath(), fileslist, outputFileName, true);
        }
        AnalysisLogger.getLogger().debug((Object)"FAOMSY - Deleting parts");
        for (String file : fileslist) {
            new File(this.config.getPersistencePath(), file).delete();
        }
        AnalysisLogger.getLogger().debug((Object)"FAOMSY - File assembling complete");
    }

    public void postProcess(boolean manageDuplicates, boolean manageFault) {
        try {
            String mainOutputfilename = this.config.getParam(processOutput);
            String optionalOutputfilename = this.config.getParam(nonProcessedOutput);
            this.assembleFiles(mainOutputfilename);
            this.assembleFiles(optionalOutputfilename);
            AnalysisLogger.getLogger().debug((Object)"FAOMSY - Postprocess complete");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

