package org.gcube.dataanalysis.copernicus.motu.model;

import java.io.StringReader;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Helper class to unmarshal xml representations to java objects.
 * 
 * @author Paolo Fabriani
 *
 */
public class MotuUnmarshaller {

    /**
     * A logger for this class.
     */
    private static Logger logger = LoggerFactory.getLogger(MotuUnmarshaller.class);

    public static StatusModeResponse getStatusModeResponse(String xml)
            throws JAXBException {
        JAXBContext jaxbContext = JAXBContext
                .newInstance(StatusModeResponse.class);
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        StringReader reader = new StringReader(xml);
        return (StatusModeResponse) unmarshaller.unmarshal(reader);
    }

    public static RequestSize getRequestSize(String xml) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance(RequestSize.class);
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        StringReader reader = new StringReader(xml);
        return (RequestSize) unmarshaller.unmarshal(reader);
    }

    public static ProductMetadataInfo getProductMetadataInfo(String xml)
            throws JAXBException, Exception {
        JAXBContext jaxbContext = JAXBContext
                .newInstance(ProductMetadataInfo.class);
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        StringReader reader = new StringReader(xml);
        try {
            return (ProductMetadataInfo) unmarshaller.unmarshal(reader);
        } catch(JAXBException e) {
            logger.debug(xml);
            if(xml.contains("006-29 : The requested product/dataset is unknown")) {
                throw new Exception("Unknown dataset");
            } else {
                throw e;
            }
        }
    }

}
