/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.motu.client;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import org.apache.commons.io.FileUtils;
import org.gcube.dataanalysis.copernicus.motu.client.DownloadRequestEnvelope;
import org.gcube.dataanalysis.copernicus.motu.client.ThreadedWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadedDownloader
extends ThreadedWorker<DownloadRequestEnvelope> {
    private static Logger logger = LoggerFactory.getLogger(ThreadedDownloader.class);
    private static final String DEFAULT_DOWNLOAD_DIR = "/tmp";
    private File destinationDir;

    @Override
    public void doWork(DownloadRequestEnvelope chunk) throws MalformedURLException, IOException {
        URL source = new URL(chunk.getStatus().getRemoteUri());
        File destination = new File(this.getDestinationDir(), chunk.getName() + ".nc");
        logger.info("downloading from " + source + " to " + destination);
        chunk.setDownloadStatus("downloading");
        FileUtils.copyURLToFile((URL)source, (File)destination);
        logger.info("download of " + destination.getName() + " complete.");
        chunk.setDownloadStatus("downloaded");
        chunk.setEnd(Calendar.getInstance());
    }

    public File getDestinationDir() {
        if (this.destinationDir != null) {
            return this.destinationDir;
        }
        return new File(DEFAULT_DOWNLOAD_DIR);
    }

    public void setDestinationDir(File dir) {
        this.destinationDir = dir;
    }
}

