/**
 * 
 */
package org.gcube.dataanalysis.copernicus.cmems.model;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author Paolo Fabriani
 *
 */
@XmlRootElement
public class CmemsVariable implements Comparable<CmemsVariable> {

    private String name;

    public CmemsVariable() {
    }

    @XmlElement
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int compareTo(CmemsVariable other) {
        return this.name.compareTo(other.name);
    }

    public boolean equals(CmemsVariable other) {
        return this.name.equals(other.name);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
