/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.motu.model;

import java.text.ParseException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.gcube.dataanalysis.datasetimporter.util.SizeUtils;

@XmlRootElement
public class RequestSize {
    private String code;
    private String message;
    private String unit;
    private String size;
    private String maxAllowedSize;

    @XmlAttribute
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @XmlAttribute
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @XmlAttribute
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    @XmlAttribute
    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    @XmlAttribute
    public String getMaxAllowedSize() {
        return this.maxAllowedSize;
    }

    public void setMaxAllowedSize(String maxAllowedSize) {
        this.maxAllowedSize = maxAllowedSize;
    }

    public Long getSizeInBytes() throws ParseException {
        return SizeUtils.parse((String)(this.getSize() + " " + this.getUnit().toUpperCase()));
    }

    public Long getMaxAllowedSizeInBytes() throws ParseException {
        return SizeUtils.parse((String)(this.getMaxAllowedSize() + " " + this.getUnit().toUpperCase()));
    }

    public Double getFitRatio() throws ParseException {
        return 1.0 * (double)this.getMaxAllowedSizeInBytes().longValue() / (1.0 * (double)this.getSizeInBytes().longValue());
    }

    public boolean isValid() throws ParseException {
        return this.getSizeInBytes() < this.getMaxAllowedSizeInBytes();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

