/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.motu.util;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import org.gcube.dataanalysis.copernicus.motu.client.CASClient;
import org.gcube.dataanalysis.copernicus.motu.client.MultiValueParameters;
import org.gcube.dataanalysis.datasetimporter.util.TextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtils {
    private static Logger logger = LoggerFactory.getLogger(NetworkUtils.class);

    public static String getDataString(MultiValueParameters params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        if (params == null) {
            return result.toString();
        }
        for (String key : params.keySet()) {
            Collection<String> value = params.get(key);
            Iterator<String> iter = value.iterator();
            while (iter.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    result.append("&");
                }
                result.append(URLEncoder.encode(key, "UTF-8"));
                result.append("=");
                result.append(URLEncoder.encode(iter.next(), "UTF-8"));
            }
        }
        return result.toString();
    }

    public static String doGet(String url, CASClient casProxy) throws Exception {
        String inputLine;
        logger.debug("GET-ing: " + TextUtil.removePasswords((String)url));
        URL u = new URL(url);
        HttpURLConnection con = (HttpURLConnection)u.openConnection();
        con.setRequestMethod("GET");
        int responseCode = con.getResponseCode();
        if (responseCode == 302) {
            String location = con.getHeaderField("Location");
            logger.debug("I've been redirected to " + TextUtil.removePasswords((String)location));
            if (casProxy.isAuthnEndpoint(location)) {
                logger.debug("setting the CAS endpoint");
                casProxy.setEndpoint(location);
                String redirectUrl = casProxy.authenticateForURL(url);
                logger.info("redirecting to " + TextUtil.removePasswords((String)redirectUrl));
                return NetworkUtils.doGet(redirectUrl, casProxy);
            }
            return NetworkUtils.doGet(location, casProxy);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    public static String post(String url, MultiValueParameters parameters) throws Exception {
        int c;
        logger.debug("POST-ing data to " + TextUtil.removePasswords((String)url));
        byte[] postData = NetworkUtils.getDataString(parameters).getBytes(StandardCharsets.UTF_8);
        URL u = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)u.openConnection();
        conn.setDoOutput(true);
        conn.setInstanceFollowRedirects(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("charset", "utf-8");
        conn.setRequestProperty("Content-Length", new Integer(postData.length).toString());
        conn.setUseCaches(false);
        try (DataOutputStream wr = new DataOutputStream(conn.getOutputStream());){
            wr.write(postData);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        StringBuilder sb = new StringBuilder();
        while ((c = ((Reader)in).read()) >= 0) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    static {
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
    }
}

