/**
 * 
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.api;

import javax.xml.bind.annotation.XmlEnumValue;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * The length of a dataset chunk as imported on THREDDS.
 * @author Paolo Fabriani
 *
 */
public enum ChunkTimespan {

    @XmlEnumValue("day")
    DAY("day"),
    
    @XmlEnumValue("month")
    MONTH("month"),

    @XmlEnumValue("year")
    YEAR("year"); 

    private final String code;
    
    private ChunkTimespan(String code) {
        this.code = code;
    }
    
    public static ChunkTimespan fromString(String s) throws Exception {
        if(s==null)
            throw new Exception("invalid timespan code: " + s);
        s = s.trim();
        if(DAY.toString().equalsIgnoreCase(s))
            return DAY;
        if(MONTH.toString().equalsIgnoreCase(s))
            return MONTH;
        if(YEAR.toString().equalsIgnoreCase(s))
            return YEAR;
        throw new Exception("invalid timespan code: " + s);
    }
    
    public String toString() {
        return this.code;
    }
    
}

