/**
 * 
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.task;

import java.util.Calendar;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author Paolo Fabriani
 *
 */
@XmlRootElement
public class SubmissionInfo {

    /**
     * The gcube scope where the task was scheduled
     */
    private String scope;
    
    /**
     * The token of the user/application scheduling the task
     */
    private String token;
    
    /**
     * The user who scheduled the task
     */
    private String user;
    
    /**
     * The time when the task was scheduled
     */
    private Calendar scheduled;

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Calendar getScheduled() {
        return scheduled;
    }

    public void setScheduled(Calendar scheduled) {
        this.scheduled = scheduled;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
