/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.api;

public enum ChunkTimespan {
    DAY("day"),
    MONTH("month"),
    YEAR("year");

    private final String code;

    private ChunkTimespan(String code) {
        this.code = code;
    }

    public static ChunkTimespan fromString(String s) throws Exception {
        if (s == null) {
            throw new Exception("invalid timespan code: " + s);
        }
        s = s.trim();
        if (DAY.toString().equalsIgnoreCase(s)) {
            return DAY;
        }
        if (MONTH.toString().equalsIgnoreCase(s)) {
            return MONTH;
        }
        if (YEAR.toString().equalsIgnoreCase(s)) {
            return YEAR;
        }
        throw new Exception("invalid timespan code: " + s);
    }

    public String toString() {
        return this.code;
    }
}

